/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.model;

import java.util.Properties;

public class LookupProperties {
    public static final String AUDIT_PRUNE_ENABLED = "dynamiclookup.audit.prune.enabled";
    public static final String AUDIT_PRUNE_RETENTION_DAYS = "dynamiclookup.audit.prune.retentionDays";
    public static final String ADVANCED_SEARCH_SAVED_FILTERS = "dynamiclookup.advancedSearch.savedFilters";
    private boolean auditPruneEnabled;
    private int auditPruneRetentionDays;
    private String advancedSearchSavedFiltersJson;

    public LookupProperties(boolean bl, int n, String string) {
        this.auditPruneEnabled = bl;
        this.auditPruneRetentionDays = n;
        this.advancedSearchSavedFiltersJson = string;
    }

    public boolean isAuditPruneEnabled() {
        return this.auditPruneEnabled;
    }

    public void setAuditPruneEnabled(boolean bl) {
        this.auditPruneEnabled = bl;
    }

    public int getAuditPruneRetentionDays() {
        return this.auditPruneRetentionDays;
    }

    public void setAuditPruneRetentionDays(int n) {
        this.auditPruneRetentionDays = n;
    }

    public String getAdvancedSearchSavedFiltersJson() {
        return this.advancedSearchSavedFiltersJson;
    }

    public void setAdvancedSearchSavedFiltersJson(String string) {
        this.advancedSearchSavedFiltersJson = string;
    }

    public Properties toAuditPruneProperties() {
        Properties properties = new Properties();
        properties.setProperty(AUDIT_PRUNE_ENABLED, Boolean.toString(this.auditPruneEnabled));
        properties.setProperty(AUDIT_PRUNE_RETENTION_DAYS, Integer.toString(this.auditPruneRetentionDays));
        return properties;
    }

    public Properties toAdvancedSearchFilterProperties() {
        Properties properties = new Properties();
        properties.setProperty(ADVANCED_SEARCH_SAVED_FILTERS, this.advancedSearchSavedFiltersJson != null ? this.advancedSearchSavedFiltersJson : "[]");
        return properties;
    }

    public static LookupProperties fromProperties(Properties properties) {
        int n;
        if (properties == null) {
            return LookupProperties.getDefault();
        }
        boolean bl = Boolean.parseBoolean(properties.getProperty(AUDIT_PRUNE_ENABLED, "false"));
        try {
            n = Integer.parseInt(properties.getProperty(AUDIT_PRUNE_RETENTION_DAYS, "30"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 30;
        }
        String string = properties.getProperty(ADVANCED_SEARCH_SAVED_FILTERS, "[]");
        return new LookupProperties(bl, n, string);
    }

    public static LookupProperties getDefault() {
        return new LookupProperties(false, 30, "[]");
    }

    private LookupProperties() {
    }
}

