/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.validation;

import com.mirth.connect.plugins.dynamiclookup.shared.capability.LookupJsonCapability;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonCondition;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonOperator;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonValueType;
import java.math.BigDecimal;
import java.util.List;

public final class AdvancedJsonFilterValidator {
    private AdvancedJsonFilterValidator() {
    }

    public static void validateCore(List<JsonCondition> list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string;
            String string2;
            JsonCondition jsonCondition = list.get(i);
            if (jsonCondition == null) continue;
            int n = i + 1;
            String string3 = jsonCondition.getField() != null ? jsonCondition.getField().trim() : "";
            String string4 = string2 = jsonCondition.getValue() != null ? jsonCondition.getValue().toString().trim() : "";
            if (string3.isEmpty()) {
                throw new IllegalArgumentException("Condition " + n + ": Field cannot be empty.");
            }
            if (jsonCondition.getOp() == null) {
                throw new IllegalArgumentException("Condition " + n + ": Operator is required.");
            }
            if (jsonCondition.getValueType() == null) {
                throw new IllegalArgumentException("Condition " + n + ": Value type is required.");
            }
            if (string2.isEmpty()) {
                throw new IllegalArgumentException("Condition " + n + ": Value cannot be empty.");
            }
            if (!string3.matches("[A-Za-z0-9_.]+")) {
                throw new IllegalArgumentException("Condition " + n + ": Invalid JSON field path '" + string3 + "'. Only letters, digits, underscore (_), and dot (.) are allowed.");
            }
            if (string3.startsWith(".") || string3.endsWith(".") || string3.contains("..")) {
                throw new IllegalArgumentException("Condition " + n + ": Invalid JSON field path '" + string3 + "'.");
            }
            JsonValueType jsonValueType = jsonCondition.getValueType();
            JsonOperator jsonOperator = jsonCondition.getOp();
            if (jsonValueType == JsonValueType.STRING && !AdvancedJsonFilterValidator.isEqOrNe(jsonOperator)) {
                throw new IllegalArgumentException("Condition " + n + ": Operator " + String.valueOf((Object)jsonOperator) + " is not supported for type STRING (field='" + string3 + "').");
            }
            if (jsonValueType == JsonValueType.BOOLEAN && !AdvancedJsonFilterValidator.isEqOrNe(jsonOperator)) {
                throw new IllegalArgumentException("Condition " + n + ": Operator " + String.valueOf((Object)jsonOperator) + " is not supported for type BOOLEAN (field='" + string3 + "').");
            }
            if (jsonValueType == JsonValueType.NUMBER) {
                try {
                    new BigDecimal(string2);
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Condition " + n + ": Invalid NUMBER value for field '" + string3 + "': " + string2);
                }
            }
            if (jsonValueType != JsonValueType.BOOLEAN || "true".equals(string = string2.toLowerCase()) || "false".equals(string)) continue;
            throw new IllegalArgumentException("Condition " + n + ": Invalid BOOLEAN value for field '" + string3 + "': " + string2);
        }
    }

    public static void validateForDialect(List<JsonCondition> list, LookupJsonCapability lookupJsonCapability) {
        AdvancedJsonFilterValidator.validateCore(list);
        if (list == null || list.isEmpty()) {
            return;
        }
        if (lookupJsonCapability == null) {
            return;
        }
        if (!lookupJsonCapability.isJsonSupported()) {
            throw new IllegalArgumentException("JSON filtering is not supported for database " + String.valueOf((Object)lookupJsonCapability.getDatabaseInfo().getType()));
        }
        for (int i = 0; i < list.size(); ++i) {
            JsonCondition jsonCondition = list.get(i);
            if (jsonCondition == null) continue;
            int n = i + 1;
            String string = jsonCondition.getField();
            JsonValueType jsonValueType = jsonCondition.getValueType();
            JsonOperator jsonOperator = jsonCondition.getOp();
            if (!lookupJsonCapability.supportsValueType(jsonValueType)) {
                throw new IllegalArgumentException("Condition " + n + ": Value type " + String.valueOf((Object)jsonValueType) + " is not supported by database " + String.valueOf((Object)lookupJsonCapability.getDatabaseInfo().getType()) + " (field='" + string + "').");
            }
            if (lookupJsonCapability.supportsOperator(jsonValueType, jsonOperator)) continue;
            throw new IllegalArgumentException("Condition " + n + ": Operator " + String.valueOf((Object)jsonOperator) + " is not supported for type " + String.valueOf((Object)jsonValueType) + " on database " + String.valueOf((Object)lookupJsonCapability.getDatabaseInfo().getType()) + " (field='" + string + "').");
        }
    }

    private static boolean isEqOrNe(JsonOperator jsonOperator) {
        return jsonOperator == JsonOperator.EQUAL || jsonOperator == JsonOperator.NOT_EQUAL;
    }
}

