/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NR;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.TX;

public class RFR
extends AbstractComposite {
    private Type[] data;

    public RFR(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[7];
        this.data[0] = new NR(this.getMessage());
        this.data[1] = new IS(this.getMessage(), 1);
        this.data[2] = new NR(this.getMessage());
        this.data[3] = new NR(this.getMessage());
        this.data[4] = new ST(this.getMessage());
        this.data[5] = new ST(this.getMessage());
        this.data[6] = new TX(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public NR getNumericRange() {
        return (NR)this.getTyped(0, NR.class);
    }

    public NR getRfr1_NumericRange() {
        return (NR)this.getTyped(0, NR.class);
    }

    public IS getAdministrativeSex() {
        return (IS)this.getTyped(1, IS.class);
    }

    public IS getRfr2_AdministrativeSex() {
        return (IS)this.getTyped(1, IS.class);
    }

    public NR getAgeRange() {
        return (NR)this.getTyped(2, NR.class);
    }

    public NR getRfr3_AgeRange() {
        return (NR)this.getTyped(2, NR.class);
    }

    public NR getGestationalAgeRange() {
        return (NR)this.getTyped(3, NR.class);
    }

    public NR getRfr4_GestationalAgeRange() {
        return (NR)this.getTyped(3, NR.class);
    }

    public ST getSpecies() {
        return (ST)this.getTyped(4, ST.class);
    }

    public ST getRfr5_Species() {
        return (ST)this.getTyped(4, ST.class);
    }

    public ST getRaceSubspecies() {
        return (ST)this.getTyped(5, ST.class);
    }

    public ST getRfr6_RaceSubspecies() {
        return (ST)this.getTyped(5, ST.class);
    }

    public TX getConditions() {
        return (TX)this.getTyped(6, TX.class);
    }

    public TX getRfr7_Conditions() {
        return (TX)this.getTyped(6, TX.class);
    }
}

