/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.model.filters.EventFilter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/events")
@Tag(name="Events")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface EventServletInterface
extends BaseServletInterface {
    @GET
    @Path(value="/maxEventId")
    @Operation(summary="Returns the maximum event ID currently in the database.")
    @MirthOperation(name="getMaxEventId", display="Get max event ID", permission="viewEvents", auditable=false)
    @Produces(value={"application/json", "text/plain"})
    public Integer getMaxEventId() throws ClientException;

    @GET
    @Path(value="/{eventId}")
    @Operation(summary="Retrieves an event by ID.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="serverEvent", ref="../apiexamples/server_event_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="serverEvent", ref="../apiexamples/server_event_json")})})
    @MirthOperation(name="getEvent", display="Get event by ID", permission="viewEvents", auditable=false, abortable=true)
    public ServerEvent getEvent(@Param(value="eventId") @Parameter(description="The ID of the event.", required=true) @PathParam(value="eventId") Integer var1) throws ClientException;

    @POST
    @Path(value="/_search")
    @Operation(summary="Search for events by specific filter criteria.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="serverEventList", ref="../apiexamples/server_event_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="serverEventList", ref="../apiexamples/server_event_list_json")})})
    @MirthOperation(name="getEvents", display="Get events", permission="viewEvents", auditable=false, abortable=true)
    public List<ServerEvent> getEvents(@Param(value="filter") @RequestBody(description="The EventFilter object to use to query events by.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="filter", ref="../apiexamples/event_filter_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="filter", ref="../apiexamples/event_filter_json")})}) EventFilter var1, @Param(value="offset") @Parameter(description="Used for pagination, determines where to start in the search results.", schema=@Schema(defaultValue="0")) @QueryParam(value="offset") Integer var2, @Param(value="limit") @Parameter(description="Used for pagination, determines the maximum number of results to return.", schema=@Schema(defaultValue="20")) @QueryParam(value="limit") Integer var3) throws ClientException;

    @GET
    @Path(value="/")
    @Operation(summary="Search for events by specific filter criteria.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="serverEventList", ref="../apiexamples/server_event_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="serverEventList", ref="../apiexamples/server_event_list_json")})})
    @MirthOperation(name="getEvents", display="Get events", permission="viewEvents", auditable=false, abortable=true)
    public List<ServerEvent> getEvents(@Param(value="maxEventId") @Parameter(description="The maximum event ID to query.") @QueryParam(value="maxEventId") Integer var1, @Param(value="minEventId") @Parameter(description="The minimum event ID to query.") @QueryParam(value="minEventId") Integer var2, @Param(value="levels") @Parameter(description="The type of events to query.") @QueryParam(value="level") Set<ServerEvent.Level> var3, @Param(value="startDate") @Parameter(description="The earliest event date to query by. Example: 1985-10-26T09:00:00.000-0700") @QueryParam(value="startDate") Calendar var4, @Param(value="endDate") @Parameter(description="The latest event date to query by. Example: 2015-10-21T07:28:00.000-0700") @QueryParam(value="endDate") Calendar var5, @Param(value="name") @Parameter(description="Searches the event name for this string.") @QueryParam(value="name") String var6, @Param(value="outcome") @Parameter(description="Searches on whether the event outcome was successful or not.") @QueryParam(value="outcome") ServerEvent.Outcome var7, @Param(value="userId") @Parameter(description="The user ID to query events by.") @QueryParam(value="userId") Integer var8, @Param(value="attributeSearch") @Parameter(description="Searches the attributes for this string.") @QueryParam(value="attributeSearch") String var9, @Param(value="ipAddress") @Parameter(description="The IP address that originated the event.") @QueryParam(value="ipAddress") String var10, @Param(value="serverId") @Parameter(description="The ID of the server that the event was created from.") @QueryParam(value="serverId") String var11, @Param(value="offset") @Parameter(description="Used for pagination, determines where to start in the search results.", schema=@Schema(defaultValue="0")) @QueryParam(value="offset") Integer var12, @Param(value="limit") @Parameter(description="Used for pagination, determines the maximum number of results to return.", schema=@Schema(defaultValue="20")) @QueryParam(value="limit") Integer var13) throws ClientException;

    @POST
    @Path(value="/count/_search")
    @Operation(summary="Count number for events by specific filter criteria.")
    @MirthOperation(name="getEventCount", display="Get events results count", permission="viewEvents", auditable=false, abortable=true)
    @Produces(value={"application/json", "text/plain"})
    public Long getEventCount(@Param(value="filter") @RequestBody(description="The EventFilter object to use to query events by.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="filter", ref="../apiexamples/event_filter_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="filter", ref="../apiexamples/event_filter_json")})}) EventFilter var1) throws ClientException;

    @GET
    @Path(value="/count")
    @Operation(summary="Count number for events by specific filter criteria.")
    @MirthOperation(name="getEventCount", display="Get events results count", permission="viewEvents", auditable=false, abortable=true)
    @Produces(value={"application/json", "text/plain"})
    public Long getEventCount(@Param(value="maxEventId") @Parameter(description="The maximum event ID to query.") @QueryParam(value="maxEventId") Integer var1, @Param(value="minEventId") @Parameter(description="The minimum event ID to query.") @QueryParam(value="minEventId") Integer var2, @Param(value="levels") @Parameter(description="The type of events to query.") @QueryParam(value="level") Set<ServerEvent.Level> var3, @Param(value="startDate") @Parameter(description="The earliest event date to query by. Example: 1985-10-26T09:00:00.000-0700") @QueryParam(value="startDate") Calendar var4, @Param(value="endDate") @Parameter(description="The latest event date to query by. Example: 2015-10-21T07:28:00.000-0700") @QueryParam(value="endDate") Calendar var5, @Param(value="name") @Parameter(description="Searches the event name for this string.") @QueryParam(value="name") String var6, @Param(value="outcome") @Parameter(description="Searches on whether the event outcome was successful or not.") @QueryParam(value="outcome") ServerEvent.Outcome var7, @Param(value="userId") @Parameter(description="The user ID to query events by.") @QueryParam(value="userId") Integer var8, @Param(value="attributeSearch") @Parameter(description="Searches the attributes for this string.") @QueryParam(value="attributeSearch") String var9, @Param(value="ipAddress") @Parameter(description="The IP address that originated the event.") @QueryParam(value="ipAddress") String var10, @Param(value="serverId") @Parameter(description="The ID of the server that the event was created from.") @QueryParam(value="serverId") String var11) throws ClientException;

    @POST
    @Path(value="/_export")
    @Produces(value={"text/plain"})
    @Operation(summary="Exports all events to the application data directory on the server.")
    @MirthOperation(name="exportAllEvents", display="Export all events", permission="viewEvents")
    public String exportAllEvents() throws ClientException;
}

