/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.migration.Migratable;
import com.mirth.connect.donkey.util.purge.Purgable;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.Auditable;
import com.mirth.connect.model.Cacheable;
import com.mirth.connect.model.CalendarToStringStyle;
import com.mirth.connect.model.ChannelExportData;
import com.mirth.connect.model.ChannelProperties;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.ExportClearable;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.util.ColorUtil;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XStreamAlias(value="channel")
public class Channel
implements Serializable,
Auditable,
Migratable,
Purgable,
Cacheable<Channel>,
ExportClearable {
    private String id;
    private Integer nextMetaDataId;
    private String name;
    private String description;
    private int revision;
    private Connector sourceConnector;
    private List<Connector> destinationConnectors;
    private String preprocessingScript;
    private String postprocessingScript;
    private String deployScript;
    private String undeployScript;
    private ChannelProperties properties;
    private ChannelExportData exportData;

    public Channel() {
        this.destinationConnectors = new ArrayList<Connector>();
        this.properties = new ChannelProperties();
        this.nextMetaDataId = 1;
    }

    public Channel(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getNextMetaDataId() {
        return this.nextMetaDataId;
    }

    public void setNextMetaDataId(Integer nextMetaDataId) {
        this.nextMetaDataId = nextMetaDataId;
    }

    @Override
    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Connector getSourceConnector() {
        return this.sourceConnector;
    }

    public void setSourceConnector(Connector sourceConnector) {
        sourceConnector.setMetaDataId(0);
        this.sourceConnector = sourceConnector;
    }

    public List<Connector> getDestinationConnectors() {
        return this.destinationConnectors;
    }

    public void addDestination(Connector destinationConnector) {
        Integer n = this.nextMetaDataId;
        this.nextMetaDataId = this.nextMetaDataId + 1;
        destinationConnector.setMetaDataId(n);
        this.destinationConnectors.add(destinationConnector);
    }

    public List<Connector> getEnabledDestinationConnectors() {
        ArrayList<Connector> enabledConnectors = new ArrayList<Connector>();
        for (Connector connector : this.getDestinationConnectors()) {
            if (!connector.isEnabled()) continue;
            enabledConnectors.add(connector);
        }
        return enabledConnectors;
    }

    public String getPostprocessingScript() {
        return this.postprocessingScript;
    }

    public void setPostprocessingScript(String postprocessingScript) {
        this.postprocessingScript = postprocessingScript;
    }

    public String getPreprocessingScript() {
        return this.preprocessingScript;
    }

    public void setPreprocessingScript(String preprocessingScript) {
        this.preprocessingScript = preprocessingScript;
    }

    public String getDeployScript() {
        return this.deployScript;
    }

    public void setDeployScript(String deployScript) {
        this.deployScript = deployScript;
    }

    public String getUndeployScript() {
        return this.undeployScript;
    }

    public void setUndeployScript(String undeployScript) {
        this.undeployScript = undeployScript;
    }

    public ChannelProperties getProperties() {
        return this.properties;
    }

    public ChannelExportData getExportData() {
        if (this.exportData == null) {
            this.exportData = new ChannelExportData();
        }
        return this.exportData;
    }

    public void setExportData(ChannelExportData exportData) {
        this.exportData = exportData;
    }

    @Override
    public void clearExportData() {
        this.exportData = null;
    }

    @Override
    public Channel cloneIfNeeded() {
        return this;
    }

    public Channel clone() {
        Channel channel = new Channel();
        channel.setId(this.id);
        channel.setNextMetaDataId(this.nextMetaDataId);
        channel.setName(this.name);
        channel.setDescription(this.description);
        channel.setRevision(this.revision);
        channel.setSourceConnector(this.sourceConnector);
        channel.getDestinationConnectors().addAll(this.destinationConnectors);
        channel.setPreprocessingScript(this.preprocessingScript);
        channel.setPostprocessingScript(this.postprocessingScript);
        channel.setDeployScript(this.deployScript);
        channel.setUndeployScript(this.undeployScript);
        channel.properties = this.properties;
        channel.setExportData(this.exportData);
        return channel;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Channel)) {
            return false;
        }
        Channel channel = (Channel)that;
        return ObjectUtils.equals((Object)this.getId(), (Object)channel.getId()) && ObjectUtils.equals((Object)this.getName(), (Object)channel.getName()) && ObjectUtils.equals((Object)this.getDescription(), (Object)channel.getDescription()) && ObjectUtils.equals((Object)this.getRevision(), (Object)channel.getRevision()) && ObjectUtils.equals((Object)this.getSourceConnector(), (Object)channel.getSourceConnector()) && ObjectUtils.equals(this.getDestinationConnectors(), channel.getDestinationConnectors()) && ObjectUtils.equals((Object)this.getUndeployScript(), (Object)channel.getUndeployScript()) && ObjectUtils.equals((Object)this.getDeployScript(), (Object)channel.getDeployScript()) && ObjectUtils.equals((Object)this.getPostprocessingScript(), (Object)channel.getPostprocessingScript()) && ObjectUtils.equals((Object)this.getPreprocessingScript(), (Object)channel.getPreprocessingScript());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, (ToStringStyle)CalendarToStringStyle.instance()).append("name", (Object)this.name).toString();
    }

    @Override
    public String toAuditString() {
        return new ToStringBuilder((Object)this, (ToStringStyle)CalendarToStringStyle.instance()).append("id", (Object)this.id).append("name", (Object)this.name).toString();
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        DonkeyElement shutdownScript = element.getChildElement("shutdownScript");
        if (shutdownScript != null) {
            shutdownScript.setNodeName("undeployScript");
        }
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
        element.addChildElement("codeTemplateLibraries");
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
        DonkeyElement enabledElement = element.removeChild("enabled");
        DonkeyElement lastModifiedElement = element.removeChild("lastModified");
        DonkeyElement codeTemplateLibrariesElement = element.removeChild("codeTemplateLibraries");
        DonkeyElement dependentIdsElement = element.removeChild("dependentIds");
        DonkeyElement dependencyIdsElement = element.removeChild("dependencyIds");
        DonkeyElement propertiesElement = element.getChildElement("properties");
        if (propertiesElement != null) {
            DonkeyElement tagsElement;
            DonkeyElement exportDataElement = element.addChildElement("exportData");
            DonkeyElement metadataElement = exportDataElement.addChildElement("metadata");
            if (enabledElement != null) {
                metadataElement.addChildElement("enabled", enabledElement.getTextContent());
            }
            if (lastModifiedElement != null) {
                try {
                    metadataElement.addChildElementFromXml(lastModifiedElement.toXml());
                }
                catch (DonkeyElement.DonkeyElementException donkeyElementException) {
                    // empty catch block
                }
            }
            DonkeyElement pruningSettingsElement = metadataElement.addChildElement("pruningSettings");
            DonkeyElement pruneMetaDataDaysElement = propertiesElement.removeChild("pruneMetaDataDays");
            DonkeyElement pruneContentDaysElement = propertiesElement.removeChild("pruneContentDays");
            DonkeyElement archiveEnabledElement = propertiesElement.removeChild("archiveEnabled");
            if (pruneMetaDataDaysElement != null) {
                pruningSettingsElement.addChildElement("pruneMetaDataDays", pruneMetaDataDaysElement.getTextContent());
            }
            if (pruneContentDaysElement != null) {
                pruningSettingsElement.addChildElement("pruneContentDays", pruneContentDaysElement.getTextContent());
            }
            if (archiveEnabledElement != null) {
                pruningSettingsElement.addChildElement("archiveEnabled", archiveEnabledElement.getTextContent());
            }
            if ((tagsElement = propertiesElement.removeChild("tags")) != null) {
                String channelId = element.getChildElement("id").getTextContent();
                DonkeyElement migratedTags = exportDataElement.addChildElement("channelTags");
                Set tagSet = ObjectXMLSerializer.getInstance().deserialize(tagsElement.toString(), Set.class);
                migratedTags.setAttribute("class", "list");
                for (String tag : tagSet) {
                    DonkeyElement channelTag = migratedTags.addChildElement("channelTag");
                    channelTag.addChildElement("id", UUID.randomUUID().toString());
                    channelTag.addChildElement("name", ChannelTag.fixName(tag));
                    Color newColor = ColorUtil.getNewColor();
                    DonkeyElement bgColor = channelTag.addChildElement("backgroundColor");
                    bgColor.addChildElement("red", String.valueOf(newColor.getRed()));
                    bgColor.addChildElement("blue", String.valueOf(newColor.getBlue()));
                    bgColor.addChildElement("green", String.valueOf(newColor.getGreen()));
                    bgColor.addChildElement("alpha", String.valueOf(newColor.getAlpha()));
                    DonkeyElement channelIds = channelTag.addChildElement("channelIds");
                    channelIds.addChildElement("string", channelId);
                }
            }
            if (codeTemplateLibrariesElement != null) {
                try {
                    exportDataElement.addChildElementFromXml(codeTemplateLibrariesElement.toXml());
                }
                catch (DonkeyElement.DonkeyElementException donkeyElementException) {
                    // empty catch block
                }
            }
            if (dependentIdsElement != null) {
                try {
                    exportDataElement.addChildElementFromXml(dependentIdsElement.toXml());
                }
                catch (DonkeyElement.DonkeyElementException donkeyElementException) {
                    // empty catch block
                }
            }
            if (dependencyIdsElement != null) {
                try {
                    exportDataElement.addChildElementFromXml(dependencyIdsElement.toXml());
                }
                catch (DonkeyElement.DonkeyElementException donkeyElementException) {
                    // empty catch block
                }
            }
        }
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
        DonkeyElement pruningSettingsElement;
        DonkeyElement metadataElement;
        DonkeyElement exportDataElement;
        DonkeyElement propertiesElement = element.getChildElement("properties");
        if (propertiesElement != null && (exportDataElement = propertiesElement.getChildElement("exportData")) != null && (metadataElement = exportDataElement.getChildElement("metadata")) != null && (pruningSettingsElement = metadataElement.getChildElement("pruningSettings")) != null) {
            pruningSettingsElement.addChildElement("pruneErroredMessages", "false");
        }
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("id", this.id);
        purgedProperties.put("nextMetaDataId", this.nextMetaDataId);
        purgedProperties.put("nameChars", PurgeUtil.countChars((String)this.name));
        purgedProperties.put("descriptionChars", PurgeUtil.countChars((String)this.description));
        Map<String, Object> sourceProperties = this.sourceConnector.getPurgedProperties();
        sourceProperties.put("messageStatistics", PurgeUtil.getMessageStatistics((String)this.id, (Integer)this.sourceConnector.getMetaDataId()));
        purgedProperties.put("sourceConnector", sourceProperties);
        ArrayList<Map<String, Object>> purgedDestinationConnectors = new ArrayList<Map<String, Object>>();
        for (Connector connector : this.destinationConnectors) {
            Map<String, Object> destinationProperties = connector.getPurgedProperties();
            destinationProperties.put("messageStatistics", PurgeUtil.getMessageStatistics((String)this.id, (Integer)connector.getMetaDataId()));
            purgedDestinationConnectors.add(destinationProperties);
        }
        purgedProperties.put("destinationConnectors", purgedDestinationConnectors);
        purgedProperties.put("preprocessingScriptLines", PurgeUtil.countLines((String)this.preprocessingScript));
        purgedProperties.put("postprocessingScriptLines", PurgeUtil.countLines((String)this.postprocessingScript));
        purgedProperties.put("deployScriptLines", PurgeUtil.countLines((String)this.deployScript));
        purgedProperties.put("undeployScriptLines", PurgeUtil.countLines((String)this.undeployScript));
        purgedProperties.put("properties", this.properties.getPurgedProperties());
        purgedProperties.put("messageStatistics", PurgeUtil.getMessageStatistics((String)this.id, null));
        if (this.exportData != null) {
            purgedProperties.put("exportData", this.exportData.getPurgedProperties());
        }
        return purgedProperties;
    }
}

