/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.migration.Migratable;
import com.mirth.connect.donkey.util.purge.Purgable;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.CalendarToStringStyle;
import com.mirth.connect.model.Filter;
import com.mirth.connect.model.Transformer;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XStreamAlias(value="connector")
public class Connector
implements Serializable,
Migratable,
Purgable {
    private Integer metaDataId;
    private String name;
    private ConnectorProperties properties;
    private Transformer transformer;
    private Transformer responseTransformer;
    private Filter filter;
    private String transportName;
    private Mode mode;
    private boolean enabled;
    private boolean waitForPrevious = true;

    public Connector() {
    }

    public Connector(String name) {
        this.name = name;
    }

    public Integer getMetaDataId() {
        return this.metaDataId;
    }

    public void setMetaDataId(Integer metaDataId) {
        this.metaDataId = metaDataId;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public Transformer getResponseTransformer() {
        return this.responseTransformer;
    }

    public void setResponseTransformer(Transformer responseTransformer) {
        this.responseTransformer = responseTransformer;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String getTransportName() {
        return this.transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }

    public ConnectorProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ConnectorProperties properties) {
        this.properties = properties;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)CalendarToStringStyle.instance());
    }

    public boolean isWaitForPrevious() {
        return this.waitForPrevious;
    }

    public void setWaitForPrevious(boolean waitForPrevious) {
        this.waitForPrevious = waitForPrevious;
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        DonkeyElement processBatchElement;
        DonkeyElement transformer;
        DonkeyElement properties = element.getChildElement("properties");
        DonkeyElement responseProperties = properties.getChildElement("responseConnectorProperties");
        if (responseProperties != null && (transformer = element.getChildElement("transformer")) != null && StringUtils.equals((CharSequence)properties.getAttribute("class"), (CharSequence)"com.mirth.connect.connectors.file.FileReceiverProperties") && (processBatchElement = properties.getChildElement("processBatch")) != null) {
            DonkeyElement batchProperties;
            DonkeyElement splitByRecordElement;
            boolean processBatch = StringUtils.equals((CharSequence)processBatchElement.getTextContent(), (CharSequence)"true");
            DonkeyElement inboundProperties = transformer.getChildElement("inboundProperties");
            boolean delimitedDataType = StringUtils.equals((CharSequence)inboundProperties.getAttribute("class"), (CharSequence)"com.mirth.connect.plugins.datatypes.delimited.DelimitedDataTypeProperties");
            if (delimitedDataType && processBatch && (splitByRecordElement = (batchProperties = inboundProperties.getChildElement("batchProperties")).getChildElement("batchSplitByRecord")) != null) {
                boolean splitByRecord = StringUtils.equalsIgnoreCase((CharSequence)batchProperties.getChildElement("batchSplitByRecord").getTextContent(), (CharSequence)"true");
                boolean splitByDelimiter = StringUtils.isNotEmpty((CharSequence)batchProperties.getChildElement("batchMessageDelimiter").getTextContent());
                boolean splitByGroupingColumn = StringUtils.isNotEmpty((CharSequence)batchProperties.getChildElement("batchGroupingColumn").getTextContent());
                boolean splitByJavaScript = StringUtils.isNotEmpty((CharSequence)batchProperties.getChildElement("batchScript").getTextContent());
                if (!(splitByRecord || splitByDelimiter || splitByGroupingColumn || splitByJavaScript)) {
                    processBatchElement.setTextContent("false");
                }
            }
        }
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("metaDataId", this.metaDataId);
        purgedProperties.put("nameChars", PurgeUtil.countChars((String)this.name));
        purgedProperties.put("properties", this.properties.getPurgedProperties());
        purgedProperties.put("transformer", this.transformer.getPurgedProperties());
        purgedProperties.put("responseTransformer", this.transformer.getPurgedProperties());
        purgedProperties.put("filter", this.filter.getPurgedProperties());
        purgedProperties.put("transportName", this.transportName);
        purgedProperties.put("mode", (Object)this.mode);
        purgedProperties.put("enabled", this.enabled);
        purgedProperties.put("waitForPrevious", this.waitForPrevious);
        return purgedProperties;
    }

    public static enum Mode {
        SOURCE,
        DESTINATION;

    }
}

