/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.converters;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class DocumentSerializer {
    private Logger logger = LogManager.getLogger(this.getClass());
    private String[] cDataElements = null;
    private boolean omitXmlDeclaration = false;

    public DocumentSerializer() {
        this(null, false);
    }

    public DocumentSerializer(boolean omitXmlDeclaration) {
        this(null, omitXmlDeclaration);
    }

    public DocumentSerializer(String[] cDataElements) {
        this(cDataElements, false);
    }

    public DocumentSerializer(String[] cDataElements, boolean omitXmlDeclaration) {
        this.cDataElements = cDataElements;
        this.omitXmlDeclaration = omitXmlDeclaration;
    }

    public void toXML(Document source, Writer writer) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            try {
                factory.setAttribute("indent-number", new Integer(4));
            }
            catch (IllegalArgumentException ex) {
                this.logger.warn("Could not set Document Serializer attribute: indent-number", (Throwable)ex);
            }
            Transformer transformer = factory.newTransformer();
            if (this.omitXmlDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            } else {
                transformer.setOutputProperty("omit-xml-declaration", "no");
            }
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            if (source.getDoctype() != null) {
                String publicDoctype = source.getDoctype().getPublicId();
                String systemDoctype = source.getDoctype().getSystemId();
                if (publicDoctype != null && publicDoctype.length() > 0) {
                    transformer.setOutputProperty("doctype-public", publicDoctype);
                }
                if (systemDoctype != null && systemDoctype.length() > 0) {
                    transformer.setOutputProperty("doctype-system", systemDoctype);
                }
            }
            if (this.cDataElements != null) {
                StringBuilder cDataElementsString = new StringBuilder();
                for (int i = 0; i < this.cDataElements.length; ++i) {
                    cDataElementsString.append(this.cDataElements[i] + " ");
                }
                transformer.setOutputProperty("cdata-section-elements", cDataElementsString.toString());
            }
            transformer.transform(new DOMSource(source), new StreamResult(writer));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    public String toXML(Document source) {
        StringWriter writer = new StringWriter();
        this.toXML(source, writer);
        return ((Object)writer).toString();
    }

    public Document fromXML(String source) {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentSerializer.getSecureDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(new InputSource(new StringReader(source)));
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return document;
    }

    public static DocumentBuilderFactory getSecureDocumentBuilderFactory() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return dbf;
    }
}

