/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.converters;

import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.util.JsonXmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObjectJSONSerializer {
    private static final ObjectJSONSerializer instance = new ObjectJSONSerializer();
    private Logger logger = LogManager.getLogger(this.getClass());

    public static ObjectJSONSerializer getInstance() {
        return instance;
    }

    public void serialize(Object object, OutputStream outputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter xmlWriter = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        ObjectXMLSerializer.getInstance().serialize(object, xmlWriter);
        String xmlString = baos.toString();
        String jsonString = "";
        try {
            jsonString = JsonXmlUtil.xmlToJson(xmlString);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new SerializerException((Throwable)e);
        }
        outputStream.write(jsonString.getBytes());
    }

    public <T> T deserialize(String serializedObject, Class<T> expectedClass) {
        String xmlSerializedObject = "";
        try {
            xmlSerializedObject = JsonXmlUtil.jsonToXml(serializedObject);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new SerializerException((Throwable)e);
        }
        return ObjectXMLSerializer.getInstance().deserialize(xmlSerializedObject, expectedClass);
    }

    public <T> List<T> deserializeList(String serializedObject, Class<T> expectedListItemClass) {
        String xmlSerializedObject = "";
        try {
            xmlSerializedObject = JsonXmlUtil.jsonToXml(serializedObject);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new SerializerException((Throwable)e);
        }
        return ObjectXMLSerializer.getInstance().deserializeList(xmlSerializedObject, expectedListItemClass);
    }
}

