/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.filter;

import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelStatus;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.model.filter.SearchFilter;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ChannelNameSearchFilter
extends SearchFilter {
    private List<String> filteredNames;
    private boolean fuzzy;

    public ChannelNameSearchFilter(List<String> filteredNames, boolean fuzzy) {
        this.filteredNames = filteredNames;
        this.fuzzy = fuzzy;
    }

    @Override
    public List<String> getValues() {
        return this.filteredNames;
    }

    @Override
    public boolean acceptChannelId(String channelId) {
        return true;
    }

    @Override
    public boolean acceptChannelName(String channelName) {
        return this.accept(channelName);
    }

    @Override
    public boolean acceptChannel(Channel channel) {
        return this.acceptChannelName(channel.getName());
    }

    @Override
    public boolean acceptDashboardStatus(DashboardStatus status) {
        return this.accept(status.getName());
    }

    @Override
    public boolean acceptChannelStatus(ChannelStatus status) {
        return this.accept(status.getChannel().getName());
    }

    private boolean accept(String channelName) {
        for (String filteredName : this.filteredNames) {
            if (!(this.fuzzy ? !StringUtils.containsIgnoreCase((CharSequence)channelName, (CharSequence)filteredName) : !StringUtils.equals((CharSequence)channelName, (CharSequence)filteredName))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toDisplayString() {
        StringBuilder builder = new StringBuilder();
        Iterator<String> it = this.filteredNames.iterator();
        while (it.hasNext()) {
            builder.append(it.next());
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }
}

