/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.util;

import com.mirth.connect.client.core.Client;
import com.mirth.connect.model.util.DefaultVocabulary;
import com.mirth.connect.model.util.MessageVocabulary;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class MessageVocabularyFactory {
    private static MessageVocabularyFactory instance = null;
    private Map<String, Class<? extends MessageVocabulary>> vocabs = new HashMap<String, Class<? extends MessageVocabulary>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageVocabularyFactory getInstance(Client mirthClient, Map<String, Class<? extends MessageVocabulary>> vocabs) {
        Class<MessageVocabularyFactory> clazz = MessageVocabularyFactory.class;
        synchronized (MessageVocabularyFactory.class) {
            if (instance == null) {
                instance = new MessageVocabularyFactory(mirthClient, vocabs);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private MessageVocabularyFactory(Client mirthClient, Map<String, Class<? extends MessageVocabulary>> vocabs) {
        this.vocabs = vocabs;
    }

    public MessageVocabulary getVocabulary(String dataType, String version, String type) {
        Class<? extends MessageVocabulary> vocabulary = this.vocabs.get(dataType);
        MessageVocabulary vocab = null;
        if (vocabulary != null) {
            try {
                Constructor<?>[] constructors = vocabulary.getDeclaredConstructors();
                for (int i = 0; i < constructors.length; ++i) {
                    Class<?>[] parameters = constructors[i].getParameterTypes();
                    if (parameters.length != 2) continue;
                    vocab = (MessageVocabulary)constructors[i].newInstance(version, type);
                    i = constructors.length;
                }
                if (vocab != null) {
                    return vocab;
                }
                return new DefaultVocabulary(version, type);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new DefaultVocabulary(version, type);
            }
        }
        return new DefaultVocabulary(version, type);
    }
}

