/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.userutil;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.userutil.ContentType;
import com.mirth.connect.userutil.ImmutableMessageContent;
import com.mirth.connect.userutil.Response;
import com.mirth.connect.userutil.ResponseMap;
import com.mirth.connect.userutil.Status;
import java.lang.invoke.CallSite;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImmutableConnectorMessage {
    private static Logger logger = LogManager.getLogger(ImmutableConnectorMessage.class);
    private ConnectorMessage connectorMessage;
    private boolean modifiableMaps;
    private Map<String, Integer> destinationIdMap;
    private Serializer serializer;

    public ImmutableConnectorMessage(ConnectorMessage connectorMessage) {
        this(connectorMessage, false);
    }

    public ImmutableConnectorMessage(ConnectorMessage connectorMessage, boolean modifiableMaps) {
        this(connectorMessage, modifiableMaps, null);
    }

    public ImmutableConnectorMessage(ConnectorMessage connectorMessage, boolean modifiableMaps, Map<String, Integer> destinationIdMap) {
        this.connectorMessage = connectorMessage;
        this.modifiableMaps = modifiableMaps;
        this.destinationIdMap = destinationIdMap;
        this.serializer = ObjectXMLSerializer.getInstance();
    }

    public int getMetaDataId() {
        return this.connectorMessage.getMetaDataId();
    }

    public String getChannelId() {
        return this.connectorMessage.getChannelId();
    }

    public String getChannelName() {
        return this.connectorMessage.getChannelName();
    }

    public String getConnectorName() {
        return this.connectorMessage.getConnectorName();
    }

    public String getServerId() {
        return this.connectorMessage.getServerId();
    }

    public Calendar getReceivedDate() {
        return (Calendar)this.connectorMessage.getReceivedDate().clone();
    }

    public int getSendAttempts() {
        return this.connectorMessage.getSendAttempts();
    }

    public Calendar getSendDate() {
        return this.connectorMessage.getSendDate() == null ? null : (Calendar)this.connectorMessage.getSendDate().clone();
    }

    public Calendar getResponseDate() {
        return this.connectorMessage.getResponseDate() == null ? null : (Calendar)this.connectorMessage.getResponseDate().clone();
    }

    public Status getStatus() {
        return Status.fromDonkeyStatus(this.connectorMessage.getStatus());
    }

    public ImmutableMessageContent getMessageContent(ContentType contentType) {
        if (contentType == ContentType.SENT) {
            logger.error("The getSent() and getSentData() methods have been deprecated and will soon be removed. Please use map variables to retrieve post-replacement data instead. This method will always return null for the SENT content type.");
            return null;
        }
        if (this.connectorMessage.getMessageContent(contentType.toDonkeyContentType()) != null) {
            return new ImmutableMessageContent(this.connectorMessage.getMessageContent(contentType.toDonkeyContentType()));
        }
        return null;
    }

    @Deprecated
    public ImmutableMessageContent getContent(ContentType contentType) {
        logger.error("The getContent(contentType) method has been deprecated and will soon be removed. Please use getMessageContent(contentType) instead.");
        return this.getMessageContent(contentType);
    }

    public ImmutableMessageContent getRaw() {
        if (this.connectorMessage.getRaw() != null) {
            return new ImmutableMessageContent(this.connectorMessage.getRaw());
        }
        return null;
    }

    public String getRawData() {
        if (this.connectorMessage.getRaw() != null) {
            return this.connectorMessage.getRaw().getContent();
        }
        return null;
    }

    public ImmutableMessageContent getProcessedRaw() {
        if (this.connectorMessage.getProcessedRaw() != null) {
            return new ImmutableMessageContent(this.connectorMessage.getProcessedRaw());
        }
        return null;
    }

    public String getProcessedRawData() {
        if (this.connectorMessage.getProcessedRaw() != null) {
            return this.connectorMessage.getProcessedRaw().getContent();
        }
        return null;
    }

    public ImmutableMessageContent getTransformed() {
        if (this.connectorMessage.getTransformed() != null) {
            return new ImmutableMessageContent(this.connectorMessage.getTransformed());
        }
        return null;
    }

    public String getTransformedData() {
        if (this.connectorMessage.getTransformed() != null) {
            return this.connectorMessage.getTransformed().getContent();
        }
        return null;
    }

    public ImmutableMessageContent getEncoded() {
        if (this.connectorMessage.getEncoded() != null) {
            return new ImmutableMessageContent(this.connectorMessage.getEncoded());
        }
        return null;
    }

    public String getEncodedData() {
        if (this.connectorMessage.getEncoded() != null) {
            return this.connectorMessage.getEncoded().getContent();
        }
        return null;
    }

    public ImmutableMessageContent getResponse() {
        if (this.connectorMessage.getResponse() != null) {
            return new ImmutableMessageContent(this.connectorMessage.getResponse());
        }
        return null;
    }

    public Response getResponseData() {
        if (this.connectorMessage.getResponse() != null) {
            return new Response((com.mirth.connect.donkey.model.message.Response)this.serializer.deserialize(this.connectorMessage.getResponse().getContent(), com.mirth.connect.donkey.model.message.Response.class));
        }
        return null;
    }

    public ImmutableMessageContent getResponseTransformed() {
        if (this.connectorMessage.getResponseTransformed() != null) {
            return new ImmutableMessageContent(this.connectorMessage.getResponseTransformed());
        }
        return null;
    }

    public String getResponseTransformedData() {
        if (this.connectorMessage.getResponseTransformed() != null) {
            return this.connectorMessage.getResponseTransformed().getContent();
        }
        return null;
    }

    public ImmutableMessageContent getProcessedResponse() {
        if (this.connectorMessage.getProcessedResponse() != null) {
            return new ImmutableMessageContent(this.connectorMessage.getProcessedResponse());
        }
        return null;
    }

    public Response getProcessedResponseData() {
        if (this.connectorMessage.getProcessedResponse() != null) {
            return new Response((com.mirth.connect.donkey.model.message.Response)this.serializer.deserialize(this.connectorMessage.getProcessedResponse().getContent(), com.mirth.connect.donkey.model.message.Response.class));
        }
        return null;
    }

    public long getMessageId() {
        return this.connectorMessage.getMessageId();
    }

    public Map<String, Object> getSourceMap() {
        return this.connectorMessage.getSourceMap();
    }

    public Map<String, Object> getConnectorMap() {
        if (this.modifiableMaps) {
            return this.connectorMessage.getConnectorMap();
        }
        return Collections.unmodifiableMap(this.connectorMessage.getConnectorMap());
    }

    public Map<String, Object> getChannelMap() {
        if (this.modifiableMaps) {
            return this.connectorMessage.getChannelMap();
        }
        return Collections.unmodifiableMap(this.connectorMessage.getChannelMap());
    }

    public Map<String, Object> getResponseMap() {
        if (this.modifiableMaps) {
            return new ResponseMap(this.connectorMessage.getResponseMap(), this.destinationIdMap);
        }
        return new ResponseMap(Collections.unmodifiableMap(this.connectorMessage.getResponseMap()), this.destinationIdMap);
    }

    public String getPostProcessorError() {
        return this.connectorMessage.getPostProcessorError();
    }

    public String getProcessingError() {
        return this.connectorMessage.getProcessingError();
    }

    public String getResponseError() {
        return this.connectorMessage.getResponseError();
    }

    @Deprecated
    public Map<String, String> getDestinationNameMap() {
        logger.error("This method is deprecated and will soon be removed. Please use getDestinationIdMap() instead.");
        Map<String, CallSite> destinationNameMap = null;
        if (this.destinationIdMap != null) {
            destinationNameMap = new HashMap();
            for (Map.Entry<String, Integer> entry : this.destinationIdMap.entrySet()) {
                destinationNameMap.put(entry.getKey(), (CallSite)((Object)("d" + String.valueOf(entry.getValue()))));
            }
            destinationNameMap = Collections.unmodifiableMap(destinationNameMap);
        }
        return destinationNameMap;
    }

    public Map<String, Integer> getDestinationIdMap() {
        return this.destinationIdMap != null ? Collections.unmodifiableMap(this.destinationIdMap) : null;
    }

    public String toString() {
        return this.connectorMessage.toString();
    }
}

