/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import com.mirth.connect.util.DirectedAcyclicGraphException;
import com.mirth.connect.util.DirectedAcyclicGraphNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DirectedAcyclicGraph<E> {
    private Map<E, DirectedAcyclicGraphNode<E>> sinkNodes = new HashMap<E, DirectedAcyclicGraphNode<E>>();

    protected DirectedAcyclicGraphNode<E> createNode(E element) {
        return new DirectedAcyclicGraphNode<E>(element);
    }

    public void addDependency(E dependentElement, E dependencyElement) throws DirectedAcyclicGraphException {
        DirectedAcyclicGraphNode<E> matchingDependencyNode;
        DirectedAcyclicGraphNode<E> matchingDependentNode = this.getNode(dependentElement);
        if (matchingDependentNode != null) {
            if (matchingDependentNode.findDependentNode(dependencyElement) != null) {
                throw new DirectedAcyclicGraphException();
            }
        } else {
            matchingDependentNode = this.createNode(dependentElement);
            this.sinkNodes.put(dependentElement, matchingDependentNode);
        }
        if ((matchingDependencyNode = this.getNode(dependencyElement)) == null) {
            matchingDependencyNode = this.createNode(dependencyElement);
        }
        matchingDependentNode.putDependencyNode(matchingDependencyNode);
        matchingDependencyNode.putDependentNode(matchingDependentNode);
        this.sinkNodes.remove(dependencyElement);
    }

    public DirectedAcyclicGraphNode<E> getNode(E element) {
        DirectedAcyclicGraphNode<E> node = null;
        for (DirectedAcyclicGraphNode<E> sinkNode : this.sinkNodes.values()) {
            node = sinkNode.findDependencyNode(element);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public List<Set<E>> getOrderedElements() {
        ArrayList orderedElements = new ArrayList();
        for (Set<DirectedAcyclicGraphNode<E>> nodeSet : this.getOrderedNodes()) {
            HashSet<E> elementSet = new HashSet<E>();
            for (DirectedAcyclicGraphNode<E> node : nodeSet) {
                elementSet.add(node.getElement());
            }
            orderedElements.add(elementSet);
        }
        return orderedElements;
    }

    public List<Set<DirectedAcyclicGraphNode<E>>> getOrderedNodes() {
        ArrayList<Set<DirectedAcyclicGraphNode<E>>> orderedNodes = new ArrayList<Set<DirectedAcyclicGraphNode<E>>>();
        for (DirectedAcyclicGraphNode<E> sinkNode : this.sinkNodes.values()) {
            this.visit(sinkNode, orderedNodes, 0);
        }
        return orderedNodes;
    }

    private void visit(DirectedAcyclicGraphNode<E> node, List<Set<DirectedAcyclicGraphNode<E>>> orderedNodes, int depth) {
        Set<DirectedAcyclicGraphNode<Object>> set;
        int i;
        boolean foundHigher = false;
        boolean foundLower = false;
        for (i = 0; i < depth; ++i) {
            set = orderedNodes.get(i);
            if (!set.contains(node)) continue;
            set.remove(node);
            foundHigher = true;
            break;
        }
        if (!foundHigher) {
            for (i = depth; i < orderedNodes.size(); ++i) {
                set = orderedNodes.get(i);
                if (!set.contains(node)) continue;
                foundLower = true;
                break;
            }
        }
        if (!foundLower) {
            while (orderedNodes.size() <= depth) {
                orderedNodes.add(new HashSet());
            }
            orderedNodes.get(depth).add(node);
        }
        for (DirectedAcyclicGraphNode<E> dependencyNode : node.getDependencyNodes()) {
            this.visit(dependencyNode, orderedNodes, depth + 1);
        }
    }
}

