/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.manager;

import com.mirth.connect.manager.ManagerController;
import com.mirth.connect.manager.ManagerDialog;
import com.mirth.connect.manager.ManagerTray;
import com.mirth.connect.manager.PlatformUI;
import com.mirth.connect.manager.ServiceControllerFactory;
import javax.swing.UIManager;

public class Manager {
    private ManagerDialog dialog;
    private ManagerTray tray;
    private static Thread shutdownHook;

    public static void main(String[] args) {
        PlatformUI.MIRTH_PATH = args.length > 0 ? args[0] : "";
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIManager.put("win.xpstyle.name", "metallic");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Manager manager = new Manager();
        manager.setupDialog();
        manager.setupTray();
        try {
            ServiceControllerFactory.getServiceController().migrate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ManagerController.getInstance().updateMirthServiceStatus();
    }

    public Manager() {
        shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public static void shutdown() {
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
        System.exit(0);
    }

    private void setupDialog() {
        PlatformUI.MANAGER_DIALOG = this.dialog = new ManagerDialog();
        this.dialog.setupDialog();
    }

    private void setupTray() {
        PlatformUI.MANAGER_TRAY = this.tray = new ManagerTray();
        this.tray.setupTray();
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            Manager.shutdown();
        }
    }
}

