/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.manager;

import com.mirth.connect.client.core.Client;
import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.PropertiesConfigurationUtil;
import com.mirth.connect.donkey.util.ResourceUtil;
import com.mirth.connect.manager.CmdUtil;
import com.mirth.connect.manager.DisplayUtil;
import com.mirth.connect.manager.ManagerConstants;
import com.mirth.connect.manager.PlatformUI;
import com.mirth.connect.manager.ServiceController;
import com.mirth.connect.manager.ServiceControllerFactory;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ManagerController {
    private static ManagerController managerController = null;
    private static ServiceController serviceController = null;
    private ReloadingFileBasedConfigurationBuilder<PropertiesConfiguration> serverPropertiesBuilder;
    private ReloadingFileBasedConfigurationBuilder<PropertiesConfiguration> log4jPropertiesBuilder;
    private PropertiesConfiguration serverProperties;
    private PropertiesConfiguration log4jProperties;
    private PropertiesConfiguration versionProperties;
    private PropertiesConfiguration serverIdProperties;
    private boolean updating = false;

    public static ManagerController getInstance() {
        if (managerController == null) {
            managerController = new ManagerController();
            managerController.initialize();
            try {
                serviceController = ServiceControllerFactory.getServiceController();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        return managerController;
    }

    public void initialize() {
        this.serverPropertiesBuilder = this.initializeProperties(PlatformUI.MIRTH_PATH + ManagerConstants.PATH_SERVER_PROPERTIES, true);
        try {
            this.serverProperties = (PropertiesConfiguration)this.serverPropertiesBuilder.getConfiguration();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        this.log4jPropertiesBuilder = this.initializeProperties(PlatformUI.MIRTH_PATH + ManagerConstants.PATH_LOG4J_PROPERTIES, true, true);
        try {
            this.log4jProperties = (PropertiesConfiguration)this.log4jPropertiesBuilder.getConfiguration();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        try {
            this.serverIdProperties = (PropertiesConfiguration)this.initializeProperties(PlatformUI.MIRTH_PATH + this.getServerProperties().getString("dir.appdata") + System.getProperty("file.separator") + "server.id", false).getConfiguration();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        InputStream is = this.getClass().getResourceAsStream("version.properties");
        if (is != null) {
            try {
                this.versionProperties = PropertiesConfigurationUtil.create((InputStream)is);
            }
            catch (ConfigurationException e) {
                this.alertErrorDialog("Could not load resource: version.properties");
            }
            finally {
                ResourceUtil.closeResourceQuietly((Closeable)is);
            }
        } else {
            try {
                this.versionProperties = (PropertiesConfiguration)this.initializeProperties(PlatformUI.MIRTH_PATH + "version.properties", true).getConfiguration();
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    private ReloadingFileBasedConfigurationBuilder<PropertiesConfiguration> initializeProperties(String path, boolean alert) {
        return this.initializeProperties(path, alert, false);
    }

    private ReloadingFileBasedConfigurationBuilder<PropertiesConfiguration> initializeProperties(String path, boolean alert, boolean commaDelimited) {
        ReloadingFileBasedConfigurationBuilder builder = PropertiesConfigurationUtil.createReloadingBuilder((File)new File(path), (boolean)commaDelimited);
        PropertiesConfiguration properties = null;
        try {
            properties = (PropertiesConfiguration)builder.getConfiguration();
            PropertiesConfigurationUtil.createReloadTrigger((ReloadingFileBasedConfigurationBuilder)builder).start();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        if ((properties == null || properties.isEmpty()) && alert) {
            this.alertErrorDialog("Could not load properties from file: " + path);
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String testPort(String port, String name) {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(Integer.parseInt(port));
        }
        catch (NumberFormatException ex) {
            String string = name + " port is invalid: " + port;
            return string;
        }
        catch (IOException ex) {
            String string = name + " port is already in use: " + port;
            return string;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    return "Could not close test socket for " + name + ": " + port;
                }
            }
        }
        return null;
    }

    public void startMirthWorker() {
        PlatformUI.MANAGER_DIALOG.setCursor(Cursor.getPredefinedCursor(3));
        ManagerController.getInstance().setEnabledOptions(false, false, false, false);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            private String errorMessage = null;

            @Override
            public Void doInBackground() {
                this.errorMessage = ManagerController.this.startMirth();
                return null;
            }

            @Override
            public void done() {
                if (this.errorMessage == null) {
                    PlatformUI.MANAGER_TRAY.alertInfo("The BridgeLink Service was started successfully.");
                } else {
                    PlatformUI.MANAGER_TRAY.alertError(this.errorMessage);
                }
                ManagerController.this.updateMirthServiceStatus();
                PlatformUI.MANAGER_DIALOG.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        worker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String startMirth() {
        String httpPortResult = null;
        if (this.isUsingHttp()) {
            String httpPort = this.getServerProperties().getString("http.port");
            httpPortResult = this.testPort(httpPort, "WebStart");
        }
        String httpsPort = this.getServerProperties().getString("https.port");
        String httpsPortResult = this.testPort(httpsPort, "Administrator");
        if (httpPortResult != null || httpsPortResult != null) {
            Object errorMessage = "";
            if (httpPortResult != null) {
                errorMessage = (String)errorMessage + httpPortResult + "\n";
            }
            if (httpsPortResult != null) {
                errorMessage = (String)errorMessage + httpsPortResult + "\n";
            }
            ((String)errorMessage).substring(0, ((String)errorMessage).length() - 1);
            return errorMessage;
        }
        String errorMessage = null;
        try (Client client = null;){
            this.updating = true;
            if (!serviceController.startService()) {
                errorMessage = "The BridgeLink Service could not be started.  Please verify that it is installed and not already started.";
            } else {
                String contextPath = this.getContextPath();
                client = new Client("https://localhost:" + this.getServerProperties().getString("https.port") + contextPath);
                int retriesLeft = 30;
                long waitTime = 2000L;
                boolean started = false;
                while (!started && retriesLeft > 0) {
                    Thread.sleep(waitTime);
                    --retriesLeft;
                    try {
                        int status = client.getStatus();
                        if (status != 0 && status != 3) continue;
                        started = true;
                    }
                    catch (ClientException clientException) {}
                }
                if (!started) {
                    errorMessage = "The BridgeLink Service could not be started.";
                }
            }
        }
        this.updating = false;
        return errorMessage;
    }

    public void stopMirthWorker() {
        PlatformUI.MANAGER_DIALOG.setCursor(Cursor.getPredefinedCursor(3));
        this.setEnabledOptions(false, false, false, false);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            private String errorMessage = null;

            @Override
            public Void doInBackground() {
                this.errorMessage = ManagerController.this.stopMirth();
                return null;
            }

            @Override
            public void done() {
                if (this.errorMessage == null) {
                    PlatformUI.MANAGER_TRAY.alertInfo("The BridgeLink Service was stopped successfully.");
                } else {
                    PlatformUI.MANAGER_TRAY.alertError(this.errorMessage);
                }
                ManagerController.this.updateMirthServiceStatus();
                PlatformUI.MANAGER_DIALOG.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        worker.execute();
    }

    private String stopMirth() {
        String errorMessage = null;
        try {
            this.updating = true;
            if (!serviceController.stopService()) {
                errorMessage = "The BridgeLink Service could not be stopped.  Please verify that it is installed and started.";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errorMessage = "The BridgeLink Service could not be stopped.  Please verify that it is installed and started.";
        }
        this.updating = false;
        return errorMessage;
    }

    public void restartMirthWorker() {
        PlatformUI.MANAGER_DIALOG.setCursor(Cursor.getPredefinedCursor(3));
        this.setEnabledOptions(false, false, false, false);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            private String errorMessage = null;

            @Override
            public Void doInBackground() {
                this.errorMessage = ManagerController.this.restartMirth();
                return null;
            }

            @Override
            public void done() {
                if (this.errorMessage == null) {
                    PlatformUI.MANAGER_TRAY.alertInfo("The BridgeLink Service was restarted successfully.");
                } else {
                    PlatformUI.MANAGER_TRAY.alertError(this.errorMessage);
                }
                ManagerController.this.updateMirthServiceStatus();
                PlatformUI.MANAGER_DIALOG.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        worker.execute();
    }

    private String restartMirth() {
        String errorMessage = null;
        errorMessage = this.stopMirth();
        if (errorMessage == null) {
            errorMessage = this.startMirth();
        }
        return errorMessage;
    }

    public void launchAdministrator(String maxHeapSize) {
        boolean success = false;
        boolean usingHttp = this.isUsingHttp();
        String port = this.getServerProperties().getString(usingHttp ? "http.port" : "https.port");
        String contextPath = this.getContextPath();
        try {
            String cmd;
            maxHeapSize = StringUtils.isBlank((CharSequence)maxHeapSize) ? "512m" : maxHeapSize;
            String scheme = usingHttp ? "http" : "https";
            String url = scheme + "://localhost:" + port + contextPath + "/webstart.jnlp?maxHeapSize=" + maxHeapSize + "&time=" + new Date().getTime();
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URI(url));
                    success = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!success && !DisplayUtil.isJDK11OrGreater() && CmdUtil.execCmd(new String[]{cmd = "javaws " + url}, false) == 0) {
                success = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!success) {
            PlatformUI.MANAGER_TRAY.alertError("The BridgeLink Administator could not be launched.");
        }
    }

    public boolean isUsingHttp() {
        return this.getServerProperties().containsKey("http.port") && this.getServerProperties().getInt("http.port") > 0;
    }

    public ReloadingFileBasedConfigurationBuilder<PropertiesConfiguration> getServerPropertiesBuilder() {
        return this.serverPropertiesBuilder;
    }

    public PropertiesConfiguration getServerProperties() {
        return this.serverProperties;
    }

    public void reloadServerProperties() {
        try {
            this.serverProperties = (PropertiesConfiguration)this.serverPropertiesBuilder.getConfiguration();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void saveServerProperties() throws ConfigurationException {
        PropertiesConfigurationUtil.saveTo((PropertiesConfiguration)this.serverProperties, (File)new File(PlatformUI.MIRTH_PATH + ManagerConstants.PATH_SERVER_PROPERTIES));
    }

    public ReloadingFileBasedConfigurationBuilder<PropertiesConfiguration> getLog4jPropertiesBuilder() {
        return this.log4jPropertiesBuilder;
    }

    public PropertiesConfiguration getLog4jProperties() {
        return this.log4jProperties;
    }

    public void reloadLog4jProperties() {
        try {
            this.log4jProperties = (PropertiesConfiguration)this.log4jPropertiesBuilder.getConfiguration();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void saveLog4jProperties() throws ConfigurationException {
        PropertiesConfigurationUtil.saveTo((PropertiesConfiguration)this.log4jProperties, (File)new File(PlatformUI.MIRTH_PATH + ManagerConstants.PATH_LOG4J_PROPERTIES));
    }

    public String getServerVersion() {
        if (this.versionProperties != null) {
            return this.versionProperties.getString("mirth.version", "");
        }
        return "";
    }

    public String getServerId() {
        if (this.serverIdProperties != null) {
            return this.serverIdProperties.getString("server.id", "");
        }
        return "";
    }

    public List<String> getLogFiles(String path) {
        ArrayList<String> files = new ArrayList<String>();
        File dir = new File(path);
        String[] children = dir.list();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                files.add(children[i]);
            }
        }
        return files;
    }

    public void openLogFile(String path) {
        block5: {
            File file = new File(path);
            try {
                Desktop.getDesktop().open(file);
            }
            catch (Exception e) {
                boolean editorOpened = false;
                String[] apps = new String[]{"notepad", "kate", "gedit", "gvim", "open -t"};
                for (int i = 0; i < apps.length && !editorOpened; ++i) {
                    try {
                        String output = CmdUtil.execCmdWithErrorOutput(new String[]{apps[i] + " \"" + path + "\""});
                        if (output.length() != 0) continue;
                        editorOpened = true;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (editorOpened) break block5;
                e.printStackTrace();
                this.alertErrorDialog("Could not open file: " + path + "\nPlease make sure a text editor is associated with the log's file extension.");
            }
        }
    }

    public String getServiceXmx() {
        String match = "";
        File file = new File(PlatformUI.MIRTH_PATH + "blservice.vmoptions");
        String contents = "";
        try {
            contents = FileUtils.readFileToString((File)file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Pattern pattern = Pattern.compile("-Xmx(.*?)m");
        Matcher matcher = pattern.matcher(contents);
        if (matcher.find()) {
            match = matcher.group(1);
        }
        return match;
    }

    public void setServiceXmx(String xmx) {
        File file = new File(PlatformUI.MIRTH_PATH + "blservice.vmoptions");
        Object contents = "";
        try {
            contents = FileUtils.readFileToString((File)file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Pattern pattern = Pattern.compile("-Xmx(.*?)m");
        Matcher matcher = pattern.matcher((CharSequence)contents);
        if (matcher.find()) {
            contents = matcher.replaceFirst("-Xmx" + xmx + "m");
        } else if (xmx.length() != 0) {
            contents = (String)contents + "-Xmx" + xmx + "m";
        }
        try {
            FileUtils.writeStringToFile((File)file, (String)contents);
        }
        catch (IOException e) {
            this.alertErrorDialog("Error writing file to: " + file.getPath());
        }
    }

    public void updateMirthServiceStatus() {
        int status = serviceController.checkService();
        if (this.updating) {
            return;
        }
        switch (status) {
            case 0: {
                this.setEnabledOptions(true, false, false, false);
                break;
            }
            case 1: {
                this.setEnabledOptions(false, true, true, true);
                break;
            }
            default: {
                this.setEnabledOptions(false, false, false, false);
            }
        }
    }

    public void setEnabledOptions(boolean start, boolean stop, boolean restart, boolean launch) {
        PlatformUI.MANAGER_DIALOG.setStartButtonActive(start);
        PlatformUI.MANAGER_DIALOG.setStopButtonActive(stop);
        PlatformUI.MANAGER_DIALOG.setRestartButtonActive(restart);
        PlatformUI.MANAGER_DIALOG.setLaunchButtonActive(launch);
        PlatformUI.MANAGER_TRAY.setStartButtonActive(start);
        PlatformUI.MANAGER_TRAY.setStopButtonActive(stop);
        PlatformUI.MANAGER_TRAY.setRestartButtonActive(restart);
        PlatformUI.MANAGER_TRAY.setLaunchButtonActive(launch);
        if (start) {
            PlatformUI.MANAGER_TRAY.setTrayIcon(0);
        } else if (stop) {
            PlatformUI.MANAGER_TRAY.setTrayIcon(1);
        } else {
            PlatformUI.MANAGER_TRAY.setTrayIcon(-1);
        }
    }

    public void setApplyEnabled(boolean enabled) {
        PlatformUI.MANAGER_DIALOG.setApplyEnabled(enabled);
    }

    public void alertErrorDialog(String message) {
        this.alertErrorDialog(null, message);
    }

    public void alertErrorDialog(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, "Error", 0);
    }

    public void alertInformationDialog(String message) {
        this.alertInformationDialog(null, message);
    }

    public void alertInformationDialog(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, "Information", 1);
    }

    public boolean alertOptionDialog(String message) {
        return this.alertOptionDialog(null, message);
    }

    public boolean alertOptionDialog(Component parent, String message) {
        int option = JOptionPane.showConfirmDialog(parent, message, "Select an Option", 0);
        return option == 0;
    }

    private String getContextPath() {
        Object contextPath = this.getServerProperties().getString("http.contextpath", "");
        if (!((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        if (((String)contextPath).endsWith("/")) {
            contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 1);
        }
        return contextPath;
    }
}

