/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.manager;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.mirth.connect.manager.BareBonesBrowserLaunch;
import com.mirth.connect.manager.DisplayUtil;
import com.mirth.connect.manager.HeapSizeDialog;
import com.mirth.connect.manager.Manager;
import com.mirth.connect.manager.ManagerConstants;
import com.mirth.connect.manager.ManagerController;
import com.mirth.connect.manager.MirthHeadingPanel;
import com.mirth.connect.manager.MirthTheme;
import com.mirth.connect.manager.ServiceController;
import com.mirth.connect.manager.ServiceControllerFactory;
import com.mirth.connect.manager.components.MirthComboBox;
import com.mirth.connect.manager.components.MirthFieldConstraints;
import com.mirth.connect.manager.components.MirthPasswordField;
import com.mirth.connect.manager.components.MirthTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.ArrayUtils;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsLookAndFeelAddons;

public class ManagerDialog
extends JDialog {
    private ServiceController serviceController = null;
    private ManagerController managerController = null;
    private boolean loading = false;
    private String lastSelectedDatabaseType;
    private Map<String, String> databaseUrls = new HashMap<String, String>();
    private String heapSize = "512m";
    private ImageIcon icon = new ImageIcon(this.getClass().getResource("images/wrench.png"));
    private JPanel servicePanel;
    private JButton startButton;
    private JLabel startLabel;
    private JButton restartButton;
    private JLabel restartLabel;
    private JButton stopButton;
    private JLabel stopLabel;
    private JLabel refreshLabel;
    private JButton refreshServiceButton;
    private JCheckBox startup;
    private JPanel serverPanel;
    private JLabel httpPortLabel;
    private MirthTextField httpPortField;
    private JLabel httpsPortLabel;
    private MirthTextField httpsPortField;
    private JLabel serverMemoryLabel;
    private MirthTextField serverMemoryField;
    private JList serverLogFiles;
    private JScrollPane serverLogsScrollPane;
    private JLabel mainLogLevelLabel;
    private MirthComboBox mainLogLevelCombobox;
    private JLabel databaseLogLevelLabel;
    private MirthComboBox databaseLogLevelCombobox;
    private JLabel channelLogLevelLabel;
    private MirthComboBox channelLogLevelCombobox;
    private JButton refreshButton;
    private JButton viewFileButton;
    private JPanel databasePanel;
    private JLabel databaseTypeLabel;
    private MirthComboBox databaseTypeCombobox;
    private JLabel databaseUrlLabel;
    private MirthTextField databaseUrlField;
    private JLabel databaseUsernameLabel;
    private MirthTextField databaseUsernameField;
    private JLabel passwordLabel;
    private MirthPasswordField databasePasswordField;
    private JPanel infoPanel;
    private JLabel serverVersionLabel;
    private JLabel serverVersionField;
    private JLabel serverIdLabel;
    private JLabel serverIdField;
    private JLabel javaVersionLabel;
    private JLabel javaVersionField;
    private JLabel contactPrefixLabel;
    private JLabel mirthSupportLink;
    private JLabel contactPostfixLabel;
    private JButton launchButton;
    private JButton okButton;
    private JButton cancelButton;
    private JButton applyButton;
    private JButton heapSizeButton;
    private JTabbedPane tabPanel;

    public ManagerDialog() {
        try {
            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new MirthTheme());
            PlasticXPLookAndFeel look = new PlasticXPLookAndFeel();
            UIManager.setLookAndFeel((LookAndFeel)look);
            UIManager.put("win.xpstyle.name", "metallic");
            LookAndFeelAddons.setAddon(WindowsLookAndFeelAddons.class);
            this.getContentPane().setBackground(Color.WHITE);
            this.setTitle("BridgeLink Server Manager");
            this.setIconImage(new ImageIcon(this.getClass().getResource("images/NG_MC-ServerManager_Icon_F_32x32.png")).getImage());
            DisplayUtil.setResizable(this, false);
            this.serviceController = ServiceControllerFactory.getServiceController();
            this.managerController = ManagerController.getInstance();
            this.heapSize = (String)this.managerController.getServerProperties().getProperty("administrator.maxheapsize");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void setupDialog() {
        this.initComponents();
        this.initLayout();
        this.heapSizeButton.setIcon(this.icon);
        this.databaseUrls.put("derby", "jdbc:derby:${dir.appdata}/mirthdb;create=true");
        this.databaseUrls.put("postgres", "jdbc:postgresql://localhost:5432/mirthdb");
        this.databaseUrls.put("mysql", "jdbc:mysql://localhost:3306/mirthdb");
        this.databaseUrls.put("oracle", "jdbc:oracle:thin:@localhost:1521:DB");
        this.databaseUrls.put("sqlserver", "jdbc:jtds:sqlserver://localhost:1433/mirthdb");
        if (!this.serviceController.isShowServiceTab()) {
            this.tabPanel.removeTabAt(0);
        }
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ManagerDialog.this.close();
            }
        });
        this.serverMemoryField.setDocument(new MirthFieldConstraints(0, false, false, true));
        this.loadProperties();
    }

    public void open() {
        this.managerController.updateMirthServiceStatus();
        this.loadProperties();
        if (this.serviceController.isStartupPossible()) {
            this.startup.setEnabled(true);
            if (this.serviceController.isStartup()) {
                this.startup.setSelected(true);
            } else {
                this.startup.setSelected(false);
            }
        } else {
            this.startup.setEnabled(false);
        }
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
        if (!this.serviceController.isShowTrayIcon()) {
            Manager.shutdown();
        }
    }

    public void setApplyEnabled(boolean enabled) {
        this.applyButton.setEnabled(enabled);
    }

    public boolean isApplyEnabled() {
        return this.applyButton.isEnabled();
    }

    private void initServicePanel() {
        this.servicePanel = new JPanel((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3", "24[][][]", "[]12[]12[]12[]12[]"));
        this.servicePanel.setBackground(new Color(255, 255, 255));
        this.servicePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.servicePanel.setFocusable(false);
        this.startButton = new JButton("Start");
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerDialog.this.startButtonActionPerformed(evt);
            }
        });
        this.startLabel = new JLabel("Starts the BridgeLink service");
        this.restartButton = new JButton("Restart");
        this.restartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerDialog.this.restartButtonActionPerformed(evt);
            }
        });
        this.restartLabel = new JLabel("Restarts the BridgeLink service");
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerDialog.this.stopButtonActionPerformed(evt);
            }
        });
        this.stopLabel = new JLabel("Stops the BridgeLink service");
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerDialog.this.refreshButtonActionPerformed(evt);
            }
        });
        this.refreshLabel = new JLabel("Refreshes the BridgeLink service status");
        this.startup = new JCheckBox("Start BridgeLink Server Manager on system startup");
        this.startup.setFocusable(false);
        this.startup.setToolTipText("Starts this application when logging into the operating system. Currently only enabled for Windows.");
        this.startup.setBackground(new Color(255, 255, 255));
        this.startup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerDialog.this.startupActionPerformed(evt);
            }
        });
    }

    private void initServerPanel() {
        this.serverPanel = new JPanel((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, fill", "[right][left][right][left]"));
        this.serverPanel.setFocusable(false);
        this.serverPanel.setBackground(new Color(255, 255, 255));
        this.serverPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.httpPortLabel = new JLabel("HTTP Port:");
        this.httpPortField = new MirthTextField();
        this.httpsPortLabel = new JLabel("HTTPS Port:");
        this.httpsPortField = new MirthTextField();
        this.serverMemoryLabel = new JLabel("Server Memory (mb):");
        this.serverMemoryField = new MirthTextField();
        this.serverLogFiles = new JList();
        this.serverLogFiles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ManagerDialog.this.serverLogFilesValueChanged(evt);
            }
        });
        this.serverLogFiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() >= 2 && ManagerDialog.this.serverLogFiles.getSelectedIndex() != -1) {
                    ManagerDialog.this.viewFileButtonActionPerformed(null);
                }
            }
        });
        this.serverLogsScrollPane = new JScrollPane();
        this.serverLogsScrollPane.setViewportView(this.serverLogFiles);
        this.mainLogLevelLabel = new JLabel("Main Log Level:");
        this.mainLogLevelCombobox = new MirthComboBox();
        this.mainLogLevelCombobox.setModel(new DefaultComboBoxModel<String>(ManagerConstants.LOG4J_ERROR_CODES));
        this.databaseLogLevelLabel = new JLabel("Database Log Level:");
        this.databaseLogLevelCombobox = new MirthComboBox();
        this.databaseLogLevelCombobox.setModel(new DefaultComboBoxModel<String>(ManagerConstants.LOG4J_ERROR_CODES));
        this.channelLogLevelLabel = new JLabel("Channel Log Level:");
        this.channelLogLevelCombobox = new MirthComboBox();
        this.channelLogLevelCombobox.setModel(new DefaultComboBoxModel<String>(ManagerConstants.LOG4J_ERROR_CODES_WITH_BLANK));
        this.refreshServiceButton = new JButton("Refresh");
        this.refreshServiceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerDialog.this.refreshServiceButtonActionPerformed(evt);
            }
        });
        this.viewFileButton = new JButton("View File");
        this.viewFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerDialog.this.viewFileButtonActionPerformed(evt);
            }
        });
    }

    private void initDatabasePanel() {
        this.databasePanel = new JPanel((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3", "[right][left]"));
        this.databasePanel.setFocusable(false);
        this.databasePanel.setBackground(new Color(255, 255, 255));
        this.databasePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.databaseTypeLabel = new JLabel("Type:");
        this.databaseTypeCombobox = new MirthComboBox();
        this.databaseTypeCombobox.setModel(new DefaultComboBoxModel<String>(new String[]{"derby", "postgres", "mysql", "oracle", "sqlserver"}));
        this.databaseTypeCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerDialog.this.databaseTypeActionPerformed(evt);
            }
        });
        this.databaseUrlLabel = new JLabel("URL:");
        this.databaseUrlField = new MirthTextField();
        this.databaseUsernameLabel = new JLabel("Username:");
        this.databaseUsernameField = new MirthTextField();
        this.passwordLabel = new JLabel("Password:");
        this.databasePasswordField = new MirthPasswordField();
    }

    private void initInfoPanel() {
        this.infoPanel = new JPanel((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3", "[right][left]"));
        this.infoPanel.setBackground(new Color(255, 255, 255));
        this.infoPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.serverVersionLabel = new JLabel("Server Version:");
        this.serverVersionField = new JLabel("version");
        this.serverIdLabel = new JLabel("Server ID:");
        this.serverIdField = new JLabel("serverId");
        this.javaVersionLabel = new JLabel("Java Version:");
        this.javaVersionField = new JLabel("javaVersion");
        this.contactPrefixLabel = new JLabel("Need Help?  Contact");
        this.mirthSupportLink = new JLabel("<html><font color=blue><u>Innovar Healthcare</u></font></html>");
        this.mirthSupportLink.setToolTipText("Visit Innovar Healthcare's website.");
        this.mirthSupportLink.setCursor(new Cursor(12));
        this.mirthSupportLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ManagerDialog.this.mirthSupportLinkMouseClicked(evt);
            }
        });
        this.contactPostfixLabel = new JLabel("for professional support.");
    }

    private void initComponents() {
        this.initServicePanel();
        this.initServerPanel();
        this.initDatabasePanel();
        this.initInfoPanel();
        this.tabPanel = new JTabbedPane();
        this.tabPanel.setBackground(new Color(255, 255, 255));
        this.tabPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tabPanel.setFocusable(false);
        this.tabPanel.addTab("Service", this.servicePanel);
        this.tabPanel.addTab("Server", this.serverPanel);
        this.tabPanel.addTab("Database", this.databasePanel);
        this.tabPanel.addTab("Info", this.infoPanel);
        this.launchButton = new JButton("Administrator");
        this.launchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerDialog.this.launchButtonActionPerformed(evt);
            }
        });
        this.heapSizeButton = new JButton();
        this.heapSizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerDialog.this.heapSizeButtonActionPerformed(evt);
            }
        });
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerDialog.this.applyButtonActionPerformed(evt);
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagerDialog.this.cancelButtonActionPerformed(evt);
            }
        });
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 8 0, novisualpadding, hidemode 3"));
        this.add((Component)new MirthHeadingPanel(), "wrap, grow");
        this.servicePanel.add((Component)this.startButton, "w 80!, h 22!, split");
        this.servicePanel.add((Component)this.startLabel, "wrap");
        this.servicePanel.add((Component)this.restartButton, "w 80!, h 22!, split");
        this.servicePanel.add((Component)this.restartLabel, "wrap");
        this.servicePanel.add((Component)this.stopButton, "w 80!, h 22!, split");
        this.servicePanel.add((Component)this.stopLabel, "wrap");
        this.servicePanel.add((Component)this.refreshServiceButton, "w 80!, h 22!, split");
        this.servicePanel.add((Component)this.refreshLabel, "wrap");
        this.servicePanel.add((Component)this.startup, "span, push");
        this.serverPanel.add(this.httpPortLabel);
        this.serverPanel.add((Component)this.httpPortField, "w 55!, h 22!");
        this.serverPanel.add(this.mainLogLevelLabel);
        this.serverPanel.add((Component)this.mainLogLevelCombobox, "w 80!, wrap");
        this.serverPanel.add(this.httpsPortLabel);
        this.serverPanel.add((Component)this.httpsPortField, "w 55!, h 22!");
        this.serverPanel.add(this.databaseLogLevelLabel);
        this.serverPanel.add((Component)this.databaseLogLevelCombobox, "w 80!, wrap");
        this.serverPanel.add(this.serverMemoryLabel);
        this.serverPanel.add((Component)this.serverMemoryField, "w 55!, h 22!");
        this.serverPanel.add(this.channelLogLevelLabel);
        this.serverPanel.add((Component)this.channelLogLevelCombobox, "w 80!, wrap");
        this.serverPanel.add(new JLabel("Log Files:"));
        this.serverPanel.add((Component)this.serverLogsScrollPane, "w 205!, h 70!, span 2 2");
        this.serverPanel.add((Component)this.refreshButton, "w 80!, h 22!, cell 3 3");
        this.serverPanel.add((Component)this.viewFileButton, "w 80!, h 22!, cell 3 4");
        this.databasePanel.add(this.databaseTypeLabel);
        this.databasePanel.add((Component)this.databaseTypeCombobox, "wrap");
        this.databasePanel.add(this.databaseUrlLabel);
        this.databasePanel.add((Component)this.databaseUrlField, "wrap, w 350!");
        this.databasePanel.add(this.databaseUsernameLabel);
        this.databasePanel.add((Component)this.databaseUsernameField, "wrap, w 145!");
        this.databasePanel.add(this.passwordLabel);
        this.databasePanel.add((Component)this.databasePasswordField, "w 145!");
        this.infoPanel.add(this.serverVersionLabel);
        this.infoPanel.add((Component)this.serverVersionField, "wrap");
        this.infoPanel.add(this.serverIdLabel);
        this.infoPanel.add((Component)this.serverIdField, "wrap");
        this.infoPanel.add(this.javaVersionLabel);
        this.infoPanel.add((Component)this.javaVersionField, "wrap");
        this.infoPanel.add((Component)this.contactPrefixLabel, "split 3, span, gaptop 90");
        this.infoPanel.add((Component)this.mirthSupportLink, "gaptop 90");
        this.infoPanel.add((Component)this.contactPostfixLabel, "gaptop 90");
        JPanel tabContainer = new JPanel((LayoutManager)new MigLayout("insets 8 8 0 8, novisualpadding, hidemode 3"));
        tabContainer.setBackground(Color.white);
        tabContainer.add(this.tabPanel);
        this.add((Component)tabContainer, "wrap");
        this.add((Component)new JSeparator(), "newline, growx, sx, gapleft 8, gapright 8");
        this.add((Component)this.launchButton, "split, gapleft 8");
        this.add((Component)this.heapSizeButton, "w 22!, h 22!, left");
        this.add((Component)this.okButton, "w 56!, gapleft 145");
        this.add((Component)this.cancelButton, "w 56!");
        this.add((Component)this.applyButton, "w 56!");
    }

    private void mirthSupportLinkMouseClicked(MouseEvent evt) {
        BareBonesBrowserLaunch.openURL("https://www.innovarhealthcare.com");
    }

    private void startupActionPerformed(ActionEvent evt) {
        this.setApplyEnabled(true);
    }

    private void refreshServiceButtonActionPerformed(ActionEvent evt) {
        this.managerController.updateMirthServiceStatus();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.saveProperties()) {
            this.close();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        if (this.startup.isSelected()) {
            this.serviceController.setStartup(true);
        } else {
            this.serviceController.setStartup(false);
        }
        this.saveProperties();
    }

    private void serverLogFilesValueChanged(ListSelectionEvent evt) {
        if (this.serverLogFiles.getSelectedIndex() != -1) {
            this.viewFileButton.setEnabled(true);
        } else {
            this.viewFileButton.setEnabled(false);
        }
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.refreshLogs();
    }

    private void databaseTypeActionPerformed(ActionEvent evt) {
        if (this.loading) {
            this.lastSelectedDatabaseType = (String)this.databaseTypeCombobox.getSelectedItem();
        } else if (!this.databaseTypeCombobox.getSelectedItem().equals(this.lastSelectedDatabaseType)) {
            if (!(this.databaseUrlField.getText().equals(this.databaseUrls.get(this.lastSelectedDatabaseType)) && this.databaseUsernameField.getText().equals("") && new String(this.databasePasswordField.getPassword()).equals("") || this.managerController.alertOptionDialog(this, "Changing your database type will clear your database URL, username, and password.\nAre you sure you want to continue?"))) {
                this.databaseTypeCombobox.setSelectedItem(this.lastSelectedDatabaseType);
                return;
            }
            this.lastSelectedDatabaseType = (String)this.databaseTypeCombobox.getSelectedItem();
            this.databaseUrlField.setText(this.databaseUrls.get(this.lastSelectedDatabaseType));
            this.databaseUsernameField.setText("");
            this.databasePasswordField.setText("");
        }
    }

    private void launchButtonActionPerformed(ActionEvent evt) {
        this.managerController.launchAdministrator(this.heapSize);
    }

    private void viewFileButtonActionPerformed(ActionEvent evt) {
        this.managerController.openLogFile(this.managerController.getLog4jProperties().getString("dir.logs") + System.getProperty("file.separator") + (String)this.serverLogFiles.getSelectedValue());
    }

    private void restartButtonActionPerformed(ActionEvent evt) {
        this.managerController.restartMirthWorker();
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        this.managerController.stopMirthWorker();
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        this.managerController.startMirthWorker();
    }

    private void heapSizeButtonActionPerformed(ActionEvent evt) {
        HeapSizeDialog dialog = new HeapSizeDialog(this.heapSize);
        this.heapSize = dialog.getHeapSize();
    }

    private void loadProperties() {
        this.loading = true;
        this.serverIdField.setText(this.managerController.getServerId());
        this.serverMemoryField.setText(this.managerController.getServiceXmx());
        this.serverVersionField.setText(this.managerController.getServerVersion());
        this.javaVersionField.setText(System.getProperty("java.version"));
        this.httpPortField.setText(this.managerController.getServerProperties().getString("http.port"));
        this.httpsPortField.setText(this.managerController.getServerProperties().getString("https.port"));
        boolean applyEnabled = this.isApplyEnabled();
        this.databaseTypeCombobox.setSelectedItem(this.managerController.getServerProperties().getString("database"));
        this.databaseUrlField.setText((String)this.managerController.getServerProperties().getProperty("database.url"));
        this.databaseUsernameField.setText(this.managerController.getServerProperties().getString("database.username"));
        this.databasePasswordField.setText(this.managerController.getServerProperties().getString("database.password"));
        String rootLogCode = this.managerController.getLog4jProperties().getStringArray("rootLogger")[0];
        if (ArrayUtils.contains((Object[])ManagerConstants.LOG4J_ERROR_CODES, (Object)rootLogCode)) {
            this.mainLogLevelCombobox.setSelectedItem(rootLogCode);
        }
        this.databaseLogLevelCombobox.setSelectedItem(this.managerController.getLog4jProperties().getString("logger.sql.level"));
        String channelLogCode = null;
        for (int i = 0; i < ManagerConstants.LOG4J_CHANNEL_LOG_LEVELS.length && !ManagerConstants.LOG4J_ERROR_CODES_WITH_BLANK[0].equals(channelLogCode); ++i) {
            String tempLogCode = this.managerController.getLog4jProperties().getString(ManagerConstants.LOG4J_CHANNEL_LOG_LEVELS[i]);
            if (tempLogCode == null) {
                channelLogCode = ManagerConstants.LOG4J_ERROR_CODES_WITH_BLANK[0];
                continue;
            }
            if (channelLogCode == null) {
                channelLogCode = tempLogCode;
                continue;
            }
            if (channelLogCode.equalsIgnoreCase(tempLogCode)) continue;
            channelLogCode = ManagerConstants.LOG4J_ERROR_CODES_WITH_BLANK[0];
        }
        this.channelLogLevelCombobox.setSelectedItem(channelLogCode);
        this.setApplyEnabled(applyEnabled);
        this.refreshLogs();
        this.serverLogFilesValueChanged(null);
        this.loading = false;
    }

    public boolean saveProperties() {
        if (this.managerController.getServerPropertiesBuilder().getReloadingController().isInReloadingState()) {
            if (!this.managerController.alertOptionDialog(this, "Server properties have changed on disk since the manager was opened. Are you sure you wish to overwrite them?")) {
                return false;
            }
            this.managerController.reloadServerProperties();
        }
        if (this.managerController.getLog4jPropertiesBuilder().getReloadingController().isInReloadingState()) {
            if (!this.managerController.alertOptionDialog(this, "Log4j properties have changed on disk since the manager was opened. Are you sure you wish to overwrite them?")) {
                return false;
            }
            this.managerController.reloadLog4jProperties();
        }
        this.managerController.getServerProperties().setProperty("http.port", (Object)this.httpPortField.getText());
        this.managerController.getServerProperties().setProperty("https.port", (Object)this.httpsPortField.getText());
        this.managerController.getServerProperties().setProperty("database", (Object)((String)this.databaseTypeCombobox.getSelectedItem()));
        this.managerController.getServerProperties().setProperty("database.url", (Object)this.databaseUrlField.getText());
        this.managerController.getServerProperties().setProperty("database.username", (Object)this.databaseUsernameField.getText());
        this.managerController.getServerProperties().setProperty("database.password", (Object)new String(this.databasePasswordField.getPassword()));
        try {
            this.managerController.saveServerProperties();
        }
        catch (ConfigurationException e) {
            this.managerController.alertErrorDialog(this, "Error saving " + this.managerController.getServerPropertiesBuilder().getFileHandler().getFile().getPath() + ":\n" + e.getMessage());
        }
        String[] logLevel = this.managerController.getLog4jProperties().getStringArray("rootLogger");
        logLevel[0] = (String)this.mainLogLevelCombobox.getSelectedItem();
        this.managerController.getLog4jProperties().setProperty("rootLogger", (Object)logLevel);
        this.managerController.getLog4jProperties().setProperty("logger.sql.level", (Object)((String)this.databaseLogLevelCombobox.getSelectedItem()));
        String channelLogLevelCode = (String)this.channelLogLevelCombobox.getSelectedItem();
        if (!ManagerConstants.LOG4J_ERROR_CODES_WITH_BLANK[0].equals(channelLogLevelCode)) {
            for (String channelLogLevel : ManagerConstants.LOG4J_CHANNEL_LOG_LEVELS) {
                this.managerController.getLog4jProperties().setProperty(channelLogLevel, (Object)channelLogLevelCode);
            }
        }
        try {
            this.managerController.saveLog4jProperties();
        }
        catch (ConfigurationException e) {
            this.managerController.alertErrorDialog(this, "Error saving " + this.managerController.getLog4jPropertiesBuilder().getFileHandler().getFile().getPath() + ":\n" + e.getMessage());
        }
        this.managerController.setServiceXmx(this.serverMemoryField.getText());
        this.setApplyEnabled(false);
        return true;
    }

    private void refreshLogs() {
        String logPath = this.managerController.getLog4jProperties().getString("dir.logs");
        this.serverLogFiles.setListData(this.managerController.getLogFiles(logPath).toArray());
    }

    public void setStartButtonActive(boolean active) {
        this.startButton.setEnabled(active);
        this.startLabel.setEnabled(active);
    }

    public void setStopButtonActive(boolean active) {
        this.stopButton.setEnabled(active);
        this.stopLabel.setEnabled(active);
    }

    public void setRestartButtonActive(boolean active) {
        this.restartButton.setEnabled(active);
        this.restartLabel.setEnabled(active);
    }

    public void setLaunchButtonActive(boolean active) {
        this.launchButton.setEnabled(active);
    }
}

