/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.manager;

import com.mirth.connect.manager.CmdUtil;
import com.mirth.connect.manager.PlatformUI;
import com.mirth.connect.manager.ServiceController;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WindowsServiceController
implements ServiceController {
    private final String WINDOWS_PATH_SERVER_MANAGER_EXE = "blmanager.exe";
    private final String WINDOWS_SERVICE_NAME = "BridgeLink Service";
    private final String WINDOWS_CMD_START = "net start \"";
    private final String WINDOWS_CMD_STOP = "net stop \"";
    private final String WINDOWS_CMD_STATUS = "net continue \"";
    private final int WINDOWS_STATUS_RUNNING = 2191;
    private final int WINDOWS_STATUS_STOPPED = 2184;
    private final String WINDOWS_STATUS_CHANGING = "2189";
    private final String WINDOWS_CMD_QUERY_REGEX = "NET HELPMSG ([0-9]{4})";
    private final String WINDOWS_CMD_REG_QUERY = "REG QUERY HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run /v \"BridgeLink Server Manager\"";
    private final String WINDOWS_CMD_REG_DELETE = "REG DELETE HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run /f /v \"BridgeLink Server Manager\"";
    private final String WINDOWS_CMD_REG_ADD = "REG ADD HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run /f /v \"BridgeLink Server Manager\" /d ";

    @Override
    public int checkService() {
        Pattern pattern = Pattern.compile("NET HELPMSG ([0-9]{4})");
        String key = "-1";
        do {
            try {
                Matcher matcher = pattern.matcher(CmdUtil.execCmdWithErrorOutput("net continue \"BridgeLink Service\"").replace('\n', ' ').replace('\r', ' '));
                while (matcher.find()) {
                    key = matcher.group(1);
                }
                if (key.equals("2189")) {
                    Thread.sleep(100L);
                } else {
                    if (Integer.parseInt(key) == 2184) {
                        return 0;
                    }
                    if (Integer.parseInt(key) == 2191) {
                        return 1;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (key.equals("2189"));
        return -1;
    }

    @Override
    public boolean startService() {
        try {
            if (CmdUtil.execCmd("net start \"BridgeLink Service\"", true) == 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean stopService() {
        try {
            if (CmdUtil.execCmd("net stop \"BridgeLink Service\"", true) == 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean isStartupPossible() {
        return true;
    }

    @Override
    public void setStartup(boolean enabled) {
        if (enabled) {
            try {
                String absolutePath = new File(PlatformUI.MIRTH_PATH).getAbsolutePath();
                CmdUtil.execCmd("REG ADD HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run /f /v \"BridgeLink Server Manager\" /d \"\\\"" + absolutePath + System.getProperty("file.separator") + "blmanager.exe\\\"\"", true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                CmdUtil.execCmd("REG DELETE HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run /f /v \"BridgeLink Server Manager\"", true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isStartup() {
        int keyQueryResult = 1;
        try {
            keyQueryResult = CmdUtil.execCmd("REG QUERY HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run /v \"BridgeLink Server Manager\"", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return keyQueryResult == 0;
    }

    @Override
    public String getCommand() {
        return "cmd /c";
    }

    @Override
    public boolean isShowTrayIcon() {
        return true;
    }

    @Override
    public boolean isShowServiceTab() {
        return true;
    }

    @Override
    public void migrate() {
        try {
            String output = CmdUtil.execCmdWithOutput("REG QUERY HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run /v \"BridgeLink Server Manager\"");
            if (output.indexOf("BridgeLink Server Manager.exe") != -1) {
                this.setStartup(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

