/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.manager.components;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class MirthFieldConstraints
extends PlainDocument {
    private int limit;
    private boolean toUppercase = false;
    private Pattern pattern;
    private static final String NUMERIC_PATTERN = "^[0-9]*$";
    private static final String ALPHA_PATTERN = "^[a-zA-Z_\\-\\s]*$";
    private static final String ALPHA_NUMERIC_PATTERN = "^[a-zA-Z_0-9\\-\\s]*$";
    private static final String MATCH_ALL_PATTERN = "^.*$";

    public MirthFieldConstraints(int limit) {
        this.limit = limit;
        this.pattern = Pattern.compile(MATCH_ALL_PATTERN);
    }

    public MirthFieldConstraints(String newPattern) {
        this.limit = 0;
        this.pattern = Pattern.compile(newPattern);
    }

    public MirthFieldConstraints(int limit, boolean toUppercase, boolean lettersOnly, boolean numbersOnly) {
        this.limit = limit;
        this.toUppercase = toUppercase;
        String patternString = MATCH_ALL_PATTERN;
        if (lettersOnly && numbersOnly) {
            patternString = ALPHA_NUMERIC_PATTERN;
        } else if (lettersOnly) {
            patternString = ALPHA_PATTERN;
        } else if (numbersOnly) {
            patternString = NUMERIC_PATTERN;
        }
        this.pattern = Pattern.compile(patternString);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null) {
            return;
        }
        if (this.getLength() + str.length() <= this.limit || this.limit == 0) {
            Matcher matcher;
            if (this.toUppercase) {
                str = str.toUpperCase();
            }
            if (!(matcher = this.pattern.matcher(this.getText(0, this.getLength()) + str)).find()) {
                return;
            }
            super.insertString(offset, str, attr);
        }
    }
}

