/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.dialog;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.plugins.dynamiclookup.shared.model.AdvancedJsonFilterState;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupProperties;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonCondition;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonOperator;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonValueType;
import com.mirth.connect.plugins.dynamiclookup.shared.util.JsonUtils;
import com.mirth.connect.plugins.dynamiclookup.shared.validation.AdvancedJsonFilterValidator;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancedSearchDialog
extends MirthDialog {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private static final JsonOperator[] SUPPORTED_OPERATORS = JsonOperator.values();
    private static final JsonValueType[] SUPPORTED_VALUE_TYPES = JsonValueType.values();
    private JSplitPane splitPane;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JTextField keyPatternField;
    private JTable conditionTable;
    private ConditionTableModel conditionTableModel;
    private JButton loadFilterButton;
    private JButton deleteFilterButton;
    private DefaultListModel<SavedFilterEntry> savedFilterListModel;
    private JList<SavedFilterEntry> savedFilterList;
    private JButton saveFilterButton;
    private JButton applyButton;
    private JButton cancelButton;
    private boolean okPressed;
    private AdvancedJsonFilterState currentState;
    private final List<SavedFilterEntry> savedFilters = new ArrayList<SavedFilterEntry>();
    private Frame parent;

    public AdvancedSearchDialog(Frame frame, AdvancedJsonFilterState advancedJsonFilterState) {
        super((Window)frame, true);
        this.parent = frame;
        this.currentState = advancedJsonFilterState != null ? advancedJsonFilterState : new AdvancedJsonFilterState();
        this.initComponents();
        this.initLayout();
        this.resetComponents(advancedJsonFilterState);
        this.setDefaultCloseOperation(2);
        this.setTitle("Advanced Search");
        this.pack();
        this.setLocationRelativeTo((Component)frame);
        this.loadSavedFiltersFromServer();
        this.setVisible(true);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        this.keyPatternField = new JTextField();
        this.conditionTableModel = new ConditionTableModel();
        this.conditionTable = new JTable(this.conditionTableModel);
        this.conditionTable.setSelectionMode(0);
        this.conditionTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.conditionTable.setRowHeight(26);
        JComboBox<JsonOperator> jComboBox = new JComboBox<JsonOperator>(SUPPORTED_OPERATORS);
        this.conditionTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jComboBox));
        JComboBox<JsonValueType> jComboBox2 = new JComboBox<JsonValueType>(SUPPORTED_VALUE_TYPES);
        this.conditionTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(jComboBox2));
        this.loadFilterButton = new JButton("Load");
        this.loadFilterButton.addActionListener(actionEvent -> this.loadFilter());
        this.loadFilterButton.setEnabled(false);
        this.deleteFilterButton = new JButton("Delete");
        this.deleteFilterButton.addActionListener(actionEvent -> this.deleteFilter());
        this.deleteFilterButton.setEnabled(false);
        this.savedFilterListModel = new DefaultListModel();
        this.savedFilterListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                AdvancedSearchDialog.this.updateSavedFilterButtons();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                AdvancedSearchDialog.this.updateSavedFilterButtons();
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                AdvancedSearchDialog.this.updateSavedFilterButtons();
            }
        });
        this.savedFilterList = new JList<SavedFilterEntry>(this.savedFilterListModel);
        this.savedFilterList.setSelectionMode(0);
        this.savedFilterList.addListSelectionListener(listSelectionEvent -> {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            boolean bl = this.savedFilterList.getSelectedValue() != null;
            this.loadFilterButton.setEnabled(bl);
            this.deleteFilterButton.setEnabled(bl);
        });
        this.savedFilterList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && !mouseEvent.isConsumed() && AdvancedSearchDialog.this.savedFilterList.getSelectedValue() != null) {
                    mouseEvent.consume();
                    AdvancedSearchDialog.this.loadFilter();
                }
            }
        });
        this.saveFilterButton = new JButton("Save Filter");
        this.saveFilterButton.addActionListener(actionEvent -> this.saveFilter());
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(actionEvent -> this.apply());
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(actionEvent -> this.close());
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill"));
        this.leftPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, hidemode 0, align left top, insets 10, fill", "30[right][grow,fill]", ""));
        this.leftPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.leftPanel.setBorder(BorderFactory.createTitledBorder("Controls"));
        JLabel jLabel = new JLabel("Key Pattern:");
        this.leftPanel.add((Component)jLabel, "right");
        this.leftPanel.add((Component)this.keyPatternField, "growx, wrap");
        JLabel jLabel2 = new JLabel("Use SQL pattern (% and _). Example: 2025-11-21_%");
        jLabel2.setFont(jLabel2.getFont().deriveFont(jLabel2.getFont().getSize2D() - 1.0f));
        this.leftPanel.add((Component)new JLabel(), "");
        this.leftPanel.add((Component)jLabel2, "wrap");
        JLabel jLabel3 = new JLabel("JSON Conditions (AND):");
        this.leftPanel.add((Component)jLabel3, "gaptop 10, right");
        JScrollPane jScrollPane = new JScrollPane(this.conditionTable);
        this.leftPanel.add((Component)jScrollPane, "grow, pushy, hmin 160, wrap");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 0", "[]5[]", ""));
        jPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        JButton jButton = new JButton("Add condition");
        JButton jButton2 = new JButton("Remove selected");
        jButton.addActionListener(actionEvent -> this.addConditionRow());
        jButton2.addActionListener(actionEvent -> this.removeSelectedRow());
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.leftPanel.add((Component)new JLabel(), "");
        this.leftPanel.add((Component)jPanel, "growx, wrap");
        this.rightPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, hidemode 0, insets 10, fill", "[grow,fill]", "[]10[grow,fill]"));
        this.rightPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.rightPanel.setBorder(BorderFactory.createTitledBorder("Saved Filters"));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("insets 0", "[]5[]5[]", ""));
        jPanel2.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel2.add(this.loadFilterButton);
        jPanel2.add(this.deleteFilterButton);
        this.rightPanel.add((Component)jPanel2, "growx, wrap");
        JScrollPane jScrollPane2 = new JScrollPane(this.savedFilterList);
        this.rightPanel.add((Component)jScrollPane2, "grow, push");
        this.splitPane = new JSplitPane(1, this.leftPanel, this.rightPanel);
        this.splitPane.setResizeWeight(0.75);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.add(this.splitPane, "grow, push, wrap");
        this.add(new JSeparator(), "newline, sx, growx");
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("insets 0, fill", "[grow][][]", "[]"));
        jPanel3.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel3.add((Component)this.saveFilterButton, "left");
        jPanel3.add((Component)this.applyButton, "right");
        jPanel3.add((Component)this.cancelButton, "right");
        this.add(jPanel3, "newline, sx, growx");
    }

    private void resetComponents(AdvancedJsonFilterState advancedJsonFilterState) {
        if (advancedJsonFilterState == null) {
            return;
        }
        String string = advancedJsonFilterState.getKeyPattern();
        this.keyPatternField.setText(string != null ? string : "");
        List list = advancedJsonFilterState.getConditions();
        ArrayList<JsonCondition> arrayList = new ArrayList<JsonCondition>();
        if (list != null) {
            for (JsonCondition jsonCondition : list) {
                if (jsonCondition == null) continue;
                JsonCondition jsonCondition2 = new JsonCondition();
                jsonCondition2.setField(jsonCondition.getField());
                jsonCondition2.setOp(jsonCondition.getOp());
                jsonCondition2.setValueType(jsonCondition.getValueType());
                jsonCondition2.setValue(jsonCondition.getValue());
                arrayList.add(jsonCondition2);
            }
        }
        this.conditionTableModel.setConditions(arrayList);
        this.conditionTable.clearSelection();
        this.conditionTable.revalidate();
        this.conditionTable.repaint();
    }

    private void updateSavedFilterButtons() {
        boolean bl = !this.savedFilterListModel.isEmpty();
        boolean bl2 = this.savedFilterList.getSelectedValue() != null;
        this.loadFilterButton.setEnabled(bl && bl2);
        this.deleteFilterButton.setEnabled(bl && bl2);
    }

    private void loadSavedFiltersFromServer() {
        SwingWorker<LookupProperties, Void> swingWorker = new SwingWorker<LookupProperties, Void>(){

            @Override
            protected LookupProperties doInBackground() throws Exception {
                Properties properties = AdvancedSearchDialog.this.parent.mirthClient.getPluginProperties("Lookup Table Management System");
                return LookupProperties.fromProperties((Properties)properties);
            }

            @Override
            protected void done() {
                try {
                    LookupProperties lookupProperties = (LookupProperties)this.get();
                    String string = lookupProperties.getAdvancedSearchSavedFiltersJson();
                    if (string == null || string.trim().isEmpty()) {
                        string = "[]";
                    }
                    AdvancedSearchDialog.this.applySavedFiltersJson(string);
                }
                catch (Exception exception) {
                    AdvancedSearchDialog.this.showError("Failed to load saved filters.\n" + exception.getMessage());
                    AdvancedSearchDialog.this.applySavedFiltersJson("[]");
                }
            }
        };
        swingWorker.execute();
    }

    private void saveSavedFiltersToServer() {
        try {
            ArrayList<SavedFilterEntry> arrayList = Collections.list(this.savedFilterListModel.elements());
            String string = JsonUtils.toJson(arrayList);
            LookupProperties lookupProperties = new LookupProperties(false, 0, string);
            this.parent.mirthClient.setPluginProperties("Lookup Table Management System", lookupProperties.toAdvancedSearchFilterProperties(), true);
        }
        catch (Exception exception) {
            this.logger.error("Unexpected error while saving settings", (Throwable)exception);
            this.showError("Unexpected error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage());
            return;
        }
    }

    private void applySavedFiltersJson(String string) {
        this.savedFilters.clear();
        try {
            List list = (List)JsonUtils.getMapper().readValue(string, (TypeReference)new TypeReference<List<SavedFilterEntry>>(){});
            if (list != null) {
                list.sort(Comparator.comparing(SavedFilterEntry::getName, String.CASE_INSENSITIVE_ORDER));
                for (SavedFilterEntry savedFilterEntry : list) {
                    if (savedFilterEntry.getName() == null) continue;
                    this.savedFilterListModel.addElement(savedFilterEntry);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.savedFilterList.clearSelection();
    }

    private void loadFilter() {
        SavedFilterEntry savedFilterEntry = this.savedFilterList.getSelectedValue();
        if (savedFilterEntry == null || savedFilterEntry.getState() == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Load this filter and discard current changes?", "Confirm Load", 0);
        if (n != 0) {
            return;
        }
        this.resetComponents(savedFilterEntry.getState());
    }

    private void deleteFilter() {
        SavedFilterEntry savedFilterEntry = this.savedFilterList.getSelectedValue();
        if (savedFilterEntry == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Delete saved filter '" + savedFilterEntry.getName() + "'?", "Confirm Delete", 0);
        if (n != 0) {
            return;
        }
        this.savedFilterListModel.removeElement(savedFilterEntry);
        this.saveSavedFiltersToServer();
        this.savedFilterList.clearSelection();
    }

    private void saveFilter() {
        AdvancedJsonFilterState advancedJsonFilterState = this.collectStateFromUi();
        if (advancedJsonFilterState == null) {
            return;
        }
        SavedFilterEntry savedFilterEntry = this.savedFilterList.getSelectedValue();
        JTextField jTextField = new JTextField(savedFilterEntry != null ? savedFilterEntry.getName() : "");
        if (savedFilterEntry != null) {
            JRadioButton jRadioButton = new JRadioButton("Overwrite selected filter", true);
            JRadioButton jRadioButton2 = new JRadioButton("Save as new filter");
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            Object[] objectArray = new Object[]{"Save current filter as:", jTextField, jRadioButton, jRadioButton2};
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), objectArray, "Save Filter", 2);
            if (n != 0) {
                return;
            }
            String string = jTextField.getText().trim();
            if (string.isEmpty()) {
                this.showError("Filter name cannot be empty.");
                return;
            }
            if (jRadioButton.isSelected()) {
                this.savedFilterListModel.removeElement(savedFilterEntry);
            }
            this.addOrReplaceFilter(string, advancedJsonFilterState);
        } else {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), new Object[]{"Filter name:", jTextField}, "Save Filter", 2);
            if (n != 0) {
                return;
            }
            String string = jTextField.getText().trim();
            if (string.isEmpty()) {
                this.showError("Filter name cannot be empty.");
                return;
            }
            this.addOrReplaceFilter(string, advancedJsonFilterState);
        }
        this.sortSavedFilterListModel();
        this.saveSavedFiltersToServer();
    }

    private void addOrReplaceFilter(String string, AdvancedJsonFilterState advancedJsonFilterState) {
        for (int i = 0; i < this.savedFilterListModel.size(); ++i) {
            SavedFilterEntry savedFilterEntry = this.savedFilterListModel.getElementAt(i);
            if (savedFilterEntry.getName() == null || !savedFilterEntry.getName().equalsIgnoreCase(string)) continue;
            this.savedFilterListModel.removeElement(savedFilterEntry);
            break;
        }
        SavedFilterEntry savedFilterEntry = new SavedFilterEntry(string, advancedJsonFilterState);
        this.savedFilterListModel.addElement(savedFilterEntry);
        this.savedFilterList.setSelectedValue(savedFilterEntry, true);
    }

    private AdvancedJsonFilterState collectStateFromUi() {
        if (this.conditionTable.isEditing()) {
            this.conditionTable.getCellEditor().stopCellEditing();
        }
        String string = this.getKeyPattern();
        List<JsonCondition> list = this.getConditions();
        if (string.isEmpty() && list.isEmpty()) {
            this.showError("Filter is empty. Please specify a Key Pattern or at least one JSON condition.");
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            JsonCondition jsonCondition = list.get(i);
            String string2 = jsonCondition.getField() != null ? jsonCondition.getField().trim() : "";
            String string3 = jsonCondition.getValue() != null ? jsonCondition.getValue().toString().trim() : "";
            jsonCondition.setField(string2);
            jsonCondition.setValue((Object)string3);
        }
        try {
            AdvancedJsonFilterValidator.validateCore(list);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.showError(illegalArgumentException.getMessage());
            return null;
        }
        AdvancedJsonFilterState advancedJsonFilterState = new AdvancedJsonFilterState();
        advancedJsonFilterState.setKeyPattern(string);
        advancedJsonFilterState.setConditions(list);
        return advancedJsonFilterState;
    }

    private void sortSavedFilterListModel() {
        if (this.savedFilterListModel.getSize() <= 1) {
            return;
        }
        ArrayList<SavedFilterEntry> arrayList = Collections.list(this.savedFilterListModel.elements());
        arrayList.sort(Comparator.comparing(SavedFilterEntry::getName, String.CASE_INSENSITIVE_ORDER));
        this.savedFilterListModel.clear();
        for (SavedFilterEntry savedFilterEntry : arrayList) {
            this.savedFilterListModel.addElement(savedFilterEntry);
        }
    }

    private void apply() {
        AdvancedJsonFilterState advancedJsonFilterState = this.collectStateFromUi();
        if (advancedJsonFilterState == null) {
            return;
        }
        this.currentState.setKeyPattern(advancedJsonFilterState.getKeyPattern());
        this.currentState.setConditions(advancedJsonFilterState.getConditions());
        this.okPressed = true;
        this.dispose();
    }

    private void close() {
        this.dispose();
    }

    private void addConditionRow() {
        this.conditionTableModel.addCondition(new JsonCondition("", JsonOperator.EQUAL, JsonValueType.STRING, (Object)""));
        int n = this.conditionTableModel.getRowCount() - 1;
        this.conditionTable.setRowSelectionInterval(n, n);
        this.conditionTable.editCellAt(n, 0);
    }

    private void removeSelectedRow() {
        int n = this.conditionTable.getSelectedRow();
        if (n >= 0) {
            this.conditionTableModel.removeCondition(n);
        }
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private String getKeyPattern() {
        return this.keyPatternField.getText().trim();
    }

    private List<JsonCondition> getConditions() {
        return new ArrayList<JsonCondition>(this.conditionTableModel.getConditions());
    }

    protected void showError(String string) {
        PlatformUI.MIRTH_FRAME.alertError((Component)((Object)this), string);
    }

    private static class ConditionTableModel
    extends AbstractTableModel {
        private final String[] columns = new String[]{"Field", "Operator", "Type", "Value"};
        private final List<JsonCondition> conditions = new ArrayList<JsonCondition>();

        private ConditionTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.conditions.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columns[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            JsonCondition jsonCondition = this.conditions.get(n);
            switch (n2) {
                case 0: {
                    return jsonCondition.getField();
                }
                case 1: {
                    return jsonCondition.getOp();
                }
                case 2: {
                    return jsonCondition.getValueType();
                }
                case 3: {
                    return jsonCondition.getValue() == null ? "" : jsonCondition.getValue().toString();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            JsonCondition jsonCondition = this.conditions.get(n);
            switch (n2) {
                case 0: {
                    jsonCondition.setField(object != null ? object.toString().trim() : "");
                    break;
                }
                case 1: {
                    jsonCondition.setOp((JsonOperator)object);
                    break;
                }
                case 2: {
                    jsonCondition.setValueType((JsonValueType)object);
                    break;
                }
                case 3: {
                    jsonCondition.setValue(object != null ? object.toString().trim() : null);
                    break;
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        public void addCondition(JsonCondition jsonCondition) {
            this.conditions.add(jsonCondition);
            int n = this.conditions.size() - 1;
            this.fireTableRowsInserted(n, n);
        }

        public void removeCondition(int n) {
            this.conditions.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public void setConditions(List<JsonCondition> list) {
            this.conditions.clear();
            if (list != null) {
                this.conditions.addAll(list);
            }
            this.fireTableDataChanged();
        }

        public List<JsonCondition> getConditions() {
            return this.conditions;
        }
    }

    private static final class SavedFilterEntry {
        private String name;
        private AdvancedJsonFilterState state;

        public SavedFilterEntry() {
        }

        public SavedFilterEntry(String string, AdvancedJsonFilterState advancedJsonFilterState) {
            this.name = string;
            this.state = advancedJsonFilterState;
        }

        public String getName() {
            return this.name;
        }

        public AdvancedJsonFilterState getState() {
            return this.state;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setState(AdvancedJsonFilterState advancedJsonFilterState) {
            this.state = advancedJsonFilterState;
        }

        public String toString() {
            return this.name != null ? this.name : "";
        }
    }
}

