/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.dialog;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.UIConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;

public class ImportLookupGroupDialog
extends MirthDialog {
    private Frame parent;
    private String[] defaultGroupNames = new String[]{"Race", "Ethnicity", "Administrative Gender", "Marital Status", "Religion"};
    private boolean saved = false;
    private JLabel importFromLabel;
    private JLabel fromSystemLabel;
    private JLabel fromFileLabel;
    private JRadioButton fromSystemRadioButton;
    private JRadioButton fromFileRadioButton;
    private JButton browseFileButton;
    private JTextField filePathField;
    private JComboBox<String> defaultGroupComboBox;
    private JButton importButton;
    private JButton cancelButton;
    private Properties importProperties;

    public ImportLookupGroupDialog(Frame frame) {
        super((Window)frame, true);
        this.parent = frame;
        this.initComponents();
        this.initLayout();
        this.setDefaultCloseOperation(2);
        this.setTitle(String.format("Import Default Lookup Group", new Object[0]));
        this.pack();
        this.setLocationRelativeTo((Component)frame);
        this.setVisible(true);
    }

    public void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        this.importFromLabel = new JLabel("Import Lookup Group from:");
        this.fromSystemRadioButton = new JRadioButton("System");
        this.fromSystemRadioButton.setBackground(this.getBackground());
        this.fromFileRadioButton = new JRadioButton("File");
        this.fromFileRadioButton.setBackground(this.getBackground());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.fromSystemRadioButton);
        buttonGroup.add(this.fromFileRadioButton);
        this.fromSystemRadioButton.setSelected(true);
        this.fromFileLabel = new JLabel("Import from file:");
        this.filePathField = new JTextField();
        this.browseFileButton = new JButton("Browse");
        this.browseFileButton.addActionListener(actionEvent -> {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new FileNameExtensionFilter("JSON files", "json"));
            File file = new File(Frame.userPreferences.get("currentDirectory", ""));
            if (file.exists()) {
                jFileChooser.setCurrentDirectory(file);
            }
            if (jFileChooser.showOpenDialog((Component)this.parent) == 0) {
                File file2 = jFileChooser.getSelectedFile();
                Frame.userPreferences.put("currentDirectory", file2.getParent());
                this.filePathField.setText(file2.getAbsolutePath());
            }
        });
        this.fromSystemLabel = new JLabel("Import from system:");
        this.defaultGroupComboBox = new JComboBox<String>(this.defaultGroupNames);
        this.importButton = new JButton("Import");
        this.cancelButton = new JButton("Cancel");
        this.importButton.addActionListener(actionEvent -> {
            this.setImportProperties(new Properties());
            this.saved = true;
            this.dispose();
        });
        this.cancelButton.addActionListener(actionEvent -> this.dispose());
        ItemListener itemListener = itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.handleSourceToggle();
            }
        };
        this.fromSystemRadioButton.addItemListener(itemListener);
        this.fromFileRadioButton.addItemListener(itemListener);
        this.handleSourceToggle();
    }

    private void handleSourceToggle() {
        boolean bl = this.fromSystemRadioButton.isSelected();
        this.fromSystemLabel.setEnabled(bl);
        this.defaultGroupComboBox.setEnabled(bl);
        this.fromFileLabel.setEnabled(!bl);
        this.filePathField.setEditable(!bl);
        this.browseFileButton.setEnabled(!bl);
        this.revalidate();
        this.repaint();
    }

    public void initLayout() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 20, fill, wrap 2", "[left]10[grow, fill]"));
        jPanel.setBackground(this.getBackground());
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("insets 0, wrap 3", "[][][]"));
        jPanel2.setBackground(this.getBackground());
        jPanel2.add(this.importFromLabel);
        jPanel2.add(this.fromSystemRadioButton);
        jPanel2.add(this.fromFileRadioButton);
        jPanel.add((Component)jPanel2, "span, align left, wrap");
        JLabel jLabel = new JLabel("Import from file:");
        jPanel.add(jLabel);
        jPanel.add((Component)this.filePathField, "growx, split 2");
        jPanel.add((Component)this.browseFileButton, "wrap");
        JLabel jLabel2 = new JLabel("Import from system:");
        jPanel.add(jLabel2);
        jPanel.add(this.defaultGroupComboBox, "growx, wrap");
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("insets 0", "[right]"));
        jPanel3.setBackground(this.getBackground());
        jPanel3.add((Component)this.importButton, "tag ok");
        jPanel3.add((Component)this.cancelButton, "tag cancel, gapleft 10");
        jPanel.add((Component)jPanel3, "span, align right");
        this.getContentPane().add(jPanel);
        this.setPreferredSize(new Dimension(500, 220));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public boolean isSaved() {
        return this.saved;
    }

    private void setImportProperties(Properties properties) {
        this.importProperties = new Properties();
        this.importProperties.setProperty("importMethod", this.fromSystemRadioButton.isSelected() ? "system" : "file");
        this.importProperties.setProperty("filePath", this.filePathField.getText());
        this.importProperties.setProperty("defaultGroup", (String)this.defaultGroupComboBox.getSelectedItem());
    }

    public Properties getImportProperties() {
        return this.importProperties;
    }
}

