/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.dialog;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.plugins.dynamiclookup.client.exception.LookupApiClientException;
import com.mirth.connect.plugins.dynamiclookup.client.service.LookupServiceClient;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.LookupValueResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupValue;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupValueDialog
extends MirthDialog {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private JLabel keyLabel;
    private JTextField keyField;
    private JLabel valueLabel;
    private JTextArea valueField;
    private JScrollPane valueScrollPane;
    private JButton saveButton;
    private JButton cancelButton;
    private Frame parent;
    private LookupValue lookupValue;
    private LookupGroup lookupGroup;
    private boolean isEdit = false;
    private boolean saved = false;

    public LookupValueDialog(Frame frame, LookupValue lookupValue, LookupGroup lookupGroup, boolean bl) {
        super((Window)frame, true);
        this.parent = frame;
        this.isEdit = bl;
        this.lookupValue = lookupValue;
        this.lookupGroup = lookupGroup;
        this.initComponents();
        this.initLayout();
        this.resetComponents(lookupValue);
        this.setDefaultCloseOperation(2);
        this.setTitle(String.format("Group %s - %s", lookupGroup.getName(), bl ? "Edit Value" : "Add Value"));
        this.pack();
        this.setLocationRelativeTo((Component)frame);
        this.setVisible(true);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        this.keyLabel = new JLabel("Key:");
        this.keyField = new JTextField();
        this.valueLabel = new JLabel("Value:");
        this.valueField = new JTextArea(5, 30);
        this.valueField.setLineWrap(true);
        this.valueField.setWrapStyleWord(true);
        this.valueScrollPane = new JScrollPane(this.valueField);
        this.valueScrollPane.setVerticalScrollBarPolicy(20);
        this.valueScrollPane.setHorizontalScrollBarPolicy(31);
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(actionEvent -> this.save());
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(actionEvent -> this.close());
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, hidemode 0, align center, insets 0 0 0 0, fill", "25[right][grow,fill]"));
        jPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add((Component)this.keyLabel, "right");
        jPanel.add((Component)this.keyField, "wmin 200, growx");
        jPanel.add((Component)this.valueLabel, "newline, right");
        jPanel.add((Component)this.valueScrollPane, "wmin 200, hmin 120, grow, push");
        this.add(jPanel, "grow, push");
        this.add(new JSeparator(), "newline, sx, growx");
        this.add(this.saveButton, "newline, sx, right, split 2");
        this.add(this.cancelButton);
    }

    private void resetComponents(LookupValue lookupValue) {
        this.keyField.setText(lookupValue.getKeyValue());
        this.valueField.setText(lookupValue.getValueData());
        this.keyField.setEnabled(!this.isEdit);
    }

    private void save() {
        if (!this.validateProperties()) {
            return;
        }
        try {
            this.lookupValue.setKeyValue(this.keyField.getText().trim());
            this.lookupValue.setValueData(this.valueField.getText().trim());
            if (!this.isEdit) {
                int n;
                boolean bl;
                try {
                    bl = LookupServiceClient.getInstance().checkValueExists(this.lookupGroup.getId(), this.lookupValue.getKeyValue());
                }
                catch (LookupApiClientException lookupApiClientException) {
                    this.showError("Error checking for existing value: " + lookupApiClientException.getError().getMessage());
                    return;
                }
                catch (Exception exception) {
                    this.logger.error("Unexpected error while checking existing value", (Throwable)exception);
                    this.showError("Unexpected error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage());
                    return;
                }
                if (bl && (n = JOptionPane.showConfirmDialog((Component)((Object)this), "A value with the same key already exists. Do you want to overwrite it?", "Confirm Overwrite", 0, 2)) != 0) {
                    return;
                }
            }
            LookupValueResponse lookupValueResponse = LookupServiceClient.getInstance().setValue(this.lookupGroup.getId(), this.lookupValue);
            this.lookupValue.setKeyValue(lookupValueResponse.getKey());
            this.lookupValue.setValueData(lookupValueResponse.getValue());
            this.lookupValue.setCreatedDate(lookupValueResponse.getCreatedDate());
            this.lookupValue.setUpdatedDate(lookupValueResponse.getUpdatedDate());
            this.saved = true;
            this.close();
        }
        catch (LookupApiClientException lookupApiClientException) {
            this.showError(lookupApiClientException.getError().getMessage());
        }
        catch (Exception exception) {
            this.logger.error("Unexpected error while saving value", (Throwable)exception);
            this.showError("Unexpected error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage());
        }
    }

    private void close() {
        this.dispose();
    }

    public boolean isSaved() {
        return this.saved;
    }

    private boolean validateProperties() {
        String string;
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        this.resetInvalidComponents();
        String string2 = this.keyField.getText().trim();
        if (StringUtils.isEmpty((CharSequence)string2)) {
            bl = false;
            this.keyField.setBackground(UIConstants.INVALID_COLOR);
            stringBuilder.append("Please provide a key.").append(System.lineSeparator());
        }
        if (StringUtils.isEmpty((CharSequence)(string = this.valueField.getText().trim()))) {
            bl = false;
            this.valueField.setBackground(UIConstants.INVALID_COLOR);
            stringBuilder.append("Please provide a value.").append(System.lineSeparator());
        }
        if (!bl) {
            this.showError(stringBuilder.toString());
        }
        return bl;
    }

    public void resetInvalidComponents() {
        this.keyField.setBackground(null);
        this.valueField.setBackground(null);
    }

    protected void showInformation(String string) {
        PlatformUI.MIRTH_FRAME.alertInformation((Component)((Object)this), string);
    }

    protected void showError(String string) {
        PlatformUI.MIRTH_FRAME.alertError((Component)((Object)this), string);
    }
}

