/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.model;

import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupValue;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class LookupValueTableModel
extends AbstractTableModel {
    public static final int KEY_COLUMN = 0;
    public static final int VALUE_COLUMN = 1;
    public static final int UPDATED_DATE_COLUMN = 2;
    public static final int ACTION_COLUMN = 3;
    private final String[] columnNames = new String[]{"Key", "Value", "Updated Date", "Action"};
    private final List<LookupValue> values = new ArrayList<LookupValue>();
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm a");

    @Override
    public int getRowCount() {
        return this.values.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        LookupValue lookupValue = this.values.get(n);
        switch (n2) {
            case 0: {
                return lookupValue.getKeyValue();
            }
            case 1: {
                return lookupValue.getValueData();
            }
            case 2: {
                return this.formatter.format(lookupValue.getUpdatedDate());
            }
            case 3: {
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 3;
    }

    public void addValue(LookupValue lookupValue) {
        this.values.add(lookupValue);
        this.fireTableDataChanged();
    }

    public void removeValue(int n) {
        this.values.remove(n);
        this.fireTableDataChanged();
    }

    public void updateValue(int n, LookupValue lookupValue) {
        this.values.set(n, lookupValue);
        this.fireTableDataChanged();
    }

    public LookupValue getValue(int n) {
        return this.values.get(n);
    }

    public void setValues(List<LookupValue> list) {
        this.values.clear();
        this.values.addAll(list);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.values.clear();
        this.fireTableDataChanged();
    }
}

