/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.cli.launcher;

import com.mirth.connect.cli.launcher.ManifestDirectory;
import com.mirth.connect.cli.launcher.ManifestEntry;
import com.mirth.connect.cli.launcher.ManifestFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CommandLineLauncher {
    protected static Logger logger;

    public static void main(String[] args) {
        System.setProperty("log4j2.configurationFile", "log4j2-cli.properties");
        logger = LogManager.getLogger(CommandLineLauncher.class);
        try {
            ManifestFile mirthCliJar = new ManifestFile("cli-lib/mirth-cli.jar");
            ManifestFile mirthClientCoreJar = new ManifestFile("cli-lib/mirth-client-core.jar");
            ManifestDirectory cliLibDir = new ManifestDirectory("cli-lib");
            cliLibDir.setExcludes(new String[]{"mirth-client-core.jar"});
            ManifestEntry[] manifest = new ManifestEntry[]{mirthCliJar, mirthClientCoreJar, cliLibDir};
            ArrayList<URL> classpathUrls = new ArrayList<URL>();
            CommandLineLauncher.addManifestToClasspath(manifest, classpathUrls);
            File extensions = new File("./extensions");
            CommandLineLauncher.addSharedLibsToClasspath(classpathUrls, extensions);
            URLClassLoader classLoader = new URLClassLoader(classpathUrls.toArray(new URL[classpathUrls.size()]));
            Class<?> cliClass = classLoader.loadClass("com.mirth.connect.cli.CommandLineInterface");
            Thread.currentThread().setContextClassLoader(classLoader);
            Constructor<?>[] constructors = cliClass.getDeclaredConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Class<?>[] parameters = constructors[i].getParameterTypes();
                if (parameters.length != 1) continue;
                constructors[i].newInstance(new Object[]{args});
                i = constructors.length;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addManifestToClasspath(ManifestEntry[] manifestEntries, List<URL> urls) throws Exception {
        for (ManifestEntry manifestEntry : manifestEntries) {
            File manifestEntryFile = new File(manifestEntry.getName());
            if (manifestEntryFile.exists()) {
                if (manifestEntryFile.isDirectory()) {
                    ManifestDirectory manifestDir = (ManifestDirectory)manifestEntry;
                    IOFileFilter fileFilter = null;
                    fileFilter = manifestDir.getExcludes().length > 0 ? FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.fileFileFilter(), FileFilterUtils.notFileFilter((IOFileFilter)new NameFileFilter(manifestDir.getExcludes()))}) : FileFilterUtils.fileFileFilter();
                    Collection pathFiles = FileUtils.listFiles((File)manifestEntryFile, (IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.trueFileFilter());
                    for (File pathFile : pathFiles) {
                        logger.trace("adding library to classpath: " + pathFile.getAbsolutePath());
                        urls.add(pathFile.toURI().toURL());
                    }
                    continue;
                }
                logger.trace("adding library to classpath: " + manifestEntryFile.getAbsolutePath());
                urls.add(manifestEntryFile.toURI().toURL());
                continue;
            }
            logger.warn("manifest path not found: " + manifestEntryFile.getAbsolutePath());
        }
    }

    private static void addSharedLibsToClasspath(List<URL> urls, File extensionsFolder) throws Exception {
        if (extensionsFolder.exists() && extensionsFolder.isDirectory()) {
            File[] directoryFiles;
            for (File d : directoryFiles = extensionsFolder.listFiles((FileFilter)FileFilterUtils.directoryFileFilter())) {
                if (!d.isDirectory()) continue;
                Set<String> libsFound = CommandLineLauncher.getSharedLibsForExtension(d);
                for (String libStr : libsFound) {
                    File lib = new File(d, libStr);
                    urls.add(lib.toURI().toURL());
                }
            }
        } else {
            logger.warn("no extensions folder found");
        }
    }

    protected static Set<String> getSharedLibsForExtension(File extensionFolder) throws Exception {
        LinkedList<String> extensionXml = new LinkedList<String>();
        extensionXml.add("source.xml");
        extensionXml.add("destination.xml");
        extensionXml.add("plugin.xml");
        HashSet<String> libs = new HashSet<String>();
        if (extensionFolder.exists() && extensionFolder.isDirectory()) {
            NameFileFilter extensionXmlFileFilter = new NameFileFilter(extensionXml);
            Collection xmlFiles = FileUtils.listFiles((File)extensionFolder, (IOFileFilter)extensionXmlFileFilter, (IOFileFilter)FileFilterUtils.trueFileFilter());
            for (File f : xmlFiles) {
                Element root = CommandLineLauncher.parseXml(FileUtils.readFileToString((File)f)).getDocumentElement();
                List<String> newLibs = CommandLineLauncher.getSharedLibsFromXml(root);
                libs.addAll(newLibs);
            }
        } else {
            logger.warn("no extension found");
        }
        return libs;
    }

    private static List<String> getSharedLibsFromXml(Element root) throws IOException, ParserConfigurationException, SAXException {
        LinkedList<String> sharedLibs = new LinkedList<String>();
        NodeList libs = root.getElementsByTagName("library");
        for (int i = 0; i < libs.getLength(); ++i) {
            Element libElement = (Element)libs.item(i);
            String type = libElement.getAttribute("type");
            if (!"SHARED".equalsIgnoreCase(type)) continue;
            sharedLibs.add(libElement.getAttribute("path"));
        }
        return sharedLibs;
    }

    private static Document parseXml(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml));
        return builder.parse(is);
    }
}

