/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.hl7v2;

import com.mirth.connect.model.hl7v2.Component;
import com.mirth.connect.model.util.MessageVocabulary;
import com.mirth.connect.plugins.datatypes.hl7v2.HL7v2DataTypeDelegate;

public class HL7v2Vocabulary
extends MessageVocabulary {
    private String version;

    public HL7v2Vocabulary(String version, String type) {
        super(version, type);
        this.version = version.replaceAll("\\.", "");
    }

    public String getDescription(String elementId) {
        try {
            if (elementId.indexOf(46) < 0) {
                if (elementId.length() < 4) {
                    return Component.getSegmentDescription((String)this.version, (String)elementId);
                }
                return Component.getMessageDescription((String)this.version, (String)elementId);
            }
            String[] parts = elementId.split("\\.");
            if (parts.length == 3) {
                return Component.getCompositeFieldDescriptionWithSegment((String)this.version, (String)elementId, (boolean)false);
            }
            if (parts.length == 2) {
                String description = "";
                try {
                    description = Component.getSegmentFieldDescription((String)this.version, (String)elementId, (boolean)false);
                }
                catch (Exception e) {
                    description = Component.getCompositeFieldDescription((String)this.version, (String)elementId, (boolean)false);
                }
                return description;
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getDataType() {
        return new HL7v2DataTypeDelegate().getName();
    }
}

