/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.commons.encryption.util;

import com.mirth.commons.encryption.Digester;
import com.mirth.commons.encryption.Output;
import java.security.Provider;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DigestUtil {
    public static void main(String[] args) {
        Options options = new Options();
        OptionBuilder.withArgName((String)"algorithm");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the algorithm to use");
        Option algorithmOption = OptionBuilder.create((String)"a");
        OptionBuilder.withArgName((String)"format");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the format to use");
        Option formatOption = OptionBuilder.create((String)"f");
        OptionBuilder.withArgName((String)"text");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the text to hash");
        Option textOption = OptionBuilder.create((String)"t");
        Option helpOption = new Option("h", "print this message");
        options.addOption(algorithmOption);
        options.addOption(formatOption);
        options.addOption(textOption);
        options.addOption(helpOption);
        PosixParser parser = new PosixParser();
        Digester digester = new Digester();
        digester.setProvider((Provider)new BouncyCastleProvider());
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("t")) {
                if (line.hasOption("a")) {
                    digester.setAlgorithm(line.getOptionValue("a"));
                }
                if (line.hasOption("f")) {
                    if (line.getOptionValue("f").equalsIgnoreCase("base64")) {
                        digester.setFormat(Output.BASE64);
                    } else if (line.getOptionValue("f").equalsIgnoreCase("hex")) {
                        digester.setFormat(Output.HEXADECIMAL);
                    }
                }
                System.out.println(digester.digest(line.getOptionValue("t")));
            } else if (line.hasOption("h")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("DigestUtil", options);
            } else {
                System.err.println("No input text specified.");
            }
        }
        catch (ParseException e) {
            System.err.println("Parsing failed. " + e.getMessage());
        }
    }
}

