/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.httpauth;

import com.mirth.connect.client.ui.AbstractConnectorPropertiesPanel;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.converters.PluginPropertiesConverter;
import com.mirth.connect.plugins.ConnectorPropertiesPlugin;
import com.mirth.connect.plugins.httpauth.HttpAuthConnectorPropertiesPanel;
import com.mirth.connect.plugins.httpauth.oauth2.OAuth2HttpAuthProperties;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;

public class HttpAuthConnectorPropertiesPlugin
extends ConnectorPropertiesPlugin {
    public HttpAuthConnectorPropertiesPlugin(String pluginName) {
        super(pluginName);
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        XStream xstream = serializer.getXStream();
        xstream.registerLocalConverter(OAuth2HttpAuthProperties.class, "connectorPluginProperties", (Converter)new PluginPropertiesConverter(serializer.getNormalizedVersion(), xstream.getMapper()));
    }

    public String getPluginPointName() {
        return "HTTP Auth Connector Plugin Properties";
    }

    public String getSettingsTitle() {
        return "HTTP Authentication";
    }

    public AbstractConnectorPropertiesPanel getConnectorPropertiesPanel() {
        return new HttpAuthConnectorPropertiesPanel();
    }

    public boolean isSupported(String transportName) {
        return transportName.equals("HTTP Listener") || transportName.equals("Web Service Listener") || transportName.equals("FHIR Listener") || transportName.equals("Health Data Hub Listener");
    }

    public boolean isConnectorPropertiesPluginSupported(String pluginPointName) {
        return false;
    }
}

