/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jdbc;

import com.mirth.connect.connectors.jdbc.CustomDriver;
import com.mirth.connect.connectors.jdbc.DatabaseDispatcher;
import com.mirth.connect.connectors.jdbc.DatabaseDispatcherDelegate;
import com.mirth.connect.connectors.jdbc.DatabaseDispatcherException;
import com.mirth.connect.connectors.jdbc.DatabaseDispatcherProperties;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.dbutils.DbUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseDispatcherQuery
implements DatabaseDispatcherDelegate {
    private static final long MAX_CONNECTION_IDLE_TIME_NS = 300000000000L;
    private DatabaseDispatcher connector;
    private Map<Long, SimpleDataSource> dataSources = new ConcurrentHashMap<Long, SimpleDataSource>();
    private ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private CustomDriver customDriver;
    private Logger logger = LogManager.getLogger(this.getClass());
    private volatile String contextFactoryId;

    public DatabaseDispatcherQuery(DatabaseDispatcher connector) {
        this.connector = connector;
    }

    @Override
    public void deploy() throws ConnectorTaskException {
        MirthContextFactory contextFactory;
        try {
            contextFactory = this.contextFactoryController.getContextFactory(this.connector.getResourceIds());
            this.contextFactoryId = contextFactory.getId();
        }
        catch (Exception e) {
            throw new ConnectorTaskException("Error retrieving context factory.", (Throwable)e);
        }
        try {
            this.initDriver(contextFactory);
        }
        catch (Exception e) {
            throw new ConnectorTaskException((Throwable)e);
        }
    }

    @Override
    public void undeploy() throws ConnectorTaskException {
    }

    @Override
    public void start() throws ConnectorTaskException {
    }

    @Override
    public void stop() throws ConnectorTaskException {
        Throwable firstThrowable = null;
        for (SimpleDataSource dataSource : this.dataSources.values()) {
            try {
                dataSource.closeConnection();
            }
            catch (Throwable t) {
                if (firstThrowable != null) continue;
                firstThrowable = t;
            }
        }
        if (firstThrowable != null) {
            throw new ConnectorTaskException("Failed to close one or more connections.", firstThrowable);
        }
        this.dataSources.clear();
    }

    @Override
    public void halt() throws ConnectorTaskException {
        this.stop();
    }

    @Override
    public Response send(DatabaseDispatcherProperties connectorProperties, ConnectorMessage connectorMessage) throws DatabaseDispatcherException {
        Response response;
        long dispatcherId = connectorMessage.getDispatcherId();
        SimpleDataSource dataSource = this.dataSources.get(dispatcherId);
        if (dataSource == null) {
            dataSource = new SimpleDataSource();
            this.dataSources.put(dispatcherId, dataSource);
        }
        PreparedStatement statement = null;
        try {
            Connection connection = dataSource.getConnection(connectorProperties);
            statement = connection.prepareStatement(connectorProperties.getQuery());
            int i = 1;
            for (Object param : connectorProperties.getParameters()) {
                statement.setObject(i++, param);
            }
            statement.execute();
            int numRows = statement.getUpdateCount();
            String responseData = null;
            Object responseMessageStatus = null;
            responseMessageStatus = numRows == -1 ? "Database write success" : "Database write success, " + numRows + " rows updated";
            response = new Response(Status.SENT, responseData, (String)responseMessageStatus);
        }
        catch (Exception e) {
            try {
                throw new DatabaseDispatcherException("Failed to write to database", e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)statement);
        return response;
    }

    private void initDriver(MirthContextFactory contextFactory) throws Exception {
        this.customDriver = null;
        DatabaseDispatcherProperties props = (DatabaseDispatcherProperties)this.connector.getConnectorProperties();
        try {
            ClassLoader isolatedClassLoader = contextFactory.getIsolatedClassLoader();
            if (isolatedClassLoader != null) {
                this.customDriver = new CustomDriver(isolatedClassLoader, props.getDriver());
                this.logger.debug("Custom driver created: " + this.customDriver.toString() + ", Version " + this.customDriver.getMajorVersion() + "." + this.customDriver.getMinorVersion());
            } else {
                this.logger.debug("Custom classloader is not being used, defaulting to DriverManager.");
            }
        }
        catch (Exception e) {
            this.logger.debug("Error creating custom driver, defaulting to DriverManager.", (Throwable)e);
        }
        if (this.customDriver == null) {
            Class.forName(props.getDriver());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkContextFactory() throws Exception {
        boolean contextFactoryChanged = false;
        MirthContextFactory contextFactory = this.contextFactoryController.getContextFactory(this.connector.getResourceIds());
        if (!this.contextFactoryId.equals(contextFactory.getId())) {
            contextFactoryChanged = true;
            DatabaseDispatcherQuery databaseDispatcherQuery = this;
            synchronized (databaseDispatcherQuery) {
                contextFactory = this.contextFactoryController.getContextFactory(this.connector.getResourceIds());
                if (!this.contextFactoryId.equals(contextFactory.getId())) {
                    this.initDriver(contextFactory);
                    this.contextFactoryId = contextFactory.getId();
                }
            }
        }
        return contextFactoryChanged;
    }

    private class SimpleDataSource {
        private Connection connection;
        private String username;
        private String password;
        private String url;
        private long lastAccessTime;

        private SimpleDataSource() {
        }

        public Connection getConnection(DatabaseDispatcherProperties properties) throws Exception {
            boolean contextFactoryChanged = DatabaseDispatcherQuery.this.checkContextFactory();
            if (contextFactoryChanged || this.connection == null || this.connection.isClosed() || this.lastAccessTime < System.nanoTime() - 300000000000L || !properties.getUsername().equals(this.username) || !properties.getPassword().equals(this.password) || !properties.getUrl().equals(this.url)) {
                this.closeConnection();
                DatabaseDispatcherQuery.this.logger.debug("Creating connection to " + properties.getUrl());
                this.connection = DatabaseDispatcherQuery.this.customDriver != null ? DatabaseDispatcherQuery.this.customDriver.connect(properties.getUrl(), properties.getUsername(), properties.getPassword()) : DriverManager.getConnection(properties.getUrl(), properties.getUsername(), properties.getPassword());
                this.connection.setAutoCommit(true);
                this.username = properties.getUsername();
                this.password = properties.getPassword();
                this.url = properties.getUrl();
            }
            this.lastAccessTime = System.nanoTime();
            return this.connection;
        }

        public void closeConnection() throws SQLException {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
    }
}

