/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.OSM_R26_SPECIMEN;
import ca.uhn.hl7v2.model.v281.segment.PAC;
import ca.uhn.hl7v2.model.v281.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OSM_R26_PACKAGE
extends AbstractGroup {
    public OSM_R26_PACKAGE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PAC.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(OSM_R26_SPECIMEN.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OSM_R26_PACKAGE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public PAC getPAC() {
        PAC retVal = (PAC)this.getTyped("PAC", PAC.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public OSM_R26_SPECIMEN getSPECIMEN() {
        OSM_R26_SPECIMEN retVal = (OSM_R26_SPECIMEN)this.getTyped("SPECIMEN", OSM_R26_SPECIMEN.class);
        return retVal;
    }

    public OSM_R26_SPECIMEN getSPECIMEN(int rep) {
        OSM_R26_SPECIMEN retVal = (OSM_R26_SPECIMEN)this.getTyped("SPECIMEN", rep, OSM_R26_SPECIMEN.class);
        return retVal;
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<OSM_R26_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", OSM_R26_SPECIMEN.class);
    }

    public void insertSPECIMEN(OSM_R26_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", (Structure)structure, rep);
    }

    public OSM_R26_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (OSM_R26_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public OSM_R26_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (OSM_R26_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }
}

