/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.DER_O44_DONATION_ORDER;
import ca.uhn.hl7v2.model.v281.group.DER_O44_DONOR;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.SFT;
import ca.uhn.hl7v2.model.v281.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class DER_O44
extends AbstractMessage {
    public DER_O44() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public DER_O44(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(DER_O44_DONOR.class, false, false);
            this.add(DER_O44_DONATION_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DER_O44 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public DER_O44_DONOR getDONOR() {
        return (DER_O44_DONOR)this.getTyped("DONOR", DER_O44_DONOR.class);
    }

    public DER_O44_DONATION_ORDER getDONATION_ORDER() {
        return (DER_O44_DONATION_ORDER)this.getTyped("DONATION_ORDER", DER_O44_DONATION_ORDER.class);
    }

    public DER_O44_DONATION_ORDER getDONATION_ORDER(int rep) {
        return (DER_O44_DONATION_ORDER)this.getTyped("DONATION_ORDER", rep, DER_O44_DONATION_ORDER.class);
    }

    public int getDONATION_ORDERReps() {
        return this.getReps("DONATION_ORDER");
    }

    public List<DER_O44_DONATION_ORDER> getDONATION_ORDERAll() throws HL7Exception {
        return this.getAllAsList("DONATION_ORDER", DER_O44_DONATION_ORDER.class);
    }

    public void insertDONATION_ORDER(DER_O44_DONATION_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("DONATION_ORDER", (Structure)structure, rep);
    }

    public DER_O44_DONATION_ORDER insertDONATION_ORDER(int rep) throws HL7Exception {
        return (DER_O44_DONATION_ORDER)super.insertRepetition("DONATION_ORDER", rep);
    }

    public DER_O44_DONATION_ORDER removeDONATION_ORDER(int rep) throws HL7Exception {
        return (DER_O44_DONATION_ORDER)super.removeRepetition("DONATION_ORDER", rep);
    }
}

