/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.MFN_M16_MATERIAL_ITEM_RECORD;
import ca.uhn.hl7v2.model.v281.segment.MFI;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.SFT;
import ca.uhn.hl7v2.model.v281.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M16
extends AbstractMessage {
    public MFN_M16() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFN_M16(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M16_MATERIAL_ITEM_RECORD.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M16 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public MFI getMFI() {
        return (MFI)this.getTyped("MFI", MFI.class);
    }

    public MFN_M16_MATERIAL_ITEM_RECORD getMATERIAL_ITEM_RECORD() {
        return (MFN_M16_MATERIAL_ITEM_RECORD)this.getTyped("MATERIAL_ITEM_RECORD", MFN_M16_MATERIAL_ITEM_RECORD.class);
    }

    public MFN_M16_MATERIAL_ITEM_RECORD getMATERIAL_ITEM_RECORD(int rep) {
        return (MFN_M16_MATERIAL_ITEM_RECORD)this.getTyped("MATERIAL_ITEM_RECORD", rep, MFN_M16_MATERIAL_ITEM_RECORD.class);
    }

    public int getMATERIAL_ITEM_RECORDReps() {
        return this.getReps("MATERIAL_ITEM_RECORD");
    }

    public List<MFN_M16_MATERIAL_ITEM_RECORD> getMATERIAL_ITEM_RECORDAll() throws HL7Exception {
        return this.getAllAsList("MATERIAL_ITEM_RECORD", MFN_M16_MATERIAL_ITEM_RECORD.class);
    }

    public void insertMATERIAL_ITEM_RECORD(MFN_M16_MATERIAL_ITEM_RECORD structure, int rep) throws HL7Exception {
        super.insertRepetition("MATERIAL_ITEM_RECORD", (Structure)structure, rep);
    }

    public MFN_M16_MATERIAL_ITEM_RECORD insertMATERIAL_ITEM_RECORD(int rep) throws HL7Exception {
        return (MFN_M16_MATERIAL_ITEM_RECORD)super.insertRepetition("MATERIAL_ITEM_RECORD", rep);
    }

    public MFN_M16_MATERIAL_ITEM_RECORD removeMATERIAL_ITEM_RECORD(int rep) throws HL7Exception {
        return (MFN_M16_MATERIAL_ITEM_RECORD)super.removeRepetition("MATERIAL_ITEM_RECORD", rep);
    }
}

