/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.SIU_S12_PATIENT;
import ca.uhn.hl7v2.model.v281.group.SIU_S12_RESOURCES;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.NTE;
import ca.uhn.hl7v2.model.v281.segment.SCH;
import ca.uhn.hl7v2.model.v281.segment.TQ1;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class SIU_S12
extends AbstractMessage {
    public SIU_S12() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public SIU_S12(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SCH.class, true, false);
            this.add(TQ1.class, false, true);
            this.add(NTE.class, false, true);
            this.add(SIU_S12_PATIENT.class, false, true);
            this.add(SIU_S12_RESOURCES.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SIU_S12 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SCH getSCH() {
        return (SCH)this.getTyped("SCH", SCH.class);
    }

    public TQ1 getTQ1() {
        return (TQ1)this.getTyped("TQ1", TQ1.class);
    }

    public TQ1 getTQ1(int rep) {
        return (TQ1)this.getTyped("TQ1", rep, TQ1.class);
    }

    public int getTQ1Reps() {
        return this.getReps("TQ1");
    }

    public List<TQ1> getTQ1All() throws HL7Exception {
        return this.getAllAsList("TQ1", TQ1.class);
    }

    public void insertTQ1(TQ1 structure, int rep) throws HL7Exception {
        super.insertRepetition("TQ1", (Structure)structure, rep);
    }

    public TQ1 insertTQ1(int rep) throws HL7Exception {
        return (TQ1)super.insertRepetition("TQ1", rep);
    }

    public TQ1 removeTQ1(int rep) throws HL7Exception {
        return (TQ1)super.removeRepetition("TQ1", rep);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public SIU_S12_PATIENT getPATIENT() {
        return (SIU_S12_PATIENT)this.getTyped("PATIENT", SIU_S12_PATIENT.class);
    }

    public SIU_S12_PATIENT getPATIENT(int rep) {
        return (SIU_S12_PATIENT)this.getTyped("PATIENT", rep, SIU_S12_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<SIU_S12_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", SIU_S12_PATIENT.class);
    }

    public void insertPATIENT(SIU_S12_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", (Structure)structure, rep);
    }

    public SIU_S12_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (SIU_S12_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public SIU_S12_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (SIU_S12_PATIENT)super.removeRepetition("PATIENT", rep);
    }

    public SIU_S12_RESOURCES getRESOURCES() {
        return (SIU_S12_RESOURCES)this.getTyped("RESOURCES", SIU_S12_RESOURCES.class);
    }

    public SIU_S12_RESOURCES getRESOURCES(int rep) {
        return (SIU_S12_RESOURCES)this.getTyped("RESOURCES", rep, SIU_S12_RESOURCES.class);
    }

    public int getRESOURCESReps() {
        return this.getReps("RESOURCES");
    }

    public List<SIU_S12_RESOURCES> getRESOURCESAll() throws HL7Exception {
        return this.getAllAsList("RESOURCES", SIU_S12_RESOURCES.class);
    }

    public void insertRESOURCES(SIU_S12_RESOURCES structure, int rep) throws HL7Exception {
        super.insertRepetition("RESOURCES", (Structure)structure, rep);
    }

    public SIU_S12_RESOURCES insertRESOURCES(int rep) throws HL7Exception {
        return (SIU_S12_RESOURCES)super.insertRepetition("RESOURCES", rep);
    }

    public SIU_S12_RESOURCES removeRESOURCES(int rep) throws HL7Exception {
        return (SIU_S12_RESOURCES)super.removeRepetition("RESOURCES", rep);
    }
}

