/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CP;
import ca.uhn.hl7v2.model.v281.datatype.CQ;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.EI;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.MO;
import ca.uhn.hl7v2.model.v281.datatype.ST;
import ca.uhn.hl7v2.model.v281.datatype.XCN;
import ca.uhn.hl7v2.model.v281.datatype.XON;
import ca.uhn.hl7v2.model.v281.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class AUT
extends AbstractSegment {
    public AUT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorizing Payor, Plan ID");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Authorizing Payor, Company ID");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorizing Payor, Company Name");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorization Effective Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorization Expiration Date");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorization Identifier");
            this.add(CP.class, false, 1, 0, new Object[]{this.getMessage()}, "Reimbursement Limit");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Requested Number of Treatments");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorized Number of Treatments");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Process Date");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Requested Discipline(s)");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Authorized Discipline(s)");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Authorization Referral Type");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Approval Status");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Planned Treatment Stop Date");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Clinical Service");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Reason Text");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Number of Authorized Treatments/Units");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Number of Used Treatments/Units");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Number of Schedule Treatments/Units");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Encounter Type");
            this.add(MO.class, false, 1, 0, new Object[]{this.getMessage()}, "Remaining Benefit Amount");
            this.add(XON.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorized Provider");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorized Health Professional");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Source Text");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Source Date");
            this.add(XTN.class, false, 1, 0, new Object[]{this.getMessage()}, "Source Phone");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Comment");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(206)}, "Action Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating AUT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE getAuthorizingPayorPlanID() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getAut1_AuthorizingPayorPlanID() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getAuthorizingPayorCompanyID() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getAut2_AuthorizingPayorCompanyID() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getAuthorizingPayorCompanyName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getAut3_AuthorizingPayorCompanyName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getAuthorizationEffectiveDate() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getAut4_AuthorizationEffectiveDate() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getAuthorizationExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getAut5_AuthorizationExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public EI getAuthorizationIdentifier() {
        EI retVal = (EI)this.getTypedField(6, 0);
        return retVal;
    }

    public EI getAut6_AuthorizationIdentifier() {
        EI retVal = (EI)this.getTypedField(6, 0);
        return retVal;
    }

    public CP getReimbursementLimit() {
        CP retVal = (CP)this.getTypedField(7, 0);
        return retVal;
    }

    public CP getAut7_ReimbursementLimit() {
        CP retVal = (CP)this.getTypedField(7, 0);
        return retVal;
    }

    public CQ getRequestedNumberOfTreatments() {
        CQ retVal = (CQ)this.getTypedField(8, 0);
        return retVal;
    }

    public CQ getAut8_RequestedNumberOfTreatments() {
        CQ retVal = (CQ)this.getTypedField(8, 0);
        return retVal;
    }

    public CQ getAuthorizedNumberOfTreatments() {
        CQ retVal = (CQ)this.getTypedField(9, 0);
        return retVal;
    }

    public CQ getAut9_AuthorizedNumberOfTreatments() {
        CQ retVal = (CQ)this.getTypedField(9, 0);
        return retVal;
    }

    public DTM getProcessDate() {
        DTM retVal = (DTM)this.getTypedField(10, 0);
        return retVal;
    }

    public DTM getAut10_ProcessDate() {
        DTM retVal = (DTM)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE[] getRequestedDisciplineS() {
        CWE[] retVal = (CWE[])this.getTypedField(11, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getAut11_RequestedDisciplineS() {
        CWE[] retVal = (CWE[])this.getTypedField(11, (Type[])new CWE[0]);
        return retVal;
    }

    public int getRequestedDisciplineSReps() {
        return this.getReps(11);
    }

    public CWE getRequestedDisciplineS(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public CWE getAut11_RequestedDisciplineS(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public int getAut11_RequestedDisciplineSReps() {
        return this.getReps(11);
    }

    public CWE insertRequestedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE insertAut11_RequestedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE removeRequestedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public CWE removeAut11_RequestedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public CWE[] getAuthorizedDisciplineS() {
        CWE[] retVal = (CWE[])this.getTypedField(12, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getAut12_AuthorizedDisciplineS() {
        CWE[] retVal = (CWE[])this.getTypedField(12, (Type[])new CWE[0]);
        return retVal;
    }

    public int getAuthorizedDisciplineSReps() {
        return this.getReps(12);
    }

    public CWE getAuthorizedDisciplineS(int rep) {
        CWE retVal = (CWE)this.getTypedField(12, rep);
        return retVal;
    }

    public CWE getAut12_AuthorizedDisciplineS(int rep) {
        CWE retVal = (CWE)this.getTypedField(12, rep);
        return retVal;
    }

    public int getAut12_AuthorizedDisciplineSReps() {
        return this.getReps(12);
    }

    public CWE insertAuthorizedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(12, rep);
    }

    public CWE insertAut12_AuthorizedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(12, rep);
    }

    public CWE removeAuthorizedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(12, rep);
    }

    public CWE removeAut12_AuthorizedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(12, rep);
    }

    public CWE getAuthorizationReferralType() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getAut13_AuthorizationReferralType() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getApprovalStatus() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getAut14_ApprovalStatus() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public DTM getPlannedTreatmentStopDate() {
        DTM retVal = (DTM)this.getTypedField(15, 0);
        return retVal;
    }

    public DTM getAut15_PlannedTreatmentStopDate() {
        DTM retVal = (DTM)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getClinicalService() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getAut16_ClinicalService() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public ST getReasonText() {
        ST retVal = (ST)this.getTypedField(17, 0);
        return retVal;
    }

    public ST getAut17_ReasonText() {
        ST retVal = (ST)this.getTypedField(17, 0);
        return retVal;
    }

    public CQ getNumberOfAuthorizedTreatmentsUnits() {
        CQ retVal = (CQ)this.getTypedField(18, 0);
        return retVal;
    }

    public CQ getAut18_NumberOfAuthorizedTreatmentsUnits() {
        CQ retVal = (CQ)this.getTypedField(18, 0);
        return retVal;
    }

    public CQ getNumberOfUsedTreatmentsUnits() {
        CQ retVal = (CQ)this.getTypedField(19, 0);
        return retVal;
    }

    public CQ getAut19_NumberOfUsedTreatmentsUnits() {
        CQ retVal = (CQ)this.getTypedField(19, 0);
        return retVal;
    }

    public CQ getNumberOfScheduleTreatmentsUnits() {
        CQ retVal = (CQ)this.getTypedField(20, 0);
        return retVal;
    }

    public CQ getAut20_NumberOfScheduleTreatmentsUnits() {
        CQ retVal = (CQ)this.getTypedField(20, 0);
        return retVal;
    }

    public CWE getEncounterType() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE getAut21_EncounterType() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public MO getRemainingBenefitAmount() {
        MO retVal = (MO)this.getTypedField(22, 0);
        return retVal;
    }

    public MO getAut22_RemainingBenefitAmount() {
        MO retVal = (MO)this.getTypedField(22, 0);
        return retVal;
    }

    public XON getAuthorizedProvider() {
        XON retVal = (XON)this.getTypedField(23, 0);
        return retVal;
    }

    public XON getAut23_AuthorizedProvider() {
        XON retVal = (XON)this.getTypedField(23, 0);
        return retVal;
    }

    public XCN getAuthorizedHealthProfessional() {
        XCN retVal = (XCN)this.getTypedField(24, 0);
        return retVal;
    }

    public XCN getAut24_AuthorizedHealthProfessional() {
        XCN retVal = (XCN)this.getTypedField(24, 0);
        return retVal;
    }

    public ST getSourceText() {
        ST retVal = (ST)this.getTypedField(25, 0);
        return retVal;
    }

    public ST getAut25_SourceText() {
        ST retVal = (ST)this.getTypedField(25, 0);
        return retVal;
    }

    public DTM getSourceDate() {
        DTM retVal = (DTM)this.getTypedField(26, 0);
        return retVal;
    }

    public DTM getAut26_SourceDate() {
        DTM retVal = (DTM)this.getTypedField(26, 0);
        return retVal;
    }

    public XTN getSourcePhone() {
        XTN retVal = (XTN)this.getTypedField(27, 0);
        return retVal;
    }

    public XTN getAut27_SourcePhone() {
        XTN retVal = (XTN)this.getTypedField(27, 0);
        return retVal;
    }

    public ST getComment() {
        ST retVal = (ST)this.getTypedField(28, 0);
        return retVal;
    }

    public ST getAut28_Comment() {
        ST retVal = (ST)this.getTypedField(28, 0);
        return retVal;
    }

    public ID getActionCode() {
        ID retVal = (ID)this.getTypedField(29, 0);
        return retVal;
    }

    public ID getAut29_ActionCode() {
        ID retVal = (ID)this.getTypedField(29, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new DTM(this.getMessage());
            }
            case 5: {
                return new EI(this.getMessage());
            }
            case 6: {
                return new CP(this.getMessage());
            }
            case 7: {
                return new CQ(this.getMessage());
            }
            case 8: {
                return new CQ(this.getMessage());
            }
            case 9: {
                return new DTM(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new DTM(this.getMessage());
            }
            case 15: {
                return new CWE(this.getMessage());
            }
            case 16: {
                return new ST(this.getMessage());
            }
            case 17: {
                return new CQ(this.getMessage());
            }
            case 18: {
                return new CQ(this.getMessage());
            }
            case 19: {
                return new CQ(this.getMessage());
            }
            case 20: {
                return new CWE(this.getMessage());
            }
            case 21: {
                return new MO(this.getMessage());
            }
            case 22: {
                return new XON(this.getMessage());
            }
            case 23: {
                return new XCN(this.getMessage());
            }
            case 24: {
                return new ST(this.getMessage());
            }
            case 25: {
                return new DTM(this.getMessage());
            }
            case 26: {
                return new XTN(this.getMessage());
            }
            case 27: {
                return new ST(this.getMessage());
            }
            case 28: {
                return new ID(this.getMessage(), new Integer(206));
            }
        }
        return null;
    }
}

