/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CNE;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.CX;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.NM;
import ca.uhn.hl7v2.model.v281.datatype.ST;
import ca.uhn.hl7v2.model.v281.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CDM
extends AbstractSegment {
    public CDM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Primary Key Value - CDM");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Charge Code Alias");
            this.add(ST.class, true, 1, 0, new Object[]{this.getMessage()}, "Charge Description Short");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Charge Description Long");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Description Override Indicator");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Exploding Charges");
            this.add(CNE.class, false, 0, 0, new Object[]{this.getMessage()}, "Procedure Code");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(183)}, "Active/Inactive Flag");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Inventory Number");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Resource Load");
            this.add(CX.class, false, 0, 0, new Object[]{this.getMessage()}, "Contract Number");
            this.add(XON.class, false, 0, 0, new Object[]{this.getMessage()}, "Contract Organization");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "Room Fee Indicator");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CDM - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE getPrimaryKeyValueCDM() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getCdm1_PrimaryKeyValueCDM() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE[] getChargeCodeAlias() {
        CWE[] retVal = (CWE[])this.getTypedField(2, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getCdm2_ChargeCodeAlias() {
        CWE[] retVal = (CWE[])this.getTypedField(2, (Type[])new CWE[0]);
        return retVal;
    }

    public int getChargeCodeAliasReps() {
        return this.getReps(2);
    }

    public CWE getChargeCodeAlias(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public CWE getCdm2_ChargeCodeAlias(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getCdm2_ChargeCodeAliasReps() {
        return this.getReps(2);
    }

    public CWE insertChargeCodeAlias(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE insertCdm2_ChargeCodeAlias(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE removeChargeCodeAlias(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE removeCdm2_ChargeCodeAlias(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public ST getChargeDescriptionShort() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getCdm3_ChargeDescriptionShort() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getChargeDescriptionLong() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getCdm4_ChargeDescriptionLong() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getDescriptionOverrideIndicator() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getCdm5_DescriptionOverrideIndicator() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE[] getExplodingCharges() {
        CWE[] retVal = (CWE[])this.getTypedField(6, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getCdm6_ExplodingCharges() {
        CWE[] retVal = (CWE[])this.getTypedField(6, (Type[])new CWE[0]);
        return retVal;
    }

    public int getExplodingChargesReps() {
        return this.getReps(6);
    }

    public CWE getExplodingCharges(int rep) {
        CWE retVal = (CWE)this.getTypedField(6, rep);
        return retVal;
    }

    public CWE getCdm6_ExplodingCharges(int rep) {
        CWE retVal = (CWE)this.getTypedField(6, rep);
        return retVal;
    }

    public int getCdm6_ExplodingChargesReps() {
        return this.getReps(6);
    }

    public CWE insertExplodingCharges(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(6, rep);
    }

    public CWE insertCdm6_ExplodingCharges(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(6, rep);
    }

    public CWE removeExplodingCharges(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(6, rep);
    }

    public CWE removeCdm6_ExplodingCharges(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(6, rep);
    }

    public CNE[] getProcedureCode() {
        CNE[] retVal = (CNE[])this.getTypedField(7, (Type[])new CNE[0]);
        return retVal;
    }

    public CNE[] getCdm7_ProcedureCode() {
        CNE[] retVal = (CNE[])this.getTypedField(7, (Type[])new CNE[0]);
        return retVal;
    }

    public int getProcedureCodeReps() {
        return this.getReps(7);
    }

    public CNE getProcedureCode(int rep) {
        CNE retVal = (CNE)this.getTypedField(7, rep);
        return retVal;
    }

    public CNE getCdm7_ProcedureCode(int rep) {
        CNE retVal = (CNE)this.getTypedField(7, rep);
        return retVal;
    }

    public int getCdm7_ProcedureCodeReps() {
        return this.getReps(7);
    }

    public CNE insertProcedureCode(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(7, rep);
    }

    public CNE insertCdm7_ProcedureCode(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(7, rep);
    }

    public CNE removeProcedureCode(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(7, rep);
    }

    public CNE removeCdm7_ProcedureCode(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(7, rep);
    }

    public ID getActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getCdm8_ActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE[] getInventoryNumber() {
        CWE[] retVal = (CWE[])this.getTypedField(9, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getCdm9_InventoryNumber() {
        CWE[] retVal = (CWE[])this.getTypedField(9, (Type[])new CWE[0]);
        return retVal;
    }

    public int getInventoryNumberReps() {
        return this.getReps(9);
    }

    public CWE getInventoryNumber(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public CWE getCdm9_InventoryNumber(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getCdm9_InventoryNumberReps() {
        return this.getReps(9);
    }

    public CWE insertInventoryNumber(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE insertCdm9_InventoryNumber(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE removeInventoryNumber(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public CWE removeCdm9_InventoryNumber(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public NM getResourceLoad() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getCdm10_ResourceLoad() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public CX[] getContractNumber() {
        CX[] retVal = (CX[])this.getTypedField(11, (Type[])new CX[0]);
        return retVal;
    }

    public CX[] getCdm11_ContractNumber() {
        CX[] retVal = (CX[])this.getTypedField(11, (Type[])new CX[0]);
        return retVal;
    }

    public int getContractNumberReps() {
        return this.getReps(11);
    }

    public CX getContractNumber(int rep) {
        CX retVal = (CX)this.getTypedField(11, rep);
        return retVal;
    }

    public CX getCdm11_ContractNumber(int rep) {
        CX retVal = (CX)this.getTypedField(11, rep);
        return retVal;
    }

    public int getCdm11_ContractNumberReps() {
        return this.getReps(11);
    }

    public CX insertContractNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(11, rep);
    }

    public CX insertCdm11_ContractNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(11, rep);
    }

    public CX removeContractNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(11, rep);
    }

    public CX removeCdm11_ContractNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(11, rep);
    }

    public XON[] getContractOrganization() {
        XON[] retVal = (XON[])this.getTypedField(12, (Type[])new XON[0]);
        return retVal;
    }

    public XON[] getCdm12_ContractOrganization() {
        XON[] retVal = (XON[])this.getTypedField(12, (Type[])new XON[0]);
        return retVal;
    }

    public int getContractOrganizationReps() {
        return this.getReps(12);
    }

    public XON getContractOrganization(int rep) {
        XON retVal = (XON)this.getTypedField(12, rep);
        return retVal;
    }

    public XON getCdm12_ContractOrganization(int rep) {
        XON retVal = (XON)this.getTypedField(12, rep);
        return retVal;
    }

    public int getCdm12_ContractOrganizationReps() {
        return this.getReps(12);
    }

    public XON insertContractOrganization(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(12, rep);
    }

    public XON insertCdm12_ContractOrganization(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(12, rep);
    }

    public XON removeContractOrganization(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(12, rep);
    }

    public XON removeCdm12_ContractOrganization(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(12, rep);
    }

    public ID getRoomFeeIndicator() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getCdm13_RoomFeeIndicator() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CNE(this.getMessage());
            }
            case 7: {
                return new ID(this.getMessage(), new Integer(183));
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new CX(this.getMessage());
            }
            case 11: {
                return new XON(this.getMessage());
            }
            case 12: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

