/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.pdfviewer;

import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.plugins.AttachmentViewer;
import com.mirth.connect.plugins.pdfviewer.MirthPDFViewer;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class PDFViewer
extends AttachmentViewer {
    public PDFViewer(String name) {
        super(name);
    }

    public boolean handleMultiple() {
        return false;
    }

    public void viewAttachments(String channelId, Long messageId, String attachmentId) {
        try {
            Attachment attachment = this.parent.mirthClient.getAttachment(channelId, messageId, attachmentId);
            byte[] rawData = attachment.getContent();
            Base64InputStream in = new Base64InputStream((InputStream)new ByteArrayInputStream(rawData));
            File temp = File.createTempFile(attachment.getId(), ".pdf");
            temp.deleteOnExit();
            FileOutputStream out = new FileOutputStream(temp);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            ((OutputStream)out).close();
            new MirthPDFViewer(true, temp);
        }
        catch (Exception e) {
            this.parent.alertThrowable((Component)this.parent, (Throwable)e);
        }
    }

    public boolean isContentTypeViewable(String contentType) {
        return StringUtils.containsIgnoreCase((CharSequence)contentType, (CharSequence)"pdf");
    }

    public void start() {
    }

    public void stop() {
    }

    public void reset() {
    }

    public String getPluginPointName() {
        return "PDF Viewer";
    }
}

