/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import net.lingala.zip4j.core.HeaderReader;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.UnzipParameters;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.unzip.Unzip;
import net.lingala.zip4j.util.ArchiveMaintainer;
import net.lingala.zip4j.util.InternalZipConstants;
import net.lingala.zip4j.util.Zip4jUtil;
import net.lingala.zip4j.zip.ZipEngine;

public class ZipFile {
    private String file;
    private int mode;
    private ZipModel zipModel;
    private boolean isEncrypted;
    private ProgressMonitor progressMonitor;
    private boolean runInThread;
    private String fileNameCharset;

    public ZipFile(String string) throws ZipException {
        this(new File(string));
    }

    public ZipFile(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("Input zip file parameter is not null", 1);
        }
        this.file = file.getPath();
        this.mode = 2;
        this.progressMonitor = new ProgressMonitor();
        this.runInThread = false;
    }

    public void createZipFile(File file, ZipParameters zipParameters) throws ZipException {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(file);
        this.createZipFile(arrayList, zipParameters, false, -1L);
    }

    public void createZipFile(File file, ZipParameters zipParameters, boolean bl, long l) throws ZipException {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(file);
        this.createZipFile(arrayList, zipParameters, bl, l);
    }

    public void createZipFile(ArrayList arrayList, ZipParameters zipParameters) throws ZipException {
        this.createZipFile(arrayList, zipParameters, false, -1L);
    }

    public void createZipFile(ArrayList arrayList, ZipParameters zipParameters, boolean bl, long l) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(this.file)) {
            throw new ZipException("zip file path is empty");
        }
        if (Zip4jUtil.checkFileExists(this.file)) {
            throw new ZipException("zip file: " + this.file + " already exists. To add files to existing zip file use addFile method");
        }
        if (arrayList == null) {
            throw new ZipException("input file ArrayList is null, cannot create zip file");
        }
        if (!Zip4jUtil.checkArrayListTypes(arrayList, 1)) {
            throw new ZipException("One or more elements in the input ArrayList is not of type File");
        }
        this.createNewZipModel();
        this.zipModel.setSplitArchive(bl);
        this.zipModel.setSplitLength(l);
        this.addFiles(arrayList, zipParameters);
    }

    public void createZipFileFromFolder(String string, ZipParameters zipParameters, boolean bl, long l) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("folderToAdd is empty or null, cannot create Zip File from folder");
        }
        this.createZipFileFromFolder(new File(string), zipParameters, bl, l);
    }

    public void createZipFileFromFolder(File file, ZipParameters zipParameters, boolean bl, long l) throws ZipException {
        if (file == null) {
            throw new ZipException("folderToAdd is null, cannot create zip file from folder");
        }
        if (zipParameters == null) {
            throw new ZipException("input parameters are null, cannot create zip file from folder");
        }
        if (Zip4jUtil.checkFileExists(this.file)) {
            throw new ZipException("zip file: " + this.file + " already exists. To add files to existing zip file use addFolder method");
        }
        this.createNewZipModel();
        this.zipModel.setSplitArchive(bl);
        if (bl) {
            this.zipModel.setSplitLength(l);
        }
        this.addFolder(file, zipParameters, false);
    }

    public void addFile(File file, ZipParameters zipParameters) throws ZipException {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(file);
        this.addFiles(arrayList, zipParameters);
    }

    public void addFiles(ArrayList arrayList, ZipParameters zipParameters) throws ZipException {
        this.checkZipModel();
        if (this.zipModel == null) {
            throw new ZipException("internal error: zip model is null");
        }
        if (arrayList == null) {
            throw new ZipException("input file ArrayList is null, cannot add files");
        }
        if (!Zip4jUtil.checkArrayListTypes(arrayList, 1)) {
            throw new ZipException("One or more elements in the input ArrayList is not of type File");
        }
        if (zipParameters == null) {
            throw new ZipException("input parameters are null, cannot add files to zip");
        }
        if (this.progressMonitor.getState() == 1) {
            throw new ZipException("invalid operation - Zip4j is in busy state");
        }
        if (Zip4jUtil.checkFileExists(this.file) && this.zipModel.isSplitArchive()) {
            throw new ZipException("Zip file already exists. Zip file format does not allow updating split/spanned files");
        }
        ZipEngine zipEngine = new ZipEngine(this.zipModel);
        zipEngine.addFiles(arrayList, zipParameters, this.progressMonitor, this.runInThread);
    }

    public void addFolder(String string, ZipParameters zipParameters) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("input path is null or empty, cannot add folder to zip file");
        }
        this.addFolder(new File(string), zipParameters);
    }

    public void addFolder(File file, ZipParameters zipParameters) throws ZipException {
        if (file == null) {
            throw new ZipException("input path is null, cannot add folder to zip file");
        }
        if (zipParameters == null) {
            throw new ZipException("input parameters are null, cannot add folder to zip file");
        }
        this.addFolder(file, zipParameters, true);
    }

    private void addFolder(File file, ZipParameters zipParameters, boolean bl) throws ZipException {
        this.checkZipModel();
        if (this.zipModel == null) {
            throw new ZipException("internal error: zip model is null");
        }
        if (bl && this.zipModel.isSplitArchive()) {
            throw new ZipException("This is a split archive. Zip file format does not allow updating split/spanned files");
        }
        ZipEngine zipEngine = new ZipEngine(this.zipModel);
        zipEngine.addFolderToZip(file, zipParameters, this.progressMonitor, this.runInThread);
    }

    public void addStream(InputStream inputStream, ZipParameters zipParameters) throws ZipException {
        if (inputStream == null) {
            throw new ZipException("inputstream is null, cannot add file to zip");
        }
        if (zipParameters == null) {
            throw new ZipException("zip parameters are null");
        }
        this.setRunInThread(false);
        this.checkZipModel();
        if (this.zipModel == null) {
            throw new ZipException("internal error: zip model is null");
        }
        if (Zip4jUtil.checkFileExists(this.file) && this.zipModel.isSplitArchive()) {
            throw new ZipException("Zip file already exists. Zip file format does not allow updating split/spanned files");
        }
        ZipEngine zipEngine = new ZipEngine(this.zipModel);
        zipEngine.addStreamToZip(inputStream, zipParameters);
    }

    private void readZipInfo() throws ZipException {
        if (!Zip4jUtil.checkFileExists(this.file)) {
            throw new ZipException("zip file does not exist");
        }
        if (!Zip4jUtil.checkFileReadAccess(this.file)) {
            throw new ZipException("no read access for the input zip file");
        }
        if (this.mode != 2) {
            throw new ZipException("Invalid mode");
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(new File(this.file), "r");
            if (this.zipModel == null) {
                HeaderReader headerReader = new HeaderReader(randomAccessFile);
                this.zipModel = headerReader.readAllHeaders(this.fileNameCharset);
                if (this.zipModel != null) {
                    this.zipModel.setZipFile(this.file);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ZipException(fileNotFoundException);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void extractAll(String string) throws ZipException {
        this.extractAll(string, null);
    }

    public void extractAll(String string, UnzipParameters unzipParameters) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("output path is null or invalid");
        }
        if (!Zip4jUtil.checkOutputFolder(string)) {
            throw new ZipException("invalid output path");
        }
        if (this.zipModel == null) {
            this.readZipInfo();
        }
        if (this.zipModel == null) {
            throw new ZipException("Internal error occurred when extracting zip file");
        }
        if (this.progressMonitor.getState() == 1) {
            throw new ZipException("invalid operation - Zip4j is in busy state");
        }
        Unzip unzip = new Unzip(this.zipModel);
        unzip.extractAll(unzipParameters, string, this.progressMonitor, this.runInThread);
    }

    public void extractFile(FileHeader fileHeader, String string) throws ZipException {
        this.extractFile(fileHeader, string, null);
    }

    public void extractFile(FileHeader fileHeader, String string, UnzipParameters unzipParameters) throws ZipException {
        this.extractFile(fileHeader, string, unzipParameters, null);
    }

    public void extractFile(FileHeader fileHeader, String string, UnzipParameters unzipParameters, String string2) throws ZipException {
        if (fileHeader == null) {
            throw new ZipException("input file header is null, cannot extract file");
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("destination path is empty or null, cannot extract file");
        }
        this.readZipInfo();
        if (this.progressMonitor.getState() == 1) {
            throw new ZipException("invalid operation - Zip4j is in busy state");
        }
        fileHeader.extractFile(this.zipModel, string, unzipParameters, string2, this.progressMonitor, this.runInThread);
    }

    public void extractFile(String string, String string2) throws ZipException {
        this.extractFile(string, string2, null);
    }

    public void extractFile(String string, String string2, UnzipParameters unzipParameters) throws ZipException {
        this.extractFile(string, string2, unzipParameters, null);
    }

    public void extractFile(String string, String string2, UnzipParameters unzipParameters, String string3) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("file to extract is null or empty, cannot extract file");
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            throw new ZipException("destination string path is empty or null, cannot extract file");
        }
        this.readZipInfo();
        FileHeader fileHeader = Zip4jUtil.getFileHeader(this.zipModel, string);
        if (fileHeader == null) {
            throw new ZipException("file header not found for given file name, cannot extract file");
        }
        if (this.progressMonitor.getState() == 1) {
            throw new ZipException("invalid operation - Zip4j is in busy state");
        }
        fileHeader.extractFile(this.zipModel, string2, unzipParameters, string3, this.progressMonitor, this.runInThread);
    }

    public void setPassword(String string) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new NullPointerException();
        }
        this.setPassword(string.toCharArray());
    }

    public void setPassword(char[] cArray) throws ZipException {
        if (this.zipModel == null) {
            this.readZipInfo();
            if (this.zipModel == null) {
                throw new ZipException("Zip Model is null");
            }
        }
        if (this.zipModel.getCentralDirectory() == null || this.zipModel.getCentralDirectory().getFileHeaders() == null) {
            throw new ZipException("invalid zip file");
        }
        for (int i = 0; i < this.zipModel.getCentralDirectory().getFileHeaders().size(); ++i) {
            if (this.zipModel.getCentralDirectory().getFileHeaders().get(i) == null || !((FileHeader)this.zipModel.getCentralDirectory().getFileHeaders().get(i)).isEncrypted()) continue;
            ((FileHeader)this.zipModel.getCentralDirectory().getFileHeaders().get(i)).setPassword(cArray);
        }
    }

    public List getFileHeaders() throws ZipException {
        this.readZipInfo();
        if (this.zipModel == null || this.zipModel.getCentralDirectory() == null) {
            return null;
        }
        return this.zipModel.getCentralDirectory().getFileHeaders();
    }

    public FileHeader getFileHeader(String string) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("input file name is emtpy or null, cannot get FileHeader");
        }
        this.readZipInfo();
        if (this.zipModel == null || this.zipModel.getCentralDirectory() == null) {
            return null;
        }
        return Zip4jUtil.getFileHeader(this.zipModel, string);
    }

    public boolean isEncrypted() throws ZipException {
        if (this.zipModel == null) {
            this.readZipInfo();
            if (this.zipModel == null) {
                throw new ZipException("Zip Model is null");
            }
        }
        if (this.zipModel.getCentralDirectory() == null || this.zipModel.getCentralDirectory().getFileHeaders() == null) {
            throw new ZipException("invalid zip file");
        }
        ArrayList arrayList = this.zipModel.getCentralDirectory().getFileHeaders();
        for (int i = 0; i < arrayList.size(); ++i) {
            FileHeader fileHeader = (FileHeader)arrayList.get(i);
            if (fileHeader == null || !fileHeader.isEncrypted()) continue;
            this.isEncrypted = true;
            break;
        }
        return this.isEncrypted;
    }

    public boolean isSplitArchive() throws ZipException {
        if (this.zipModel == null) {
            this.readZipInfo();
            if (this.zipModel == null) {
                throw new ZipException("Zip Model is null");
            }
        }
        return this.zipModel.isSplitArchive();
    }

    public void removeFile(String string) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("file name is empty or null, cannot remove file");
        }
        if (this.zipModel == null && Zip4jUtil.checkFileExists(this.file)) {
            this.readZipInfo();
        }
        if (this.zipModel.isSplitArchive()) {
            throw new ZipException("Zip file format does not allow updating split/spanned files");
        }
        FileHeader fileHeader = Zip4jUtil.getFileHeader(this.zipModel, string);
        if (fileHeader == null) {
            throw new ZipException("could not find file header for file: " + string);
        }
        this.removeFile(fileHeader);
    }

    public void removeFile(FileHeader fileHeader) throws ZipException {
        if (fileHeader == null) {
            throw new ZipException("file header is null, cannot remove file");
        }
        if (this.zipModel == null && Zip4jUtil.checkFileExists(this.file)) {
            this.readZipInfo();
        }
        if (this.zipModel.isSplitArchive()) {
            throw new ZipException("Zip file format does not allow updating split/spanned files");
        }
        ArchiveMaintainer archiveMaintainer = new ArchiveMaintainer();
        archiveMaintainer.initProgressMonitorForRemoveOp(this.zipModel, fileHeader, this.progressMonitor);
        archiveMaintainer.removeZipFile(this.zipModel, fileHeader, this.progressMonitor, this.runInThread);
    }

    public void mergeSplitFiles(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("outputZipFile is null, cannot merge split files");
        }
        if (file.exists()) {
            throw new ZipException("output Zip File already exists");
        }
        this.checkZipModel();
        if (this.zipModel == null) {
            throw new ZipException("zip model is null, corrupt zip file?");
        }
        ArchiveMaintainer archiveMaintainer = new ArchiveMaintainer();
        archiveMaintainer.initProgressMonitorForMergeOp(this.zipModel, this.progressMonitor);
        archiveMaintainer.mergeSplitZipFiles(this.zipModel, file, this.progressMonitor, this.runInThread);
    }

    public void setComment(String string) throws ZipException {
        if (string == null) {
            throw new ZipException("input comment is null, cannot update zip file");
        }
        if (!Zip4jUtil.checkFileExists(this.file)) {
            throw new ZipException("zip file does not exist, cannot set comment for zip file");
        }
        this.readZipInfo();
        if (this.zipModel == null) {
            throw new ZipException("zipModel is null, cannot update zip file");
        }
        if (this.zipModel.getEndCentralDirRecord() == null) {
            throw new ZipException("end of central directory is null, cannot set comment");
        }
        ArchiveMaintainer archiveMaintainer = new ArchiveMaintainer();
        archiveMaintainer.setComment(this.zipModel, string);
    }

    public String getComment() throws ZipException {
        return this.getComment(null);
    }

    public String getComment(String string) throws ZipException {
        if (string == null) {
            string = Zip4jUtil.isSupportedCharset("windows-1254") ? "windows-1254" : InternalZipConstants.CHARSET_DEFAULT;
        }
        if (!Zip4jUtil.checkFileExists(this.file)) {
            throw new ZipException("zip file does not exist, cannot read comment");
        }
        this.checkZipModel();
        if (this.zipModel == null) {
            throw new ZipException("zip model is null, cannot read comment");
        }
        if (this.zipModel.getEndCentralDirRecord() == null) {
            throw new ZipException("end of central directory record is null, cannot read comment");
        }
        if (this.zipModel.getEndCentralDirRecord().getCommentBytes() == null || this.zipModel.getEndCentralDirRecord().getCommentBytes().length <= 0) {
            return null;
        }
        try {
            return new String(this.zipModel.getEndCentralDirRecord().getCommentBytes(), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ZipException(unsupportedEncodingException);
        }
    }

    private void checkZipModel() throws ZipException {
        if (this.zipModel == null) {
            if (Zip4jUtil.checkFileExists(this.file)) {
                this.readZipInfo();
            } else {
                this.createNewZipModel();
            }
        }
    }

    private void createNewZipModel() {
        this.zipModel = new ZipModel();
        this.zipModel.setZipFile(this.file);
        this.zipModel.setFileNameCharset(this.fileNameCharset);
    }

    public void setFileNameCharset(String string) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("null or empty charset name");
        }
        if (!Zip4jUtil.isSupportedCharset(string)) {
            throw new ZipException("unsupported charset: " + string);
        }
        this.fileNameCharset = string;
    }

    public ZipInputStream getInputStream(FileHeader fileHeader) throws ZipException {
        if (fileHeader == null) {
            throw new ZipException("FileHeader is null, cannot get InputStream");
        }
        this.checkZipModel();
        if (this.zipModel == null) {
            throw new ZipException("zip model is null, cannot get inputstream");
        }
        Unzip unzip = new Unzip(this.zipModel);
        return unzip.getInputStream(fileHeader);
    }

    public boolean isValidZipFile() {
        try {
            this.readZipInfo();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ArrayList getSplitZipFiles() throws ZipException {
        this.checkZipModel();
        return Zip4jUtil.getSplitZipFiles(this.zipModel);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public boolean isRunInThread() {
        return this.runInThread;
    }

    public void setRunInThread(boolean bl) {
        this.runInThread = bl;
    }

    public File getFile() {
        return new File(this.file);
    }
}

