/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.DataInput;
import java.io.IOException;
import net.lingala.zip4j.exception.ZipException;

public class Raw {
    public static long readLongLittleEndian(byte[] byArray, int n) {
        long l = 0L;
        l |= (long)(byArray[n + 7] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 6] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 5] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 4] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 3] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 2] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 1] & 0xFF);
        l <<= 8;
        return l |= (long)(byArray[n] & 0xFF);
    }

    public static int readLeInt(DataInput dataInput, byte[] byArray) throws ZipException {
        try {
            dataInput.readFully(byArray, 0, 4);
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8) << 16;
    }

    public static int readShortLittleEndian(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    public static final short readShortBigEndian(byte[] byArray, int n) {
        short s = 0;
        s = (short)(s | byArray[n] & 0xFF);
        s = (short)(s << 8);
        s = (short)(s | byArray[n + 1] & 0xFF);
        return s;
    }

    public static int readIntLittleEndian(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF | (byArray[n + 3] & 0xFF) << 8) << 16;
    }

    public static byte[] toByteArray(int n, int n2) {
        byte[] byArray = new byte[n2];
        byte[] byArray2 = Raw.toByteArray(n);
        for (int i = 0; i < byArray2.length && i < n2; ++i) {
            byArray[i] = byArray2[i];
        }
        return byArray;
    }

    public static byte[] toByteArray(int n) {
        byte[] byArray = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
        return byArray;
    }

    public static final void writeShortLittleEndian(byte[] byArray, int n, short s) {
        byArray[n + 1] = (byte)(s >>> 8);
        byArray[n] = (byte)(s & 0xFF);
    }

    public static final void writeIntLittleEndian(byte[] byArray, int n, int n2) {
        byArray[n + 3] = (byte)(n2 >>> 24);
        byArray[n + 2] = (byte)(n2 >>> 16);
        byArray[n + 1] = (byte)(n2 >>> 8);
        byArray[n] = (byte)(n2 & 0xFF);
    }

    public static void writeLongLittleEndian(byte[] byArray, int n, long l) {
        byArray[n + 7] = (byte)(l >>> 56);
        byArray[n + 6] = (byte)(l >>> 48);
        byArray[n + 5] = (byte)(l >>> 40);
        byArray[n + 4] = (byte)(l >>> 32);
        byArray[n + 3] = (byte)(l >>> 24);
        byArray[n + 2] = (byte)(l >>> 16);
        byArray[n + 1] = (byte)(l >>> 8);
        byArray[n] = (byte)(l & 0xFFL);
    }

    public static byte bitArrayToByte(int[] nArray) throws ZipException {
        if (nArray == null) {
            throw new ZipException("bit array is null, cannot calculate byte from bits");
        }
        if (nArray.length != 8) {
            throw new ZipException("invalid bit array length, cannot calculate byte");
        }
        if (!Raw.checkBits(nArray)) {
            throw new ZipException("invalid bits provided, bits contain other values than 0 or 1");
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n = (int)((double)n + Math.pow(2.0, i) * (double)nArray[i]);
        }
        return (byte)n;
    }

    private static boolean checkBits(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0 || nArray[i] == 1) continue;
            return false;
        }
        return true;
    }

    public static void prepareBuffAESIVBytes(byte[] byArray, int n, int n2) {
        byArray[0] = (byte)n;
        byArray[1] = (byte)(n >> 8);
        byArray[2] = (byte)(n >> 16);
        byArray[3] = (byte)(n >> 24);
        byArray[4] = 0;
        byArray[5] = 0;
        byArray[6] = 0;
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        byArray[11] = 0;
        byArray[12] = 0;
        byArray[13] = 0;
        byArray[14] = 0;
        byArray[15] = 0;
    }

    public static byte[] convertCharArrayToByteArray(char[] cArray) {
        if (cArray == null) {
            throw new NullPointerException();
        }
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }
}

