/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.audit;

import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.util.JsonUtils;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import java.util.LinkedHashMap;
import java.util.Map;

public class LookupAuditLogger {
    private final ConfigurationController configurationController;
    private final EventController eventController;
    private static final LookupAuditLogger INSTANCE = new LookupAuditLogger(ControllerFactory.getFactory().createConfigurationController(), ControllerFactory.getFactory().createEventController());

    public static LookupAuditLogger getInstance() {
        return INSTANCE;
    }

    private LookupAuditLogger(ConfigurationController configurationController, EventController eventController) {
        this.configurationController = configurationController;
        this.eventController = eventController;
    }

    private void logServerEvent(String string, Map<String, String> map) {
        ServerEvent serverEvent = new ServerEvent(this.configurationController.getServerId(), string, ServerEvent.Level.INFORMATION, ServerEvent.Outcome.SUCCESS, map);
        this.eventController.dispatchEvent((Event)serverEvent);
    }

    public void logHelperGroupDeleted(String string, Integer n) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("source", "LookupHelper");
        if (string != null) {
            linkedHashMap.put("groupName", string);
        }
        if (n != null) {
            linkedHashMap.put("groupId", String.valueOf(n));
        }
        this.logServerEvent("Delete group invoked through Lookup Table Management System", linkedHashMap);
    }

    public void logHelperGroupCreated(LookupGroup lookupGroup) {
        String string;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("source", "LookupHelper");
        try {
            string = JsonUtils.toJson((Object)lookupGroup);
        }
        catch (Exception exception) {
            string = "{ \"error\": \"Failed to serialize LookupGroup to JSON\" }";
        }
        linkedHashMap.put("requestBody", string);
        this.logServerEvent("Create new group invoked through Lookup Table Management System", linkedHashMap);
    }
}

