/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.migration;

import com.mirth.connect.plugins.dynamiclookup.server.migration.SqlScriptRunner;
import com.mirth.connect.plugins.dynamiclookup.server.util.LookupDbUtil;
import com.mirth.connect.plugins.dynamiclookup.shared.capability.DatabaseInfo;
import com.mirth.connect.plugins.dynamiclookup.shared.capability.LookupJsonCapability;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import org.apache.commons.dbutils.DbUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupSchemaMigrator {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final SqlSessionManager sqlSessionManager;

    public LookupSchemaMigrator(SqlSessionManager sqlSessionManager) {
        this.sqlSessionManager = sqlSessionManager;
    }

    public void migrate() {
        String string;
        Object object;
        String string2;
        if (this.needUpdateV101()) {
            string2 = "/sql/sqlserver/fixes/V101_convert_varchar_to_nvarchar.sql";
            object = SqlScriptRunner.loadScript(string2);
            SqlScriptRunner.runWithGo(this.sqlSessionManager, (String)object);
        }
        string2 = LookupSchemaMigrator.dbFolder(LookupJsonCapability.getInstance().getDatabaseInfo().getType());
        if (this.needUpdateV210_AddGroupValueType()) {
            object = "/sql/" + string2 + "/fixes/V210_add_value_type_to_group_table.sql";
            string = SqlScriptRunner.loadScript((String)object);
            SqlScriptRunner.runWithSemicolon(this.sqlSessionManager, string);
        }
        if (this.needUpdateV210_AddGroupStatisticsEnabled()) {
            object = "/sql/" + string2 + "/fixes/V210_add_statistics_enabled_to_group_table.sql";
            string = SqlScriptRunner.loadScript((String)object);
            SqlScriptRunner.runWithSemicolon(this.sqlSessionManager, string);
        }
        if (this.needUpdateV210_AddGroupExtra()) {
            object = "/sql/" + string2 + "/fixes/V210_add_group_extra_table.sql";
            string = SqlScriptRunner.loadScript((String)object);
            SqlScriptRunner.runWithSemicolon(this.sqlSessionManager, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean needUpdateV101() {
        ResultSet resultSet;
        SqlSession sqlSession;
        block19: {
            DatabaseInfo.DatabaseType databaseType = LookupJsonCapability.getInstance().getDatabaseInfo().getType();
            if (databaseType != DatabaseInfo.DatabaseType.SQLSERVER) {
                return false;
            }
            sqlSession = this.sqlSessionManager.openSession();
            resultSet = null;
            DatabaseMetaData databaseMetaData = sqlSession.getConnection().getMetaData();
            resultSet = databaseMetaData.getColumns(null, null, "LOOKUP_GROUP", "NAME");
            if (resultSet.next()) break block19;
            DbUtils.closeQuietly((ResultSet)resultSet);
            resultSet = databaseMetaData.getColumns(null, null, "lookup_group", "name");
            if (resultSet.next()) break block19;
            boolean bl = false;
            DbUtils.closeQuietly((ResultSet)resultSet);
            try {
                sqlSession.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl;
        }
        String string = resultSet.getString("TYPE_NAME");
        boolean bl = string == null || !"NVARCHAR".equalsIgnoreCase(string);
        DbUtils.closeQuietly((ResultSet)resultSet);
        try {
            sqlSession.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
        {
            catch (Exception exception) {
                boolean bl2;
                try {
                    this.logger.warn("needUpdateV101() check failed: {}", (Object)exception.getMessage());
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    try {
                        DbUtils.closeQuietly(resultSet);
                        try {
                            sqlSession.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    catch (Exception exception3) {
                        return false;
                    }
                }
                DbUtils.closeQuietly((ResultSet)resultSet);
                try {
                    sqlSession.close();
                }
                catch (Exception exception4) {
                    // empty catch block
                }
                return bl2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needUpdateV210_AddGroupValueType() {
        SqlSession sqlSession = null;
        try {
            sqlSession = this.sqlSessionManager.openSession();
            boolean bl = !LookupDbUtil.columnExists(sqlSession.getConnection(), "LOOKUP_GROUP", "VALUE_TYPE");
            return bl;
        }
        catch (Exception exception) {
            this.logger.warn("needUpdateV210_AddGroupValueType() check failed: {}", (Object)exception.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (sqlSession != null) {
                    sqlSession.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needUpdateV210_AddGroupStatisticsEnabled() {
        SqlSession sqlSession = null;
        try {
            sqlSession = this.sqlSessionManager.openSession();
            boolean bl = !LookupDbUtil.columnExists(sqlSession.getConnection(), "LOOKUP_GROUP", "STATISTICS_ENABLED");
            return bl;
        }
        catch (Exception exception) {
            this.logger.warn("needUpdateV210_AddGroupStatisticsEnabled() check failed: {}", (Object)exception.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (sqlSession != null) {
                    sqlSession.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needUpdateV210_AddGroupExtra() {
        boolean bl;
        SqlSession sqlSession = null;
        try {
            if (!LookupJsonCapability.getInstance().isJsonSupported()) {
                boolean bl2 = false;
                return bl2;
            }
            sqlSession = this.sqlSessionManager.openSession();
            bl = !LookupDbUtil.tableExists(sqlSession.getConnection(), "LOOKUP_GROUP_EXTRA");
        }
        catch (Exception exception) {
            this.logger.warn("needUpdateV210_AddGroupExtra() check failed: {}", (Object)exception.getMessage());
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (sqlSession != null) {
                    sqlSession.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    private static String dbFolder(DatabaseInfo.DatabaseType databaseType) {
        switch (databaseType) {
            case POSTGRESQL: {
                return "postgres";
            }
            case MYSQL: {
                return "mysql";
            }
            case SQLSERVER: {
                return "sqlserver";
            }
            case ORACLE: {
                return "oracle";
            }
            case DERBY: {
                return "derby";
            }
        }
        return "derby";
    }
}

