/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.service.support;

import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonFieldDialect;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.MysqlJsonFieldDialect;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.NoJsonFieldDialect;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.OracleJsonFieldDialect;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.PostgresJsonFieldDialect;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.SqlServerJsonFieldDialect;
import com.mirth.connect.plugins.dynamiclookup.shared.capability.DatabaseInfo;
import com.mirth.connect.plugins.dynamiclookup.shared.capability.LookupJsonCapability;
import java.util.Objects;

public class JsonFieldDialectRegistry {
    private static volatile JsonFieldDialect dialectInstance;

    private JsonFieldDialectRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonFieldDialect getDialect() {
        JsonFieldDialect jsonFieldDialect = dialectInstance;
        if (jsonFieldDialect != null) return jsonFieldDialect;
        Class<JsonFieldDialectRegistry> clazz = JsonFieldDialectRegistry.class;
        synchronized (JsonFieldDialectRegistry.class) {
            jsonFieldDialect = dialectInstance;
            if (jsonFieldDialect != null) return jsonFieldDialect;
            dialectInstance = jsonFieldDialect = JsonFieldDialectRegistry.createDialectFromCapability();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return jsonFieldDialect;
        }
    }

    private static JsonFieldDialect createDialectFromCapability() {
        LookupJsonCapability lookupJsonCapability = LookupJsonCapability.getInstance();
        Objects.requireNonNull(lookupJsonCapability, "LookupJsonCapability must be initialized before using JsonFieldDialectRegistry.");
        DatabaseInfo.DatabaseType databaseType = lookupJsonCapability.getDatabaseInfo().getType();
        switch (databaseType) {
            case POSTGRESQL: {
                return new PostgresJsonFieldDialect();
            }
            case MYSQL: {
                return new MysqlJsonFieldDialect();
            }
            case SQLSERVER: {
                return new SqlServerJsonFieldDialect();
            }
            case ORACLE: {
                return new OracleJsonFieldDialect();
            }
        }
        return new NoJsonFieldDialect();
    }
}

