/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.service.support;

import com.mirth.connect.plugins.dynamiclookup.server.dao.LookupValueDao;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonFieldDialect;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonFieldDialectRegistry;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonFieldIndexDefinition;
import com.mirth.connect.plugins.dynamiclookup.server.util.LookupTableNaming;
import com.mirth.connect.plugins.dynamiclookup.shared.constant.LookupConstants;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroupExtra;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonIndexConfigurator {
    private final LookupValueDao valueDao;

    public JsonIndexConfigurator(LookupValueDao lookupValueDao) {
        this.valueDao = lookupValueDao;
    }

    public void applyInitialIndexConfig(LookupGroup lookupGroup) {
        this.apply(null, lookupGroup);
    }

    public void apply(LookupGroup lookupGroup, LookupGroup lookupGroup2) {
        if (lookupGroup2 == null) {
            return;
        }
        String string = LookupTableNaming.valueTableName(lookupGroup2);
        LookupGroupExtra lookupGroupExtra = lookupGroup != null ? lookupGroup.getExtra() : null;
        LookupGroupExtra lookupGroupExtra2 = lookupGroup2 != null ? lookupGroup2.getExtra() : null;
        String string2 = lookupGroupExtra != null ? LookupConstants.normalizeJsonIndexMode((String)lookupGroupExtra.getJsonIndexMode()) : "NONE";
        String string3 = lookupGroupExtra2 != null ? LookupConstants.normalizeJsonIndexMode((String)lookupGroupExtra2.getJsonIndexMode()) : "NONE";
        JsonFieldDialect jsonFieldDialect = JsonFieldDialectRegistry.getDialect();
        List<JsonFieldIndexDefinition> list = jsonFieldDialect.buildIndexDefinitions(lookupGroup);
        List<JsonFieldIndexDefinition> list2 = jsonFieldDialect.buildIndexDefinitions(lookupGroup2);
        if (string2.equals(string3)) {
            Set set;
            Set set2;
            if (LookupConstants.isFieldMode((String)string2) && !(set2 = list.stream().map(JsonFieldIndexDefinition::getFieldPath).collect(Collectors.toSet())).equals(set = list2.stream().map(JsonFieldIndexDefinition::getFieldPath).collect(Collectors.toSet()))) {
                this.applyFieldDiff(string, list, list2);
            }
            return;
        }
        switch (string2) {
            case "NONE": {
                this.handleNoneTo(string3, string, list2);
                break;
            }
            case "FIELD": {
                this.handleFieldTo(string3, string, list);
            }
        }
    }

    private void handleNoneTo(String string, String string2, List<JsonFieldIndexDefinition> list) {
        if (LookupConstants.isFieldMode((String)string) && !list.isEmpty()) {
            this.valueDao.createJsonFieldIndexes(string2, list);
        }
    }

    private void handleFieldTo(String string, String string2, List<JsonFieldIndexDefinition> list) {
        if (!list.isEmpty()) {
            this.valueDao.dropJsonFieldIndexes(string2, list);
        }
    }

    private void applyFieldDiff(String string, List<JsonFieldIndexDefinition> list, List<JsonFieldIndexDefinition> list2) {
        Set set = list.stream().map(JsonFieldIndexDefinition::getFieldPath).collect(Collectors.toSet());
        Set set2 = list2.stream().map(JsonFieldIndexDefinition::getFieldPath).collect(Collectors.toSet());
        HashSet hashSet = new HashSet(set2);
        hashSet.removeAll(set);
        HashSet hashSet2 = new HashSet(set);
        hashSet2.removeAll(set2);
        List<JsonFieldIndexDefinition> list3 = list.stream().filter(jsonFieldIndexDefinition -> hashSet2.contains(jsonFieldIndexDefinition.getFieldPath())).collect(Collectors.toList());
        List<JsonFieldIndexDefinition> list4 = list2.stream().filter(jsonFieldIndexDefinition -> hashSet2.contains(jsonFieldIndexDefinition.getFieldPath())).collect(Collectors.toList());
        if (!list3.isEmpty()) {
            this.valueDao.dropJsonFieldIndexes(string, list3);
        }
        if (!list4.isEmpty()) {
            this.valueDao.createJsonFieldIndexes(string, list4);
        }
    }
}

