/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.service.support;

import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonFieldCriterion;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonFieldDialect;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonFieldIndexDefinition;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonIndexNaming;
import com.mirth.connect.plugins.dynamiclookup.server.util.JsonFieldUtils;
import com.mirth.connect.plugins.dynamiclookup.server.util.LookupTableNaming;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroupExtra;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonCondition;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonOperator;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonValueType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class OracleJsonFieldDialect
implements JsonFieldDialect {
    @Override
    public List<JsonFieldIndexDefinition> buildIndexDefinitions(LookupGroup lookupGroup) {
        if (lookupGroup == null) {
            return Collections.emptyList();
        }
        LookupGroupExtra lookupGroupExtra = lookupGroup.getExtra();
        if (lookupGroupExtra == null) {
            return Collections.emptyList();
        }
        Set<String> set = JsonFieldUtils.parseIndexedFieldPaths(lookupGroupExtra.getIndexedJsonFields());
        if (set.isEmpty()) {
            return Collections.emptyList();
        }
        String string = LookupTableNaming.valueTableName(lookupGroup);
        ArrayList<JsonFieldIndexDefinition> arrayList = new ArrayList<JsonFieldIndexDefinition>();
        for (String string2 : set) {
            String string3 = this.buildIndexExpression(string2);
            String string4 = JsonIndexNaming.buildIndexName(string, string2);
            JsonFieldIndexDefinition jsonFieldIndexDefinition = new JsonFieldIndexDefinition();
            jsonFieldIndexDefinition.setFieldPath(string2);
            jsonFieldIndexDefinition.setIndexName(string4);
            jsonFieldIndexDefinition.setExpression(string3);
            jsonFieldIndexDefinition.setTableName(string);
            arrayList.add(jsonFieldIndexDefinition);
        }
        return arrayList;
    }

    @Override
    public List<JsonFieldCriterion> buildCriteria(LookupGroup lookupGroup, List<JsonCondition> list) {
        if (lookupGroup == null || list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        LookupGroupExtra lookupGroupExtra = lookupGroup.getExtra();
        if (lookupGroupExtra == null) {
            throw new IllegalStateException("Group extra missing for group: " + lookupGroup.getId());
        }
        return this.buildFieldCriterion(lookupGroup, list);
    }

    public List<JsonFieldCriterion> buildFieldCriterion(LookupGroup lookupGroup, List<JsonCondition> list) {
        ArrayList<JsonFieldCriterion> arrayList = new ArrayList<JsonFieldCriterion>();
        for (JsonCondition jsonCondition : list) {
            if (jsonCondition == null) continue;
            String string = jsonCondition.getField();
            JsonValueType jsonValueType = jsonCondition.getValueType();
            String string2 = this.buildTypeCheckSql(string, jsonValueType);
            String string3 = this.buildCriterionExpression(string, jsonValueType);
            String string4 = this.buildSqlOperator(jsonCondition.getOp());
            JsonFieldCriterion jsonFieldCriterion = new JsonFieldCriterion();
            jsonFieldCriterion.setTypeCheckSql(string2);
            jsonFieldCriterion.setExpression(string3);
            jsonFieldCriterion.setOperatorSql(string4);
            jsonFieldCriterion.setValue(jsonCondition.getValue());
            jsonFieldCriterion.setValueSql(this.buildValueSql(jsonValueType));
            arrayList.add(jsonFieldCriterion);
        }
        return arrayList;
    }

    private String buildIndexExpression(String string) {
        String string2 = this.normalizeJsonPath(string);
        return "JSON_VALUE(VALUE_DATA, '" + string2 + "' RETURNING VARCHAR2(4000))";
    }

    private String buildTypeCheckSql(String string, JsonValueType jsonValueType) {
        String string2 = this.normalizeJsonPath(string);
        if (jsonValueType == null || jsonValueType == JsonValueType.STRING) {
            return "JSON_VALUE(VALUE_DATA, '" + string2 + "' RETURNING VARCHAR2(4000) NULL ON ERROR NULL ON EMPTY) IS NOT NULL";
        }
        if (jsonValueType == JsonValueType.NUMBER) {
            return "JSON_VALUE(VALUE_DATA, '" + string2 + "' RETURNING NUMBER NULL ON ERROR NULL ON EMPTY) IS NOT NULL";
        }
        if (jsonValueType == JsonValueType.BOOLEAN) {
            String string3 = "JSON_VALUE(VALUE_DATA, '" + string2 + "' RETURNING VARCHAR2(5) NULL ON ERROR NULL ON EMPTY)";
            return string3 + " IN ('true','false')";
        }
        return "JSON_VALUE(VALUE_DATA, '" + string2 + "' RETURNING VARCHAR2(4000) NULL ON ERROR NULL ON EMPTY) IS NOT NULL";
    }

    private String buildCriterionExpression(String string, JsonValueType jsonValueType) {
        String string2 = this.normalizeJsonPath(string);
        if (jsonValueType == null || jsonValueType == JsonValueType.STRING) {
            return "JSON_VALUE(VALUE_DATA, '" + string2 + "' RETURNING VARCHAR2(4000) NULL ON ERROR NULL ON EMPTY)";
        }
        if (jsonValueType == JsonValueType.NUMBER) {
            return "JSON_VALUE(VALUE_DATA, '" + string2 + "' RETURNING NUMBER NULL ON ERROR NULL ON EMPTY)";
        }
        if (jsonValueType == JsonValueType.BOOLEAN) {
            return "JSON_VALUE(VALUE_DATA, '" + string2 + "' RETURNING VARCHAR2(5) NULL ON ERROR NULL ON EMPTY)";
        }
        return "JSON_VALUE(VALUE_DATA, '" + string2 + "' RETURNING VARCHAR2(4000) NULL ON ERROR NULL ON EMPTY)";
    }

    private String buildValueSql(JsonValueType jsonValueType) {
        if (jsonValueType == null || jsonValueType == JsonValueType.STRING) {
            return "#{c.value}";
        }
        if (jsonValueType == JsonValueType.NUMBER) {
            return "TO_NUMBER(#{c.value})";
        }
        if (jsonValueType == JsonValueType.BOOLEAN) {
            return "LOWER(#{c.value})";
        }
        return "#{c.value}";
    }

    private String buildSqlOperator(JsonOperator jsonOperator) {
        if (jsonOperator == null) {
            return "=";
        }
        switch (jsonOperator) {
            case EQUAL: {
                return "=";
            }
            case NOT_EQUAL: {
                return "<>";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_OR_EQUAL: {
                return ">=";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_OR_EQUAL: {
                return "<=";
            }
        }
        throw new IllegalArgumentException("Unsupported JsonOperator for Oracle: " + String.valueOf(jsonOperator));
    }

    private String normalizeJsonPath(String string) {
        if (string == null) {
            return "$";
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return "$";
        }
        String[] stringArray = string2.split("\\.");
        StringBuilder stringBuilder = new StringBuilder("$");
        for (String string3 : stringArray) {
            if (string3 == null || string3.isEmpty()) continue;
            stringBuilder.append(".\"").append(string3.replace("\"", "\\\"")).append("\"");
        }
        return stringBuilder.toString();
    }
}

