/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.model.ConnectorMetaData;
import com.mirth.connect.model.MetaData;
import com.mirth.connect.model.PluginMetaData;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/extensions")
@Tag(name="Extensions")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface ExtensionServletInterface
extends BaseServletInterface {
    public static final String OPERATION_PLUGIN_PROPERTIES_GET = "getPluginProperties";
    public static final String OPERATION_PLUGIN_PROPERTIES_SET = "setPluginProperties";

    @POST
    @Path(value="/_install")
    @Consumes(value={"multipart/form-data"})
    @Operation(summary="Installs an extension.")
    @MirthOperation(name="installExtension", display="Install extension", permission="manageExtensions")
    public void installExtension(@Param(value="inputStream") @Parameter(description="The extension file to upload.", schema=@Schema(description="The extension file to upload.", type="string", format="binary")) @FormDataParam(value="file") InputStream var1) throws ClientException;

    @POST
    @Path(value="/_uninstall")
    @Operation(summary="Uninstalls an extension.")
    @MirthOperation(name="uninstallExtension", display="Uninstall extension", permission="manageExtensions")
    public void uninstallExtension(@Param(value="extensionPath") @RequestBody(description="The path attribute of the extension to uninstall.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="extensionPath", value="/path/to/extension")}), @Content(mediaType="application/json", examples={@ExampleObject(name="extensionPath", value="/path/to/extension")})}) String var1) throws ClientException;

    @GET
    @Path(value="/{extensionName}")
    @Operation(summary="Returns extension metadata by name.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="metadata", ref="../apiexamples/connector_metadata_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="metadata", ref="../apiexamples/connector_metadata_json")})})
    @MirthOperation(name="getMetaDataByName", display="Get extension metadata by name", auditable=false)
    public MetaData getExtensionMetaData(@Param(value="extensionName") @Parameter(description="The name of the extension to retrieve.", required=true) @PathParam(value="extensionName") String var1) throws ClientException;

    @GET
    @Path(value="/connectors")
    @Operation(summary="Returns all active connector metadata.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="connectorMetaDataMap", ref="../apiexamples/connector_metadata_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="connectorMetaDataMap", ref="../apiexamples/connector_metadata_map_json")})})
    @MirthOperation(name="getConnectorMetaData", display="Get connector metadata", auditable=false)
    public Map<String, ConnectorMetaData> getConnectorMetaData() throws ClientException;

    @GET
    @Path(value="/plugins")
    @Operation(summary="Returns all active plugin metadata.")
    @MirthOperation(name="getPluginMetaData", display="Get plugin metadata", auditable=false)
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="pluginMetaData", ref="../apiexamples/plugin_metadata_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="pluginMetaData", ref="../apiexamples/plugin_metadata_map_json")})})
    public Map<String, PluginMetaData> getPluginMetaData() throws ClientException;

    @GET
    @Path(value="/{extensionName}/enabled")
    @Operation(summary="Returns the enabled status of an extension.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="extensionEnabled", ref="../apiexamples/boolean_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="extensionEnabled", ref="../apiexamples/boolean_json")})})
    @MirthOperation(name="isExtensionEnabled", display="Check if extension is enabled", auditable=false)
    public boolean isExtensionEnabled(@Param(value="extensionName") @Parameter(description="The name of the extension to retrieve.", required=true) @PathParam(value="extensionName") String var1) throws ClientException;

    @POST
    @Path(value="/{extensionName}/_setEnabled")
    @Operation(summary="Enables or disables an extension.")
    @MirthOperation(name="setExtensionEnabled", display="Enable or disable an extension", permission="manageExtensions")
    public void setExtensionEnabled(@Param(value="extensionName") @Parameter(description="The name of the extension to retrieve.", required=true) @PathParam(value="extensionName") String var1, @Param(value="enabled") @Parameter(description="The new enabled status to set.", required=true) @QueryParam(value="enabled") boolean var2) throws ClientException;

    @GET
    @Path(value="/{extensionName}/properties")
    @Operation(summary="Returns filtered properties for a specified extension.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="propertiesObject", ref="../apiexamples/properties_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="propertiesObject", ref="../apiexamples/properties_json")})})
    @MirthOperation(name="getPluginProperties", display="Get filtered plugin properties", auditable=false)
    public Properties getPluginProperties(@Param(value="extensionName") @Parameter(description="The name of the extension to retrieve.", required=true) @PathParam(value="extensionName") String var1, @Param(value="propertyKeys") @Parameter(description="The set of properties to retrieve.", required=false) @QueryParam(value="propertyKeys") Set<String> var2) throws ClientException;

    @PUT
    @Path(value="/{extensionName}/properties")
    @Operation(summary="Sets properties for a specified extension.")
    @MirthOperation(name="setPluginProperties", display="Set plugin properties")
    public void setPluginProperties(@Param(value="extensionName") @RequestBody(description="The name of the extension to retrieve.", required=true) @PathParam(value="extensionName") String var1, @Param(value="properties") @RequestBody(description="description", content={@Content(mediaType="application/xml", schema=@Schema(implementation=Properties.class), examples={@ExampleObject(name="propertiesObject", ref="../apiexamples/properties_xml")}), @Content(mediaType="application/json", schema=@Schema(implementation=Properties.class), examples={@ExampleObject(name="propertiesObject", ref="../apiexamples/properties_json")})}) Properties var2, @Param(value="mergeProperties") @Parameter(description="Merge or replace properties. Defaults to replace.", required=false, schema=@Schema(defaultValue="false")) @QueryParam(value="mergeProperties") boolean var3) throws ClientException;
}

