/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.client.core.api.providers.MetaDataSearchParamConverterProvider;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.model.MessageImportResult;
import com.mirth.connect.model.filters.MessageFilter;
import com.mirth.connect.util.messagewriter.EncryptionType;
import com.mirth.connect.util.messagewriter.MessageWriterOptions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/channels")
@Tag(name="Messages")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface MessageServletInterface
extends BaseServletInterface {
    @POST
    @Path(value="/{channelId}/messages")
    @Consumes(value={"text/plain"})
    @Operation(summary="Processes a new message through a channel.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="long", ref="../apiexamples/long_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="long", ref="../apiexamples/long_json")})})
    @MirthOperation(name="processMessages", display="Process messages", permission="processMessages", type=Operation.ExecuteType.ASYNC)
    public Long processMessage(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="rawData") @Parameter(description="The raw message data to process.", required=true) String var2, @Param(value="destinationMetaDataIds") @Parameter(description="Indicates which destinations to send the message to.") @QueryParam(value="destinationMetaDataId") Set<Integer> var3, @Param(value="sourceMapEntries") @Parameter(description="These entries will be injected into the source map for the message. Value should be in the format: key=value") @QueryParam(value="sourceMapEntry") Set<String> var4, @Param(value="overwrite") @Parameter(description="If true and a valid original message ID is given, this message will overwrite the existing one.") @QueryParam(value="overwrite") boolean var5, @Param(value="imported") @Parameter(description="If true, marks this message as being imported. If the message is overwriting an existing one, then statistics will not be decremented.") @QueryParam(value="imported") boolean var6, @Param(value="originalMessageId") @Parameter(description="The original message ID this message is associated with.") @QueryParam(value="originalMessageId") Long var7) throws ClientException;

    @POST
    @Path(value="/{channelId}/messagesWithObj")
    @Operation(summary="Processes a new message through a channel, using the RawMessage object.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="long", ref="../apiexamples/long_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="long", ref="../apiexamples/long_json")})})
    @MirthOperation(name="processMessages", display="Process messages", permission="processMessages", type=Operation.ExecuteType.ASYNC)
    public Long processMessage(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="rawMessage") @RequestBody(description="The RawMessage object to process.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="rawMessage", ref="../apiexamples/raw_message_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="rawMessage", ref="../apiexamples/raw_message_json")})}) RawMessage var2) throws ClientException;

    @GET
    @Path(value="/{channelId}/messages/{messageId}")
    @Operation(summary="Retrieve a message by ID.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="message", ref="../apiexamples/message_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="message", ref="../apiexamples/message_json")})})
    @MirthOperation(name="getMessageContent", display="Get message content", permission="viewMessages", type=Operation.ExecuteType.ASYNC)
    public Message getMessageContent(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="messageId") @Parameter(description="The ID of the message.", required=true) @PathParam(value="messageId") Long var2, @Param(value="metaDataIds") @Parameter(description="The metadata IDs of the connectors.") @QueryParam(value="metaDataId") List<Integer> var3) throws ClientException;

    @GET
    @Path(value="/{channelId}/messages/{messageId}/attachments")
    @Operation(summary="Retrieve a list of attachments by message ID.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="attachmentList", ref="../apiexamples/attachment_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="attachmentList", ref="../apiexamples/attachment_list_json")})})
    @MirthOperation(name="getAttachmentsByMessageId", display="Get attachments by message ID", permission="viewMessages", type=Operation.ExecuteType.ASYNC, auditable=false)
    public List<Attachment> getAttachmentsByMessageId(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="messageId") @Parameter(description="The ID of the message.", required=true) @PathParam(value="messageId") Long var2, @Param(value="includeContent") @Parameter(description="If false, only the attachment ID and type will be returned.", schema=@Schema(defaultValue="true")) @QueryParam(value="includeContent") boolean var3) throws ClientException;

    @GET
    @Path(value="/{channelId}/messages/{messageId}/attachments/{attachmentId}")
    @Operation(summary="Retrieve a message attachment by ID.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="attachment", ref="../apiexamples/attachment_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="attachment", ref="../apiexamples/attachment_json")})})
    @MirthOperation(name="getAttachment", display="Get attachment", permission="viewMessages", type=Operation.ExecuteType.ASYNC)
    public Attachment getAttachment(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="messageId") @Parameter(description="The ID of the message.", required=true) @PathParam(value="messageId") Long var2, @Param(value="attachmentId") @Parameter(description="The ID of the attachment.", required=true) @PathParam(value="attachmentId") String var3) throws ClientException;

    @POST
    @Path(value="/{channelId}/messages/{messageId}/_getDICOMMessage")
    @Produces(value={"text/plain"})
    @Operation(summary="Given a ConnectorMessage object, reattaches any DICOM attachment data and returns the raw Base64 encoded message data.")
    @MirthOperation(name="getDICOMMessage", display="Get DICOM message", permission="viewMessages", type=Operation.ExecuteType.ASYNC, auditable=false)
    public String getDICOMMessage(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="messageId") @Parameter(description="The ID of the message.", required=true) @PathParam(value="messageId") Long var2, @Param(value="message") @RequestBody(description="The ConnectorMessage to retrieve DICOM data for.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="connectorMessage", ref="../apiexamples/connector_message_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="connectorMessage", ref="../apiexamples/connector_message_json")})}) ConnectorMessage var3) throws ClientException;

    @GET
    @Path(value="/{channelId}/messages/maxMessageId")
    @Operation(summary="Returns the maximum message ID for the given channel.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="messageId", ref="../apiexamples/long_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="messageId", ref="../apiexamples/long_json")})})
    @MirthOperation(name="getMaxMessageId", display="Get max messageId", permission="viewMessages", type=Operation.ExecuteType.ASYNC, auditable=false)
    public Long getMaxMessageId(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1) throws ClientException;

    @POST
    @Path(value="/{channelId}/messages/_search")
    @Operation(summary="Search for messages by specific filter criteria.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="messages", ref="../apiexamples/message_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="messages", ref="../apiexamples/message_list_json")})})
    @MirthOperation(name="searchMessages", display="Get messages by page limit", permission="viewMessages", abortable=true)
    public List<Message> getMessages(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="filter") @RequestBody(description="The MessageFilter object to use to query messages by.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="filter", ref="../apiexamples/message_filter_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="filter", ref="../apiexamples/message_filter_json")})}) MessageFilter var2, @Param(value="includeContent") @Parameter(description="If true, message content will be returned with the results.", schema=@Schema(defaultValue="false")) @QueryParam(value="includeContent") Boolean var3, @Param(value="offset") @Parameter(description="Used for pagination, determines where to start in the search results.", schema=@Schema(defaultValue="0")) @QueryParam(value="offset") Integer var4, @Param(value="limit") @Parameter(description="Used for pagination, determines the maximum number of results to return.", schema=@Schema(defaultValue="20")) @QueryParam(value="limit") Integer var5) throws ClientException;

    @GET
    @Path(value="/{channelId}/messages")
    @Operation(summary="Search for messages by specific filter criteria.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="messages", ref="../apiexamples/message_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="messages", ref="../apiexamples/message_list_json")})})
    @MirthOperation(name="searchMessages", display="Get messages by page limit", permission="viewMessages", abortable=true)
    public List<Message> getMessages(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="minMessageId") @Parameter(description="The minimum message ID to query.") @QueryParam(value="minMessageId") Long var2, @Param(value="maxMessageId") @Parameter(description="The maximum message ID to query.") @QueryParam(value="maxMessageId") Long var3, @Param(value="minOriginalId") @Parameter(description="The minimum original message ID to query. Messages that have been reprocessed will retain their original message ID.") @QueryParam(value="minOriginalId") Long var4, @Param(value="maxOriginalId") @Parameter(description="The maximum original message ID to query. Messages that have been reprocessed will retain their original message ID.") @QueryParam(value="maxOriginalId") Long var5, @Param(value="minImportId") @Parameter(description="The minimum import message ID to query. Messages that have been imported will retain their original message ID under this value.") @QueryParam(value="minImportId") Long var6, @Param(value="maxImportId") @Parameter(description="The maximum import message ID to query. Messages that have been imported will retain their original message ID under this value.") @QueryParam(value="maxImportId") Long var7, @Param(value="startDate") @Parameter(description="The earliest original received date to query by. Example: 1985-10-26T09:00:00.000-0700") @QueryParam(value="startDate") Calendar var8, @Param(value="endDate") @Parameter(description="The latest original received date to query by. Example: 2015-10-21T07:28:00.000-0700") @QueryParam(value="endDate") Calendar var9, @Param(value="textSearch") @Parameter(description="Searches all message content for this string. This process could take a long time depending on the amount of message content currently stored. Any message content that was encrypted by this channel will not be searchable.") @QueryParam(value="textSearch") String var10, @Param(value="textSearchRegex") @Parameter(description="If true, text search input will be considered a regular expression pattern to be matched. Only supported by PostgreSQL, MySQL and Oracle databases.") @QueryParam(value="textSearchRegex") Boolean var11, @Param(value="statuses") @Parameter(description="Determines which message statuses to query by.") @QueryParam(value="status") Set<Status> var12, @Param(value="includedMetaDataIds") @Parameter(description="If present, only connector metadata IDs in this list will be queried.") @QueryParam(value="includedMetaDataId") Set<Integer> var13, @Param(value="excludedMetaDataIds") @Parameter(description="If present, connector metadata IDs in this list will not be queried.") @QueryParam(value="excludedMetaDataId") Set<Integer> var14, @Param(value="serverId") @Parameter(description="The server ID associated with messages.") @QueryParam(value="serverId") String var15, @Param(value="rawContentSearches") @Parameter(description="Searches the raw content of messages.") @QueryParam(value="rawContentSearch") Set<String> var16, @Param(value="processedRawContentSearches") @Parameter(description="Searches the processed raw content of messages.") @QueryParam(value="processedRawContentSearch") Set<String> var17, @Param(value="transformedContentSearches") @Parameter(description="Searches the transformed content of messages.") @QueryParam(value="transformedContentSearch") Set<String> var18, @Param(value="encodedContentSearches") @Parameter(description="Searches the encoded content of messages.") @QueryParam(value="encodedContentSearch") Set<String> var19, @Param(value="sentContentSearches") @Parameter(description="Searches the sent content of messages.") @QueryParam(value="sentContentSearch") Set<String> var20, @Param(value="responseContentSearches") @Parameter(description="Searches the response content of messages.") @QueryParam(value="responseContentSearch") Set<String> var21, @Param(value="responseTransformedContentSearches") @Parameter(description="Searches the response transformed content of messages.") @QueryParam(value="responseTransformedContentSearch") Set<String> var22, @Param(value="processedResponseContentSearches") @Parameter(description="Searches the processed response content of messages.") @QueryParam(value="processedResponseContentSearch") Set<String> var23, @Param(value="connectorMapContentSearches") @Parameter(description="Searches the connector map content of messages.") @QueryParam(value="connectorMapContentSearch") Set<String> var24, @Param(value="channelMapContentSearches") @Parameter(description="Searches the channel map content of messages.") @QueryParam(value="channelMapContentSearch") Set<String> var25, @Param(value="sourceMapContentSearches") @Parameter(description="Searches the source map content of messages.") @QueryParam(value="sourceMapContentSearch") Set<String> var26, @Param(value="responseMapContentSearches") @Parameter(description="Searches the response map content of messages.") @QueryParam(value="responseMapContentSearch") Set<String> var27, @Param(value="processingErrorContentSearches") @Parameter(description="Searches the processing error content of messages.") @QueryParam(value="processingErrorContentSearch") Set<String> var28, @Param(value="postprocessorErrorContentSearches") @Parameter(description="Searches the postprocessor error content of messages.") @QueryParam(value="postprocessorErrorContentSearch") Set<String> var29, @Param(value="responseErrorContentSearches") @Parameter(description="Searches the response error content of messages.") @QueryParam(value="responseErrorContentSearch") Set<String> var30, @Param(value="metaDataSearches") @Parameter(description="Searches a custom metadata column. Value should be in the form: COLUMN_NAME &lt;operator&gt; value, where operator is one of the following: =, !=, <, <=, >, >=, CONTAINS, DOES NOT CONTAIN, STARTS WITH, DOES NOT START WITH, ENDS WITH, DOES NOT END WITH") @QueryParam(value="metaDataSearch") Set<MetaDataSearchParamConverterProvider.MetaDataSearch> var31, @Param(value="metaDataCaseInsensitiveSearches") @Parameter(description="Searches a custom metadata column, ignoring case. Value should be in the form: COLUMN_NAME &lt;operator&gt; value.") @QueryParam(value="metaDataCaseInsensitiveSearch") Set<MetaDataSearchParamConverterProvider.MetaDataSearch> var32, @Param(value="textSearchMetaDataColumns") @Parameter(description="When using a text search, these custom metadata columns will also be searched.") @QueryParam(value="textSearchMetaDataColumn") Set<String> var33, @Param(value="minSendAttempts") @Parameter(description="The minimum number of send attempts for connector messages.") @QueryParam(value="minSendAttempts") Integer var34, @Param(value="maxSendAttempts") @Parameter(description="The maximum number of send attempts for connector messages.") @QueryParam(value="maxSendAttempts") Integer var35, @Param(value="attachment") @Parameter(description="If true, only messages with attachments are included in the results.") @QueryParam(value="attachment") Boolean var36, @Param(value="error") @Parameter(description="If true, only messages with errors are included in the results.") @QueryParam(value="error") Boolean var37, @Param(value="includeContent") @Parameter(description="If true, message content will be returned with the results.", schema=@Schema(defaultValue="false")) @QueryParam(value="includeContent") Boolean var38, @Param(value="offset") @Parameter(description="Used for pagination, determines where to start in the search results.", schema=@Schema(defaultValue="0")) @QueryParam(value="offset") Integer var39, @Param(value="limit") @Parameter(description="Used for pagination, determines the maximum number of results to return.", schema=@Schema(defaultValue="20")) @QueryParam(value="limit") Integer var40) throws ClientException;

    @POST
    @Path(value="/{channelId}/messages/count/_search")
    @Operation(summary="Count number for messages by specific filter criteria.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="messageCount", ref="../apiexamples/long_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="messageCount", ref="../apiexamples/long_json")})})
    @MirthOperation(name="getSearchCount", display="Get search results count", permission="viewMessages", abortable=true)
    public Long getMessageCount(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="filter") @RequestBody(description="The MessageFilter object to use to query messages by.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="filter", ref="../apiexamples/message_filter_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="filter", ref="../apiexamples/message_filter_json")})}) MessageFilter var2) throws ClientException;

    @GET
    @Path(value="/{channelId}/messages/count")
    @Operation(summary="Count number for messages by specific filter criteria.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="messageCount", ref="../apiexamples/long_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="messageCount", ref="../apiexamples/long_json")})})
    @MirthOperation(name="getSearchCount", display="Get search results count", permission="viewMessages", abortable=true)
    public Long getMessageCount(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="minMessageId") @Parameter(description="The minimum message ID to query.") @QueryParam(value="minMessageId") Long var2, @Param(value="maxMessageId") @Parameter(description="The maximum message ID to query.") @QueryParam(value="maxMessageId") Long var3, @Param(value="minOriginalId") @Parameter(description="The minimum original message ID to query. Messages that have been reprocessed will retain their original message ID.") @QueryParam(value="minOriginalId") Long var4, @Param(value="maxOriginalId") @Parameter(description="The maximum original message ID to query. Messages that have been reprocessed will retain their original message ID.") @QueryParam(value="maxOriginalId") Long var5, @Param(value="minImportId") @Parameter(description="The minimum import message ID to query. Messages that have been imported will retain their original message ID under this value.") @QueryParam(value="minImportId") Long var6, @Param(value="maxImportId") @Parameter(description="The maximum import message ID to query. Messages that have been imported will retain their original message ID under this value.") @QueryParam(value="maxImportId") Long var7, @Param(value="startDate") @Parameter(description="The earliest original received date to query by. Example: 1985-10-26T09:00:00.000-0700") @QueryParam(value="startDate") Calendar var8, @Param(value="endDate") @Parameter(description="The latest original received date to query by. Example: 2015-10-21T07:28:00.000-0700") @QueryParam(value="endDate") Calendar var9, @Param(value="textSearch") @Parameter(description="Searches all message content for this string. This process could take a long time depending on the amount of message content currently stored. Any message content that was encrypted by this channel will not be searchable.") @QueryParam(value="textSearch") String var10, @Param(value="textSearchRegex") @Parameter(description="If true, text search input will be considered a regular expression pattern to be matched. Only supported by PostgreSQL, MySQL and Oracle databases.") @QueryParam(value="textSearchRegex") Boolean var11, @Param(value="statuses") @Parameter(description="Determines which message statuses to query by.") @QueryParam(value="status") Set<Status> var12, @Param(value="includedMetaDataIds") @Parameter(description="If present, only connector metadata IDs in this list will be queried.") @QueryParam(value="includedMetaDataId") Set<Integer> var13, @Param(value="excludedMetaDataIds") @Parameter(description="If present, connector metadata IDs in this list will not be queried.") @QueryParam(value="excludedMetaDataId") Set<Integer> var14, @Param(value="serverId") @Parameter(description="The server ID associated with messages.") @QueryParam(value="serverId") String var15, @Param(value="rawContentSearches") @Parameter(description="Searches the raw content of messages.") @QueryParam(value="rawContentSearch") Set<String> var16, @Param(value="processedRawContentSearches") @Parameter(description="Searches the processed raw content of messages.") @QueryParam(value="processedRawContentSearch") Set<String> var17, @Param(value="transformedContentSearches") @Parameter(description="Searches the transformed content of messages.") @QueryParam(value="transformedContentSearch") Set<String> var18, @Param(value="encodedContentSearches") @Parameter(description="Searches the encoded content of messages.") @QueryParam(value="encodedContentSearch") Set<String> var19, @Param(value="sentContentSearches") @Parameter(description="Searches the sent content of messages.") @QueryParam(value="sentContentSearch") Set<String> var20, @Param(value="responseContentSearches") @Parameter(description="Searches the response content of messages.") @QueryParam(value="responseContentSearch") Set<String> var21, @Param(value="responseTransformedContentSearches") @Parameter(description="Searches the response transformed content of messages.") @QueryParam(value="responseTransformedContentSearch") Set<String> var22, @Param(value="processedResponseContentSearches") @Parameter(description="Searches the processed response content of messages.") @QueryParam(value="processedResponseContentSearch") Set<String> var23, @Param(value="connectorMapContentSearches") @Parameter(description="Searches the connector map content of messages.") @QueryParam(value="connectorMapContentSearch") Set<String> var24, @Param(value="channelMapContentSearches") @Parameter(description="Searches the channel map content of messages.") @QueryParam(value="channelMapContentSearch") Set<String> var25, @Param(value="sourceMapContentSearches") @Parameter(description="Searches the source map content of messages.") @QueryParam(value="sourceMapContentSearch") Set<String> var26, @Param(value="responseMapContentSearches") @Parameter(description="Searches the response map content of messages.") @QueryParam(value="responseMapContentSearch") Set<String> var27, @Param(value="processingErrorContentSearches") @Parameter(description="Searches the processing error content of messages.") @QueryParam(value="processingErrorContentSearch") Set<String> var28, @Param(value="postprocessorErrorContentSearches") @Parameter(description="Searches the postprocessor error content of messages.") @QueryParam(value="postprocessorErrorContentSearch") Set<String> var29, @Param(value="responseErrorContentSearches") @Parameter(description="Searches the response error content of messages.") @QueryParam(value="responseErrorContentSearch") Set<String> var30, @Param(value="metaDataSearches") @Parameter(description="Searches a custom metadata column. Value should be in the form: COLUMN_NAME &lt;operator&gt; value, where operator is one of the following: =, !=, <, <=, >, >=, CONTAINS, DOES NOT CONTAIN, STARTS WITH, DOES NOT START WITH, ENDS WITH, DOES NOT END WITH") @QueryParam(value="metaDataSearch") Set<MetaDataSearchParamConverterProvider.MetaDataSearch> var31, @Param(value="metaDataCaseInsensitiveSearches") @Parameter(description="Searches a custom metadata column, ignoring case. Value should be in the form: COLUMN_NAME &lt;operator&gt; value.") @QueryParam(value="metaDataCaseInsensitiveSearch") Set<MetaDataSearchParamConverterProvider.MetaDataSearch> var32, @Param(value="textSearchMetaDataColumns") @Parameter(description="When using a text search, these custom metadata columns will also be searched.") @QueryParam(value="textSearchMetaDataColumn") Set<String> var33, @Param(value="minSendAttempts") @Parameter(description="The minimum number of send attempts for connector messages.") @QueryParam(value="minSendAttempts") Integer var34, @Param(value="maxSendAttempts") @Parameter(description="The maximum number of send attempts for connector messages.") @QueryParam(value="maxSendAttempts") Integer var35, @Param(value="attachment") @Parameter(description="If true, only messages with attachments are included in the results.") @QueryParam(value="attachment") Boolean var36, @Param(value="error") @Parameter(description="If true, only messages with errors are included in the results.") @QueryParam(value="error") Boolean var37) throws ClientException;

    @POST
    @Path(value="/{channelId}/messages/_reprocessWithFilter")
    @Operation(summary="Reprocesses messages through a channel filtering with a MessageFilter.")
    @MirthOperation(name="reprocessMessages", display="Reprocess messages", permission="reprocessResults", type=Operation.ExecuteType.ASYNC)
    public void reprocessMessages(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="filter") @RequestBody(description="The MessageFilter object to use to query messages by.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="filter", ref="../apiexamples/message_filter_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="filter", ref="../apiexamples/message_filter_json")})}) MessageFilter var2, @Param(value="replace") @Parameter(description="If true, the message will overwrite the current one", schema=@Schema(defaultValue="false")) @QueryParam(value="replace") boolean var3, @Param(value="filterDestinations") @Parameter(description="If true, the metaDataId parameter will be used to determine which destinations to reprocess the message through.", schema=@Schema(defaultValue="false")) @QueryParam(value="filterDestinations") boolean var4, @Param(value="reprocessMetaDataIds") @Parameter(description="Indicates which destinations to send the message to.") @QueryParam(value="metaDataId") Set<Integer> var5) throws ClientException;

    @POST
    @Path(value="/{channelId}/messages/_reprocess")
    @Consumes(value={""})
    @Operation(summary="Reprocesses messages through a channel by specific filter criteria.")
    @MirthOperation(name="reprocessMessages", display="Reprocess messages", permission="reprocessResults", type=Operation.ExecuteType.ASYNC)
    public void reprocessMessages(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="minMessageId") @Parameter(description="The minimum message ID to query.") @QueryParam(value="minMessageId") Long var2, @Param(value="maxMessageId") @Parameter(description="The maximum message ID to query.") @QueryParam(value="maxMessageId") Long var3, @Param(value="minOriginalId") @Parameter(description="The minimum original message ID to query. Messages that have been reprocessed will retain their original message ID.") @QueryParam(value="minOriginalId") Long var4, @Param(value="maxOriginalId") @Parameter(description="The maximum original message ID to query. Messages that have been reprocessed will retain their original message ID.") @QueryParam(value="maxOriginalId") Long var5, @Param(value="minImportId") @Parameter(description="The minimum import message ID to query. Messages that have been imported will retain their original message ID under this value.") @QueryParam(value="minImportId") Long var6, @Param(value="maxImportId") @Parameter(description="The maximum import message ID to query. Messages that have been imported will retain their original message ID under this value.") @QueryParam(value="maxImportId") Long var7, @Param(value="startDate") @Parameter(description="The earliest original received date to query by. Example: 1985-10-26T09:00:00.000-0700") @QueryParam(value="startDate") Calendar var8, @Param(value="endDate") @Parameter(description="The latest original received date to query by. Example: 2015-10-21T07:28:00.000-0700") @QueryParam(value="endDate") Calendar var9, @Param(value="textSearch") @Parameter(description="Searches all message content for this string. This process could take a long time depending on the amount of message content currently stored. Any message content that was encrypted by this channel will not be searchable.") @QueryParam(value="textSearch") String var10, @Param(value="textSearchRegex") @Parameter(description="If true, text search input will be considered a regular expression pattern to be matched. Only supported by PostgreSQL, MySQL and Oracle databases.") @QueryParam(value="textSearchRegex") Boolean var11, @Param(value="statuses") @Parameter(description="Determines which message statuses to query by.") @QueryParam(value="status") Set<Status> var12, @Param(value="includedMetaDataIds") @Parameter(description="If present, only connector metadata IDs in this list will be queried.") @QueryParam(value="includedMetaDataId") Set<Integer> var13, @Param(value="excludedMetaDataIds") @Parameter(description="If present, connector metadata IDs in this list will not be queried.") @QueryParam(value="excludedMetaDataId") Set<Integer> var14, @Param(value="serverId") @Parameter(description="The server ID associated with messages.") @QueryParam(value="serverId") String var15, @Param(value="rawContentSearches") @Parameter(description="Searches the raw content of messages.") @QueryParam(value="rawContentSearch") Set<String> var16, @Param(value="processedRawContentSearches") @Parameter(description="Searches the processed raw content of messages.") @QueryParam(value="processedRawContentSearch") Set<String> var17, @Param(value="transformedContentSearches") @Parameter(description="Searches the transformed content of messages.") @QueryParam(value="transformedContentSearch") Set<String> var18, @Param(value="encodedContentSearches") @Parameter(description="Searches the encoded content of messages.") @QueryParam(value="encodedContentSearch") Set<String> var19, @Param(value="sentContentSearches") @Parameter(description="Searches the sent content of messages.") @QueryParam(value="sentContentSearch") Set<String> var20, @Param(value="responseContentSearches") @Parameter(description="Searches the response content of messages.") @QueryParam(value="responseContentSearch") Set<String> var21, @Param(value="responseTransformedContentSearches") @Parameter(description="Searches the response transformed content of messages.") @QueryParam(value="responseTransformedContentSearch") Set<String> var22, @Param(value="processedResponseContentSearches") @Parameter(description="Searches the processed response content of messages.") @QueryParam(value="processedResponseContentSearch") Set<String> var23, @Param(value="connectorMapContentSearches") @Parameter(description="Searches the connector map content of messages.") @QueryParam(value="connectorMapContentSearch") Set<String> var24, @Param(value="channelMapContentSearches") @Parameter(description="Searches the channel map content of messages.") @QueryParam(value="channelMapContentSearch") Set<String> var25, @Param(value="sourceMapContentSearches") @Parameter(description="Searches the source map content of messages.") @QueryParam(value="sourceMapContentSearch") Set<String> var26, @Param(value="responseMapContentSearches") @Parameter(description="Searches the response map content of messages.") @QueryParam(value="responseMapContentSearch") Set<String> var27, @Param(value="processingErrorContentSearches") @Parameter(description="Searches the processing error content of messages.") @QueryParam(value="processingErrorContentSearch") Set<String> var28, @Param(value="postprocessorErrorContentSearches") @Parameter(description="Searches the postprocessor error content of messages.") @QueryParam(value="postprocessorErrorContentSearch") Set<String> var29, @Param(value="responseErrorContentSearches") @Parameter(description="Searches the response error content of messages.") @QueryParam(value="responseErrorContentSearch") Set<String> var30, @Param(value="metaDataSearches") @Parameter(description="Searches a custom metadata column. Value should be in the form: COLUMN_NAME &lt;operator&gt; value, where operator is one of the following: =, !=, <, <=, >, >=, CONTAINS, DOES NOT CONTAIN, STARTS WITH, DOES NOT START WITH, ENDS WITH, DOES NOT END WITH") @QueryParam(value="metaDataSearch") Set<MetaDataSearchParamConverterProvider.MetaDataSearch> var31, @Param(value="metaDataCaseInsensitiveSearches") @Parameter(description="Searches a custom metadata column, ignoring case. Value should be in the form: COLUMN_NAME &lt;operator&gt; value.") @QueryParam(value="metaDataCaseInsensitiveSearch") Set<MetaDataSearchParamConverterProvider.MetaDataSearch> var32, @Param(value="textSearchMetaDataColumns") @Parameter(description="When using a text search, these custom metadata columns will also be searched.") @QueryParam(value="textSearchMetaDataColumn") Set<String> var33, @Param(value="minSendAttempts") @Parameter(description="The minimum number of send attempts for connector messages.") @QueryParam(value="minSendAttempts") Integer var34, @Param(value="maxSendAttempts") @Parameter(description="The maximum number of send attempts for connector messages.") @QueryParam(value="maxSendAttempts") Integer var35, @Param(value="attachment") @Parameter(description="If true, only messages with attachments are included in the results.") @QueryParam(value="attachment") Boolean var36, @Param(value="error") @Parameter(description="If true, only messages with errors are included in the results.") @QueryParam(value="error") Boolean var37, @Param(value="replace") @Parameter(description="If true, the message will overwrite the current one", schema=@Schema(defaultValue="false")) @QueryParam(value="replace") boolean var38, @Param(value="filterDestinations") @Parameter(description="If true, the metaDataId parameter will be used to determine which destinations to reprocess the message through.", schema=@Schema(defaultValue="false")) @QueryParam(value="filterDestinations") boolean var39, @Param(value="reprocessMetaDataIds") @Parameter(description="Indicates which destinations to send the message to.") @QueryParam(value="metaDataId") Set<Integer> var40) throws ClientException;

    @POST
    @Path(value="/{channelId}/messages/{messageId}/_reprocess")
    @Operation(summary="Reprocesses and overwrites a single message.")
    @MirthOperation(name="reprocessMessage", display="Reprocess messages", permission="reprocessMessages", type=Operation.ExecuteType.ASYNC)
    public void reprocessMessage(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="messageId") @Parameter(description="The ID of the message.", required=true) @PathParam(value="messageId") Long var2, @Param(value="replace") @Parameter(description="If true, the message will overwrite the current one", schema=@Schema(defaultValue="false")) @QueryParam(value="replace") boolean var3, @Param(value="filterDestinations") @Parameter(description="If true, the metaDataId parameter will be used to determine which destinations to reprocess the message through.", schema=@Schema(defaultValue="false")) @QueryParam(value="filterDestinations") boolean var4, @Param(value="reprocessMetaDataIds") @Parameter(description="Indicates which destinations to send the message to.") @QueryParam(value="metaDataId") Set<Integer> var5) throws ClientException;

    @POST
    @Path(value="/{channelId}/messages/_remove")
    @Operation(summary="Remove messages by specific filter criteria.")
    @MirthOperation(name="removeMessages", display="Remove messages", permission="removeResults", abortable=true)
    public void removeMessages(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="filter") @RequestBody(description="The MessageFilter object to use to query messages by.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="filter", ref="../apiexamples/message_filter_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="filter", ref="../apiexamples/message_filter_json")})}) MessageFilter var2) throws ClientException;

    @DELETE
    @Path(value="/{channelId}/messages")
    @Consumes(value={""})
    @Operation(summary="Remove messages by specific filter criteria.")
    @MirthOperation(name="removeMessages", display="Remove messages", permission="removeResults", abortable=true)
    public void removeMessages(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="minMessageId") @Parameter(description="The minimum message ID to query.") @QueryParam(value="minMessageId") Long var2, @Param(value="maxMessageId") @Parameter(description="The maximum message ID to query.") @QueryParam(value="maxMessageId") Long var3, @Param(value="minOriginalId") @Parameter(description="The minimum original message ID to query. Messages that have been reprocessed will retain their original message ID.") @QueryParam(value="minOriginalId") Long var4, @Param(value="maxOriginalId") @Parameter(description="The maximum original message ID to query. Messages that have been reprocessed will retain their original message ID.") @QueryParam(value="maxOriginalId") Long var5, @Param(value="minImportId") @Parameter(description="The minimum import message ID to query. Messages that have been imported will retain their original message ID under this value.") @QueryParam(value="minImportId") Long var6, @Param(value="maxImportId") @Parameter(description="The maximum import message ID to query. Messages that have been imported will retain their original message ID under this value.") @QueryParam(value="maxImportId") Long var7, @Param(value="startDate") @Parameter(description="The earliest original received date to query by. Example: 1985-10-26T09:00:00.000-0700") @QueryParam(value="startDate") Calendar var8, @Param(value="endDate") @Parameter(description="The latest original received date to query by. Example: 2015-10-21T07:28:00.000-0700") @QueryParam(value="endDate") Calendar var9, @Param(value="textSearch") @Parameter(description="Searches all message content for this string. This process could take a long time depending on the amount of message content currently stored. Any message content that was encrypted by this channel will not be searchable.") @QueryParam(value="textSearch") String var10, @Param(value="textSearchRegex") @Parameter(description="If true, text search input will be considered a regular expression pattern to be matched. Only supported by PostgreSQL, MySQL and Oracle databases.") @QueryParam(value="textSearchRegex") Boolean var11, @Param(value="statuses") @Parameter(description="Determines which message statuses to query by.") @QueryParam(value="status") Set<Status> var12, @Param(value="includedMetaDataIds") @Parameter(description="If present, only connector metadata IDs in this list will be queried.") @QueryParam(value="includedMetaDataId") Set<Integer> var13, @Param(value="excludedMetaDataIds") @Parameter(description="If present, connector metadata IDs in this list will not be queried.") @QueryParam(value="excludedMetaDataId") Set<Integer> var14, @Param(value="serverId") @Parameter(description="The server ID associated with messages.") @QueryParam(value="serverId") String var15, @Param(value="rawContentSearches") @Parameter(description="Searches the raw content of messages.") @QueryParam(value="rawContentSearch") Set<String> var16, @Param(value="processedRawContentSearches") @Parameter(description="Searches the processed raw content of messages.") @QueryParam(value="processedRawContentSearch") Set<String> var17, @Param(value="transformedContentSearches") @Parameter(description="Searches the transformed content of messages.") @QueryParam(value="transformedContentSearch") Set<String> var18, @Param(value="encodedContentSearches") @Parameter(description="Searches the encoded content of messages.") @QueryParam(value="encodedContentSearch") Set<String> var19, @Param(value="sentContentSearches") @Parameter(description="Searches the sent content of messages.") @QueryParam(value="sentContentSearch") Set<String> var20, @Param(value="responseContentSearches") @Parameter(description="Searches the response content of messages.") @QueryParam(value="responseContentSearch") Set<String> var21, @Param(value="responseTransformedContentSearches") @Parameter(description="Searches the response transformed content of messages.") @QueryParam(value="responseTransformedContentSearch") Set<String> var22, @Param(value="processedResponseContentSearches") @Parameter(description="Searches the processed response content of messages.") @QueryParam(value="processedResponseContentSearch") Set<String> var23, @Param(value="connectorMapContentSearches") @Parameter(description="Searches the connector map content of messages.") @QueryParam(value="connectorMapContentSearch") Set<String> var24, @Param(value="channelMapContentSearches") @Parameter(description="Searches the channel map content of messages.") @QueryParam(value="channelMapContentSearch") Set<String> var25, @Param(value="sourceMapContentSearches") @Parameter(description="Searches the source map content of messages.") @QueryParam(value="sourceMapContentSearch") Set<String> var26, @Param(value="responseMapContentSearches") @Parameter(description="Searches the response map content of messages.") @QueryParam(value="responseMapContentSearch") Set<String> var27, @Param(value="processingErrorContentSearches") @Parameter(description="Searches the processing error content of messages.") @QueryParam(value="processingErrorContentSearch") Set<String> var28, @Param(value="postprocessorErrorContentSearches") @Parameter(description="Searches the postprocessor error content of messages.") @QueryParam(value="postprocessorErrorContentSearch") Set<String> var29, @Param(value="responseErrorContentSearches") @Parameter(description="Searches the response error content of messages.") @QueryParam(value="responseErrorContentSearch") Set<String> var30, @Param(value="metaDataSearches") @Parameter(description="Searches a custom metadata column. Value should be in the form: COLUMN_NAME &lt;operator&gt; value, where operator is one of the following: =, !=, <, <=, >, >=, CONTAINS, DOES NOT CONTAIN, STARTS WITH, DOES NOT START WITH, ENDS WITH, DOES NOT END WITH") @QueryParam(value="metaDataSearch") Set<MetaDataSearchParamConverterProvider.MetaDataSearch> var31, @Param(value="metaDataCaseInsensitiveSearches") @Parameter(description="Searches a custom metadata column, ignoring case. Value should be in the form: COLUMN_NAME &lt;operator&gt; value.") @QueryParam(value="metaDataCaseInsensitiveSearch") Set<MetaDataSearchParamConverterProvider.MetaDataSearch> var32, @Param(value="textSearchMetaDataColumns") @Parameter(description="When using a text search, these custom metadata columns will also be searched.") @QueryParam(value="textSearchMetaDataColumn") Set<String> var33, @Param(value="minSendAttempts") @Parameter(description="The minimum number of send attempts for connector messages.") @QueryParam(value="minSendAttempts") Integer var34, @Param(value="maxSendAttempts") @Parameter(description="The maximum number of send attempts for connector messages.") @QueryParam(value="maxSendAttempts") Integer var35, @Param(value="attachment") @Parameter(description="If true, only messages with attachments are included in the results.") @QueryParam(value="attachment") Boolean var36, @Param(value="error") @Parameter(description="If true, only messages with errors are included in the results.") @QueryParam(value="error") Boolean var37) throws ClientException;

    @DELETE
    @Path(value="/{channelId}/messages/{messageId}")
    @Operation(summary="Remove a single message by ID.")
    @MirthOperation(name="removeMessage", display="Remove message", permission="removeMessages", abortable=true)
    public void removeMessage(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="messageId") @Parameter(description="The ID of the message.", required=true) @PathParam(value="messageId") Long var2, @Param(value="metaDataId") @Parameter(description="If present, only the specific connector message will be removed. If the metadata ID is 0, the entire message will be removed.") @QueryParam(value="metaDataId") Integer var3, @Param(value="patientId") @Parameter(description="The patient ID of the channel message.", required=false) @QueryParam(value="patientId") String var4) throws ClientException;

    @DELETE
    @Path(value="/{channelId}/messages/_removeAll")
    @Operation(summary="Removes all messages for the specified channel.")
    @MirthOperation(name="removeAllMessages", display="Remove all messages", permission="removeAllMessages")
    public void removeAllMessages(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="restartRunningChannels") @Parameter(description="If true, currently running channels will be stopped and restarted as part of the remove process. Otherwise, currently running channels will not be included.", schema=@Schema(defaultValue="false")) @QueryParam(value="restartRunningChannels") boolean var2, @Param(value="clearStatistics") @Parameter(description="If true, message statistics will also be cleared.", schema=@Schema(defaultValue="true")) @QueryParam(value="clearStatistics") boolean var3) throws ClientException;

    @DELETE
    @Path(value="/_removeAllMessages")
    @Operation(summary="Removes all messages for multiple specified channels.")
    @MirthOperation(name="removeAllMessages", display="Remove all messages", permission="removeAllMessages")
    public void removeAllMessages(@Param(value="channelIds") @Parameter(description="The IDs of the channels.", required=true) @QueryParam(value="channelId") Set<String> var1, @Param(value="restartRunningChannels") @Parameter(description="If true, currently running channels will be stopped and restarted as part of the remove process. Otherwise, currently running channels will not be included.", schema=@Schema(defaultValue="false")) @QueryParam(value="restartRunningChannels") boolean var2, @Param(value="clearStatistics") @Parameter(description="If true, message statistics will also be cleared.", schema=@Schema(defaultValue="true")) @QueryParam(value="clearStatistics") boolean var3) throws ClientException;

    @POST
    @Path(value="/_removeAllMessagesPost")
    @Operation(summary="Removes all messages for multiple specified channels. This is a POST request alternative to DELETE /_removeAllMessages that may be used when there are too many channel IDs to include in the query parameters.")
    @MirthOperation(name="removeAllMessages", display="Remove all messages", permission="removeAllMessages")
    public void removeAllMessagesPost(@Param(value="channelIds") @RequestBody(description="The IDs of the channels.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channelIds", ref="../apiexamples/guid_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channelIds", ref="../apiexamples/guid_set_json")})}) Set<String> var1, @Param(value="restartRunningChannels") @Parameter(description="If true, currently running channels will be stopped and restarted as part of the remove process. Otherwise, currently running channels will not be included.", schema=@Schema(defaultValue="false")) @QueryParam(value="restartRunningChannels") boolean var2, @Param(value="clearStatistics") @Parameter(description="If true, message statistics will also be cleared.", schema=@Schema(defaultValue="true")) @QueryParam(value="clearStatistics") boolean var3) throws ClientException;

    @POST
    @Path(value="/{channelId}/messages/_import")
    @Operation(summary="Imports a Message object into a channel. The message will not actually be processed through the channel, only imported.")
    @MirthOperation(name="importMessage", display="Import message", permission="importMessages", type=Operation.ExecuteType.ASYNC)
    public void importMessage(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="message") @RequestBody(description="The Message object to import.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="message", ref="../apiexamples/message_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="message", ref="../apiexamples/message_json")})}) Message var2) throws ClientException;

    @POST
    @Path(value="/{channelId}/messages/_importFromPath")
    @Consumes(value={"text/plain"})
    @Operation(summary="Imports messages into a channel from a path accessible by the server. The messages will not actually be processed through the channel, only imported.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="messageImportResult", ref="../apiexamples/message_import_result_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="messageImportResult", ref="../apiexamples/message_import_result_json")})})
    @MirthOperation(name="importMessageServer", display="Import messages on the server", permission="importMessages", type=Operation.ExecuteType.ASYNC)
    public MessageImportResult importMessagesServer(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="path") @RequestBody(description="The directory path on the server side to import messages from.", required=true, content={@Content(examples={@ExampleObject(name="path", value="/path/to/message/directory")})}) String var2, @Param(value="includeSubfolders") @Parameter(description="If true, sub-folders will also be scanned recursively for messages.", schema=@Schema(defaultValue="false")) @QueryParam(value="includeSubfolders") boolean var3) throws ClientException;

    @POST
    @Path(value="/{channelId}/messages/_exportUsingFilter")
    @Consumes(value={"multipart/form-data"})
    @Operation(summary="Exports messages into a specific directory path accessible by the server. (\"Try it out\" doesn't work for this endpoint, but the descriptions are valid. Please use another tool for testing.)")
    @MirthOperation(name="exportMessage", display="Export message", permission="exportMessagesServer", type=Operation.ExecuteType.ASYNC)
    public int exportMessagesServer(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="filter") @Parameter(description="The MessageFilter object to use to query messages by.", required=true) @FormDataParam(value="filter") MessageFilter var2, @Param(value="pageSize") @Parameter(description="The maximum number of messages that will be queried at a time.") @QueryParam(value="pageSize") int var3, @Param(value="writerOptions") @Parameter(description="The MessageWriterOptions object containing various export options.") @FormDataParam(value="writerOptions") MessageWriterOptions var4) throws ClientException;

    @POST
    @Path(value="/{channelId}/messages/_export")
    @Operation(summary="Exports messages into a specific directory path accessible by the server.")
    @MirthOperation(name="exportMessage", display="Export message", permission="exportMessagesServer", type=Operation.ExecuteType.ASYNC)
    public int exportMessagesServer(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="minMessageId") @Parameter(description="The minimum message ID to query.") @QueryParam(value="minMessageId") Long var2, @Param(value="maxMessageId") @Parameter(description="The maximum message ID to query.") @QueryParam(value="maxMessageId") Long var3, @Param(value="minOriginalId") @Parameter(description="The minimum original message ID to query. Messages that have been reprocessed will retain their original message ID.") @QueryParam(value="minOriginalId") Long var4, @Param(value="maxOriginalId") @Parameter(description="The maximum original message ID to query. Messages that have been reprocessed will retain their original message ID.") @QueryParam(value="maxOriginalId") Long var5, @Param(value="minImportId") @Parameter(description="The minimum import message ID to query. Messages that have been imported will retain their original message ID under this value.") @QueryParam(value="minImportId") Long var6, @Param(value="maxImportId") @Parameter(description="The maximum import message ID to query. Messages that have been imported will retain their original message ID under this value.") @QueryParam(value="maxImportId") Long var7, @Param(value="startDate") @Parameter(description="The earliest original received date to query by. Example: 1985-10-26T09:00:00.000-0700") @QueryParam(value="startDate") Calendar var8, @Param(value="endDate") @Parameter(description="The latest original received date to query by. Example: 2015-10-21T07:28:00.000-0700") @QueryParam(value="endDate") Calendar var9, @Param(value="textSearch") @Parameter(description="Searches all message content for this string. This process could take a long time depending on the amount of message content currently stored. Any message content that was encrypted by this channel will not be searchable.") @QueryParam(value="textSearch") String var10, @Param(value="textSearchRegex") @Parameter(description="If true, text search input will be considered a regular expression pattern to be matched. Only supported by PostgreSQL, MySQL and Oracle databases.") @QueryParam(value="textSearchRegex") Boolean var11, @Param(value="statuses") @Parameter(description="Determines which message statuses to query by.") @QueryParam(value="status") Set<Status> var12, @Param(value="includedMetaDataIds") @Parameter(description="If present, only connector metadata IDs in this list will be queried.") @QueryParam(value="includedMetaDataId") Set<Integer> var13, @Param(value="excludedMetaDataIds") @Parameter(description="If present, connector metadata IDs in this list will not be queried.") @QueryParam(value="excludedMetaDataId") Set<Integer> var14, @Param(value="serverId") @Parameter(description="The server ID associated with messages.") @QueryParam(value="serverId") String var15, @Param(value="rawContentSearches") @Parameter(description="Searches the raw content of messages.") @QueryParam(value="rawContentSearch") Set<String> var16, @Param(value="processedRawContentSearches") @Parameter(description="Searches the processed raw content of messages.") @QueryParam(value="processedRawContentSearch") Set<String> var17, @Param(value="transformedContentSearches") @Parameter(description="Searches the transformed content of messages.") @QueryParam(value="transformedContentSearch") Set<String> var18, @Param(value="encodedContentSearches") @Parameter(description="Searches the encoded content of messages.") @QueryParam(value="encodedContentSearch") Set<String> var19, @Param(value="sentContentSearches") @Parameter(description="Searches the sent content of messages.") @QueryParam(value="sentContentSearch") Set<String> var20, @Param(value="responseContentSearches") @Parameter(description="Searches the response content of messages.") @QueryParam(value="responseContentSearch") Set<String> var21, @Param(value="responseTransformedContentSearches") @Parameter(description="Searches the response transformed content of messages.") @QueryParam(value="responseTransformedContentSearch") Set<String> var22, @Param(value="processedResponseContentSearches") @Parameter(description="Searches the processed response content of messages.") @QueryParam(value="processedResponseContentSearch") Set<String> var23, @Param(value="connectorMapContentSearches") @Parameter(description="Searches the connector map content of messages.") @QueryParam(value="connectorMapContentSearch") Set<String> var24, @Param(value="channelMapContentSearches") @Parameter(description="Searches the channel map content of messages.") @QueryParam(value="channelMapContentSearch") Set<String> var25, @Param(value="sourceMapContentSearches") @Parameter(description="Searches the source map content of messages.") @QueryParam(value="sourceMapContentSearch") Set<String> var26, @Param(value="responseMapContentSearches") @Parameter(description="Searches the response map content of messages.") @QueryParam(value="responseMapContentSearch") Set<String> var27, @Param(value="processingErrorContentSearches") @Parameter(description="Searches the processing error content of messages.") @QueryParam(value="processingErrorContentSearch") Set<String> var28, @Param(value="postprocessorErrorContentSearches") @Parameter(description="Searches the postprocessor error content of messages.") @QueryParam(value="postprocessorErrorContentSearch") Set<String> var29, @Param(value="responseErrorContentSearches") @Parameter(description="Searches the response error content of messages.") @QueryParam(value="responseErrorContentSearch") Set<String> var30, @Param(value="metaDataSearches") @Parameter(description="Searches a custom metadata column. Value should be in the form: COLUMN_NAME &lt;operator&gt; value, where operator is one of the following: =, !=, <, <=, >, >=, CONTAINS, DOES NOT CONTAIN, STARTS WITH, DOES NOT START WITH, ENDS WITH, DOES NOT END WITH") @QueryParam(value="metaDataSearch") Set<MetaDataSearchParamConverterProvider.MetaDataSearch> var31, @Param(value="metaDataCaseInsensitiveSearches") @Parameter(description="Searches a custom metadata column, ignoring case. Value should be in the form: COLUMN_NAME &lt;operator&gt; value.") @QueryParam(value="metaDataCaseInsensitiveSearch") Set<MetaDataSearchParamConverterProvider.MetaDataSearch> var32, @Param(value="textSearchMetaDataColumns") @Parameter(description="When using a text search, these custom metadata columns will also be searched.") @QueryParam(value="textSearchMetaDataColumn") Set<String> var33, @Param(value="minSendAttempts") @Parameter(description="The minimum number of send attempts for connector messages.") @QueryParam(value="minSendAttempts") Integer var34, @Param(value="maxSendAttempts") @Parameter(description="The maximum number of send attempts for connector messages.") @QueryParam(value="maxSendAttempts") Integer var35, @Param(value="attachment") @Parameter(description="If true, only messages with attachments are included in the results.") @QueryParam(value="attachment") Boolean var36, @Param(value="error") @Parameter(description="If true, only messages with errors are included in the results.") @QueryParam(value="error") Boolean var37, @Param(value="pageSize") @Parameter(description="The maximum number of messages that will be queried at a time. Default Value: 100") @QueryParam(value="pageSize") int var38, @Param(value="contentType") @Parameter(description="The ContentType that will be extracted from the message for writing. If null or not provided, the entire message will be written in serialized format.") @QueryParam(value="contentType") ContentType var39, @Param(value="destinationContent") @Parameter(description="If true, the content to write will be extracted from the destination message(s), rather than the source message.", schema=@Schema(defaultValue="false")) @QueryParam(value="destinationContent") boolean var40, @Param(value="encrypt") @Parameter(description="If true, message content will be encrypted before writing.", schema=@Schema(defaultValue="false")) @QueryParam(value="encrypt") boolean var41, @Param(value="includeAttachments") @Parameter(description="Determines whether attachments will be included with messages.", schema=@Schema(defaultValue="false")) @QueryParam(value="includeAttachments") boolean var42, @Param(value="baseFolder") @Parameter(description="The base directory to use when resolving relative paths in the root folder.") @QueryParam(value="baseFolder") String var43, @Param(value="rootFolder") @Parameter(description="The root folder to contain the written messages/sub-folders.", required=true) @QueryParam(value="rootFolder") String var44, @Param(value="filePattern") @Parameter(description="A string defining the folder/filename(s) for writing messages. It may contain variables to be replaced.", required=true) @QueryParam(value="filePattern") String var45, @Param(value="archiveFileName") @Parameter(description="The file name to use for archive exports.") @QueryParam(value="archiveFileName") String var46, @Param(value="archiveFormat") @Parameter(description="The archiver format to use to archive messages/folders that are written to the root folder. Valid values: zip, tar") @QueryParam(value="archiveFormat") String var47, @Param(value="compressFormat") @Parameter(description="The compressor format to use to compress the archive file. Only valid when using the TAR archive format. Valid values: gz, bzip2") @QueryParam(value="compressFormat") String var48, @Param(value="password") @Parameter(description="The password used to protect the archive file. Only valid when using the ZIP archive format.") @QueryParam(value="password") String var49, @Param(value="encryptionType") @Parameter(description="The algorithm used to encrypt the password-protected archive file. Only valid when using the ZIP archive format. Valid values: STANDARD, AES128, AES256") @QueryParam(value="encryptionType") EncryptionType var50) throws ClientException;

    @POST
    @Path(value="/{channelId}/messages/{messageId}/attachments/{attachmentId}/_export")
    @Consumes(value={"text/plain"})
    @Operation(summary="Exports a message attachment into a specific file path accessible by the server.")
    @MirthOperation(name="exportAttachment", display="Export Attachment", permission="exportMessagesServer", type=Operation.ExecuteType.ASYNC)
    public void exportAttachmentServer(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="messageId") @Parameter(description="The ID of the message.", required=true) @PathParam(value="messageId") Long var2, @Param(value="attachmentId") @Parameter(description="The ID of the attachment.", required=true) @PathParam(value="attachmentId") String var3, @Param(value="filePath") @RequestBody(description="The file path to export the attachment to.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="filePath", value="/path/to/file")})}) String var4, @Param(value="binary") @Parameter(description="Indicates that the attachment is binary and should be Base64 decoded before writing to file.", schema=@Schema(defaultValue="false")) @QueryParam(value="binary") boolean var5) throws ClientException;

    @POST
    @Path(value="/_auditAccessedPHIMessage")
    @Operation(summary="Audit that the user has accessed a channel message that contains PHI.")
    @MirthOperation(name="auditAccessedPHIMessage", display="Accessed PHI")
    public void auditAccessedPHIMessage(@Param(value="auditMessageAttributesMap") @Parameter(description="The attributes map of the channel message.", required=false) Map<String, String> var1) throws ClientException;

    @POST
    @Path(value="/_auditQueriedPHIMessage")
    @Operation(summary="Audit that the user has queried the channel messages panel that contains PHI.")
    @MirthOperation(name="auditQueriedPHIMessage", display="Queried PHI")
    public void auditQueriedPHIMessage(@Param(value="auditMessageAttributesMap") @Parameter(description="The attributes map of the channel messages filter.", required=false) Map<String, String> var1) throws ClientException;

    @POST
    @Path(value="/_auditExportMessages")
    @Operation(summary="Audit that the user has exported channel messages.")
    @MirthOperation(name="auditExportMessages", display="Export all messages")
    public void auditExportMessages(@Param(value="auditMessageAttributesMap") @Parameter(description="The attributes map of the channel messages export.", required=false) Map<String, String> var1) throws ClientException;

    @POST
    @Path(value="/_auditExportMessagesSuccess")
    @Operation(summary="Audit that the user has successfully exported channel messages.")
    @MirthOperation(name="auditExportMessagesSuccess", display="Successfully exported messages")
    public void auditExportMessagesSuccess(@Param(value="auditMessageAttributesMap") @Parameter(description="The attributes map of the channel messages export.", required=false) Map<String, String> var1) throws ClientException;
}

