/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.migration.Migratable;
import com.mirth.connect.donkey.util.purge.Purgable;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.CalendarToStringStyle;
import com.mirth.connect.model.FilterTransformerElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class FilterTransformer<C extends FilterTransformerElement>
implements Serializable,
Migratable,
Purgable {
    private List<C> elements = new ArrayList<C>();

    public FilterTransformer() {
    }

    public FilterTransformer(FilterTransformer<C> props) {
        if (CollectionUtils.isNotEmpty(props.getElements())) {
            for (FilterTransformerElement element : props.getElements()) {
                this.elements.add(element.clone());
            }
        }
    }

    public List<C> getElements() {
        return this.elements;
    }

    public List<C> getEnabledElements() {
        ArrayList<FilterTransformerElement> enabledElements = new ArrayList<FilterTransformerElement>();
        for (FilterTransformerElement element : this.elements) {
            if (!element.isEnabled()) continue;
            enabledElements.add(element);
        }
        return enabledElements;
    }

    public void setElements(List<C> elements) {
        this.elements = elements;
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("elements", PurgeUtil.purgeList(this.elements));
        return purgedProperties;
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)CalendarToStringStyle.instance());
    }

    public abstract FilterTransformer<C> clone();
}

