/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.mirth.connect.model.ResourceProperties;
import com.mirth.connect.userutil.XmlUtil;

public class InvalidResourceProperties
extends ResourceProperties {
    private String propertiesXml;
    private Throwable cause;

    public InvalidResourceProperties(String preUnmarshalXml, DonkeyElement properties, Throwable cause) {
        super(null, null);
        if (preUnmarshalXml == null || properties == null) {
            throw new SerializerException("Could not create invalid resource properties. The properties element or XML is null.");
        }
        DonkeyElement pluginPointName = properties.getChildElement("pluginPointName");
        DonkeyElement type = properties.getChildElement("type");
        DonkeyElement id = properties.getChildElement("id");
        DonkeyElement name = properties.getChildElement("name");
        if (pluginPointName == null || type == null || name == null || id == null) {
            throw new SerializerException("Could not create invalid resource properties. The plugin point, type, name, or ID is missing.");
        }
        try {
            this.setPluginPointName(pluginPointName.getTextContent());
            this.setType(type.getTextContent());
            this.setId(id.getTextContent());
            super.setName(name.getTextContent());
            this.propertiesXml = preUnmarshalXml;
            this.cause = cause;
        }
        catch (Exception e) {
            throw new SerializerException((Throwable)e);
        }
    }

    public String getPropertiesXml() {
        return this.propertiesXml;
    }

    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public void setName(String name) {
        if (this.propertiesXml != null) {
            try {
                DonkeyElement root = new DonkeyElement(this.propertiesXml);
                DonkeyElement child = root.getChildElement("name");
                if (child != null) {
                    child.setTextContent(name);
                }
                this.propertiesXml = root.toXml();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.setName(name);
    }

    @Override
    public String toString() {
        return "<html>" + XmlUtil.encode(super.toString()) + " <b>(Invalid)</b></html>";
    }
}

