/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.model.CalendarToStringStyle;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XStreamAlias(value="event")
public class ServerEvent
extends Event
implements Serializable {
    public static final String ATTR_EXCEPTION = "Exception";
    private int id;
    private Calendar eventTime;
    private Level level = Level.INFORMATION;
    private String name;
    private Map<String, String> attributes = new LinkedHashMap<String, String>();
    private Outcome outcome = Outcome.SUCCESS;
    private int userId = 0;
    private String patientId;
    private String ipAddress;
    private String serverId;
    private String channelId;
    private String channelName;
    private String messageId;

    public ServerEvent() {
        this.eventTime = Calendar.getInstance();
        this.eventTime.setTimeInMillis(this.getDateTime());
    }

    public ServerEvent(String serverId, String name) {
        this();
        this.serverId = serverId;
        this.name = name;
    }

    public ServerEvent(String serverId, String name, Level level, Outcome outcome, Map<String, String> attributes) {
        this();
        this.serverId = serverId;
        this.name = name;
        this.level = level;
        this.outcome = outcome;
        this.attributes = attributes;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Calendar getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Calendar eventTime) {
        this.eventTime = eventTime;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Outcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(Outcome outcome) {
        this.outcome = outcome;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    private String cleanString(String value) {
        if (value == null) {
            return value;
        }
        return value.trim().replaceAll("[\n\r]$", "");
    }

    public String getPatientId() {
        this.patientId = this.cleanString(this.attributes.get("patientId"));
        return this.patientId;
    }

    public void setPatientId(String patientId) {
        this.patientId = patientId;
    }

    public String getMessageId() {
        try {
            this.messageId = this.cleanString(this.attributes.get("messageId"));
            return this.messageId;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getChannelId() {
        try {
            String channelId;
            String channel = this.cleanString(this.attributes.get("channel"));
            this.channelId = channelId = channel != null && channel.contains("id") ? channel.substring(channel.indexOf("id=") + 3, channel.indexOf(",")) : null;
            return channelId;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getChannelName() {
        try {
            String channelName;
            String channel = this.attributes.get("channel");
            this.channelName = channelName = channel != null && channel.contains("name") ? channel.substring(channel.indexOf("name=") + 5, channel.indexOf("]")) : null;
            return channelName;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getChannelIdWithMessageId() {
        String channelId = this.getChannelId();
        String messageId = this.getMessageId();
        return channelId != null ? channelId + (String)(messageId != null ? " - " + messageId : "") : null;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)CalendarToStringStyle.instance());
    }

    public static String getExportHeader() {
        return "ID, Date and Time, Level, Outcome, Name, User ID, IP Address, Attributes, ChannelID-MessageID, ChannelName, PatientID";
    }

    public String toExportString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id + ", ");
        builder.append(new SimpleDateFormat("dd-MM-yy HH-mm-ss.SS").format(this.eventTime.getTime()) + ", ");
        builder.append(String.valueOf((Object)this.level) + ", ");
        builder.append(String.valueOf((Object)this.outcome) + ", ");
        builder.append(this.name + ", ");
        builder.append(this.userId + ", ");
        builder.append(this.ipAddress + ", ");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        MapUtils.verbosePrint((PrintStream)ps, (Object)"attributes", this.attributes);
        builder.append(Base64.encodeBase64URLSafeString((byte[])baos.toByteArray()));
        IOUtils.closeQuietly((OutputStream)ps);
        builder.append("," + this.getChannelIdWithMessageId() + ",");
        builder.append(this.getChannelName() + ",");
        builder.append(this.getPatientId());
        builder.append(System.getProperty("line.separator"));
        return builder.toString();
    }

    public String toExportStringWithNoId() {
        StringBuilder builder = new StringBuilder();
        Date roundedEventTime = new Date(Math.round((double)this.eventTime.getTimeInMillis() / 1000.0));
        builder.append(new SimpleDateFormat("dd-MM-yy HH-mm-ss.SS").format(roundedEventTime) + ", ");
        builder.append(String.valueOf((Object)this.level) + ", ");
        builder.append(String.valueOf((Object)this.outcome) + ", ");
        builder.append(this.name + ", ");
        builder.append(this.userId + ", ");
        builder.append(this.ipAddress + ", ");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        MapUtils.verbosePrint((PrintStream)ps, (Object)"attributes", this.attributes);
        builder.append(Base64.encodeBase64URLSafeString((byte[])baos.toByteArray()));
        IOUtils.closeQuietly((OutputStream)ps);
        builder.append("," + this.getChannelIdWithMessageId() + ",");
        builder.append(this.getChannelName() + ",");
        builder.append(this.getPatientId());
        builder.append(System.getProperty("line.separator"));
        return builder.toString();
    }

    public static enum Level {
        INFORMATION,
        WARNING,
        ERROR;

    }

    public static enum Outcome {
        SUCCESS,
        FAILURE;

    }
}

