/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.util.purge.Purgable;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.AbstractSettings;
import com.mirth.connect.model.Auditable;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.util.DefaultMetaData;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XStreamAlias(value="serverSettings")
public class ServerSettings
extends AbstractSettings
implements Serializable,
Auditable,
Purgable {
    public static final Color DEFAULT_COLOR = new Color(10400201);
    public static final String DEFAULT_LOGIN_NOTIFICATION_ENABLED_VALUE = "0";
    public static final String DEFAULT_LOGIN_NOTIFICATION_MESSAGE_VALUE = "";
    public static final String DEFAULT_ADMINISTRATOR_AUTO_LOGOUT_INTERVAL_ENABLED_VALUE = "0";
    public static final Integer DEFAULT_ADMINISTRATOR_AUTO_LOGOUT_INTERVAL_FIELD_VALUE = 5;
    private static final String CLEAR_GLOBAL_MAP = "server.resetglobalvariables";
    protected static final String QUEUE_BUFFER_SIZE = "server.queuebuffersize";
    protected static final String DEFAULT_METADATA_COLUMNS = "server.defaultmetadatacolumns";
    protected static final String DEFAULT_ADMINISTRATOR_COLOR = "server.defaultadministratorcolor";
    private static final String SMTP_HOST = "smtp.host";
    private static final String SMTP_PORT = "smtp.port";
    private static final String SMTP_TIMEOUT = "smtp.timeout";
    private static final String SMTP_FROM = "smtp.from";
    private static final String SMTP_SECURE = "smtp.secure";
    private static final String SMTP_AUTH = "smtp.auth";
    private static final String SMTP_USERNAME = "smtp.username";
    private static final String SMTP_PASSWORD = "smtp.password";
    protected static final String LOGIN_NOTIFICATION_ENABLED = "loginnotification.enabled";
    protected static final String LOGIN_NOTIFICATION_MESSAGE = "loginnotification.message";
    protected static final String ADMINISTRATOR_AUTO_LOGOUT_INTERVAL_ENABLED = "administratorautologoutinterval.enabled";
    protected static final String ADMINISTRATOR_AUTO_LOGOUT_INTERVAL_FIELD = "administratorautologoutinterval.field";
    private String environmentName;
    private String serverName;
    private Boolean clearGlobalMap;
    private Integer queueBufferSize;
    private List<MetaDataColumn> defaultMetaDataColumns;
    private Color defaultAdministratorBackgroundColor;
    private String smtpHost;
    private String smtpPort;
    private String smtpTimeout;
    private String smtpFrom;
    private String smtpSecure;
    private Boolean smtpAuth;
    private String smtpUsername;
    private String smtpPassword;
    private Boolean loginNotificationEnabled;
    private String loginNotificationMessage;
    private Boolean administratorAutoLogoutIntervalEnabled;
    private Integer administratorAutoLogoutIntervalField;

    public ServerSettings() {
    }

    public ServerSettings(String environmentName, String serverName, Properties properties) {
        this.setEnvironmentName(environmentName);
        this.setServerName(serverName);
        this.setProperties(properties);
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        if (this.getClearGlobalMap() != null) {
            properties.put(CLEAR_GLOBAL_MAP, BooleanUtils.toIntegerObject((Boolean)this.getClearGlobalMap()).toString());
        }
        if (this.getQueueBufferSize() != null) {
            properties.put(QUEUE_BUFFER_SIZE, this.getQueueBufferSize().toString());
        }
        if (this.getDefaultMetaDataColumns() != null) {
            properties.put(DEFAULT_METADATA_COLUMNS, ObjectXMLSerializer.getInstance().serialize(this.getDefaultMetaDataColumns()));
        }
        if (this.getDefaultAdministratorBackgroundColor() != null) {
            properties.put(DEFAULT_ADMINISTRATOR_COLOR, ObjectXMLSerializer.getInstance().serialize(this.getDefaultAdministratorBackgroundColor()));
        }
        if (this.getSmtpHost() != null) {
            properties.put(SMTP_HOST, this.getSmtpHost());
        }
        if (this.getSmtpPort() != null) {
            properties.put(SMTP_PORT, this.getSmtpPort());
        }
        if (this.getSmtpTimeout() != null) {
            properties.put(SMTP_TIMEOUT, this.getSmtpTimeout().toString());
        }
        if (this.getSmtpFrom() != null) {
            properties.put(SMTP_FROM, this.getSmtpFrom());
        }
        if (this.getSmtpSecure() != null) {
            properties.put(SMTP_SECURE, this.getSmtpSecure());
        }
        if (this.getSmtpAuth() != null) {
            properties.put(SMTP_AUTH, BooleanUtils.toIntegerObject((Boolean)this.getSmtpAuth()).toString());
        }
        if (this.getSmtpUsername() != null) {
            properties.put(SMTP_USERNAME, this.getSmtpUsername());
        }
        if (this.getSmtpPassword() != null) {
            properties.put(SMTP_PASSWORD, this.getSmtpPassword());
        }
        if (this.getLoginNotificationEnabled() != null) {
            properties.put(LOGIN_NOTIFICATION_ENABLED, BooleanUtils.toIntegerObject((Boolean)this.getLoginNotificationEnabled()).toString());
        }
        if (this.getLoginNotificationMessage() != null) {
            properties.put(LOGIN_NOTIFICATION_MESSAGE, this.getLoginNotificationMessage());
        }
        if (this.getAdministratorAutoLogoutIntervalEnabled() != null) {
            properties.put(ADMINISTRATOR_AUTO_LOGOUT_INTERVAL_ENABLED, BooleanUtils.toIntegerObject((Boolean)this.getAdministratorAutoLogoutIntervalEnabled()).toString());
        }
        if (this.getAdministratorAutoLogoutIntervalField() != null) {
            properties.put(ADMINISTRATOR_AUTO_LOGOUT_INTERVAL_FIELD, this.getAdministratorAutoLogoutIntervalField().toString());
        }
        return properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.setClearGlobalMap(this.intToBooleanObject(properties.getProperty(CLEAR_GLOBAL_MAP)));
        this.setQueueBufferSize(this.toIntegerObject(properties.getProperty(QUEUE_BUFFER_SIZE)));
        this.setDefaultMetaDataColumns(this.toList(properties.getProperty(DEFAULT_METADATA_COLUMNS), MetaDataColumn.class, DefaultMetaData.DEFAULT_COLUMNS));
        this.setDefaultAdministratorBackgroundColor(this.deserialize(properties.getProperty(DEFAULT_ADMINISTRATOR_COLOR), Color.class, DEFAULT_COLOR));
        this.setSmtpHost(properties.getProperty(SMTP_HOST));
        this.setSmtpPort(properties.getProperty(SMTP_PORT));
        this.setSmtpTimeout(properties.getProperty(SMTP_TIMEOUT));
        this.setSmtpFrom(properties.getProperty(SMTP_FROM));
        this.setSmtpSecure(properties.getProperty(SMTP_SECURE));
        this.setSmtpAuth(this.intToBooleanObject(properties.getProperty(SMTP_AUTH)));
        this.setSmtpUsername(properties.getProperty(SMTP_USERNAME));
        this.setSmtpPassword(properties.getProperty(SMTP_PASSWORD));
        this.setLoginNotificationEnabled(this.intToBooleanObject(properties.getProperty(LOGIN_NOTIFICATION_ENABLED, "0")));
        this.setLoginNotificationMessage(properties.getProperty(LOGIN_NOTIFICATION_MESSAGE, DEFAULT_LOGIN_NOTIFICATION_MESSAGE_VALUE));
        this.setAdministratorAutoLogoutIntervalEnabled(this.intToBooleanObject(properties.getProperty(ADMINISTRATOR_AUTO_LOGOUT_INTERVAL_ENABLED, "0")));
        this.setAdministratorAutoLogoutIntervalField(this.toIntegerObject(properties.getProperty(ADMINISTRATOR_AUTO_LOGOUT_INTERVAL_FIELD, DEFAULT_ADMINISTRATOR_AUTO_LOGOUT_INTERVAL_FIELD_VALUE.toString())));
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public Boolean getClearGlobalMap() {
        return this.clearGlobalMap;
    }

    public void setClearGlobalMap(Boolean clearGlobalMap) {
        this.clearGlobalMap = clearGlobalMap;
    }

    public Integer getQueueBufferSize() {
        return this.queueBufferSize;
    }

    public void setQueueBufferSize(Integer queueBufferSize) {
        this.queueBufferSize = queueBufferSize;
    }

    public List<MetaDataColumn> getDefaultMetaDataColumns() {
        return this.defaultMetaDataColumns;
    }

    public void setDefaultMetaDataColumns(List<MetaDataColumn> defaultMetaDataColumns) {
        this.defaultMetaDataColumns = defaultMetaDataColumns;
    }

    public Color getDefaultAdministratorBackgroundColor() {
        return this.defaultAdministratorBackgroundColor;
    }

    public void setDefaultAdministratorBackgroundColor(Color defaultAdministratorBackgroundColor) {
        this.defaultAdministratorBackgroundColor = defaultAdministratorBackgroundColor;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(String smtpPort) {
        this.smtpPort = smtpPort;
    }

    public String getSmtpTimeout() {
        return this.smtpTimeout;
    }

    public void setSmtpTimeout(String smtpTimeout) {
        this.smtpTimeout = smtpTimeout;
    }

    public String getSmtpFrom() {
        return this.smtpFrom;
    }

    public void setSmtpFrom(String smtpFrom) {
        this.smtpFrom = smtpFrom;
    }

    public String getSmtpSecure() {
        return this.smtpSecure;
    }

    public void setSmtpSecure(String smtpSecure) {
        this.smtpSecure = smtpSecure;
    }

    public Boolean getSmtpAuth() {
        return this.smtpAuth;
    }

    public void setSmtpAuth(Boolean smtpAuth) {
        this.smtpAuth = smtpAuth;
    }

    public String getSmtpUsername() {
        return this.smtpUsername;
    }

    public void setSmtpUsername(String smtpUsername) {
        this.smtpUsername = smtpUsername;
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
    }

    public Boolean getLoginNotificationEnabled() {
        return this.loginNotificationEnabled;
    }

    public void setLoginNotificationEnabled(Boolean loginNotificationEnabled) {
        this.loginNotificationEnabled = loginNotificationEnabled;
    }

    public String getLoginNotificationMessage() {
        return this.loginNotificationMessage;
    }

    public void setLoginNotificationMessage(String loginNotificationMessage) {
        this.loginNotificationMessage = loginNotificationMessage;
    }

    public Boolean getAdministratorAutoLogoutIntervalEnabled() {
        return this.administratorAutoLogoutIntervalEnabled;
    }

    public void setAdministratorAutoLogoutIntervalEnabled(Boolean administratorAutoLogoutIntervalEnabled) {
        this.administratorAutoLogoutIntervalEnabled = administratorAutoLogoutIntervalEnabled;
    }

    public Integer getAdministratorAutoLogoutIntervalField() {
        return this.administratorAutoLogoutIntervalField;
    }

    public void setAdministratorAutoLogoutIntervalField(Integer administratorAutoLogoutIntervalField) {
        this.administratorAutoLogoutIntervalField = administratorAutoLogoutIntervalField;
    }

    @Override
    public String toAuditString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("clearGlobalMap", this.clearGlobalMap);
        purgedProperties.put("queueBufferSize", this.queueBufferSize);
        purgedProperties.put("defaultMetaDataColumns", PurgeUtil.purgeList(this.defaultMetaDataColumns));
        purgedProperties.put("defaultAdministratorBackgroundColor", this.defaultAdministratorBackgroundColor);
        purgedProperties.put("smtpTimeout", PurgeUtil.getNumericValue((String)this.smtpTimeout));
        purgedProperties.put("smtpSecure", this.smtpSecure);
        purgedProperties.put("smtpAuth", this.smtpAuth);
        return purgedProperties;
    }
}

