/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json;

import de.odysseus.staxon.base.AbstractXMLOutputFactory;
import de.odysseus.staxon.event.SimpleXMLEventWriter;
import de.odysseus.staxon.json.JsonXMLConfig;
import de.odysseus.staxon.json.JsonXMLStreamWriter;
import de.odysseus.staxon.json.stream.JsonStreamFactory;
import de.odysseus.staxon.json.stream.JsonStreamTarget;
import de.odysseus.staxon.json.stream.util.AutoArrayTarget;
import de.odysseus.staxon.json.stream.util.AutoPrimitiveTarget;
import de.odysseus.staxon.json.stream.util.RemoveRootTarget;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class JsonXMLOutputFactory
extends AbstractXMLOutputFactory {
    public static final String PROP_AUTO_ARRAY = "JsonXMLOutputFactory.autoArray";
    public static final String PROP_AUTO_PRIMITIVE = "JsonXMLOutputFactory.autoPrimitive";
    public static final String PROP_MULTIPLE_PI = "JsonXMLOutputFactory.multiplePI";
    public static final String PROP_VIRTUAL_ROOT = "JsonXMLOutputFactory.virtualRoot";
    public static final String PROP_NAMESPACE_SEPARATOR = "JsonXMLOutputFactory.namespaceSeparator";
    public static final String PROP_NAMESPACE_DECLARATIONS = "JsonXMLOutputFactory.namespaceDeclarations";
    public static final String PROP_NAMESPACE_MAPPINGS = "JsonXMLOutputFactory.namespaceMappings";
    public static final String PROP_PRETTY_PRINT = "JsonXMLOutputFactory.prettyPrint";
    protected JsonStreamFactory streamFactory;
    protected boolean multiplePI;
    protected QName virtualRoot;
    protected boolean autoArray;
    protected boolean autoPrimitive;
    protected boolean prettyPrint;
    protected char namespaceSeparator;
    protected boolean namespaceDeclarations;
    protected Map<String, String> namespaceMappings;

    public JsonXMLOutputFactory() throws FactoryConfigurationError {
        this(JsonXMLConfig.DEFAULT);
    }

    public JsonXMLOutputFactory(JsonStreamFactory streamFactory) {
        this(JsonXMLConfig.DEFAULT, streamFactory);
    }

    public JsonXMLOutputFactory(JsonXMLConfig config) throws FactoryConfigurationError {
        this(config, JsonStreamFactory.newFactory());
    }

    public JsonXMLOutputFactory(JsonXMLConfig config, JsonStreamFactory streamFactory) {
        this.multiplePI = config.isMultiplePI();
        this.virtualRoot = config.getVirtualRoot();
        this.autoArray = config.isAutoArray();
        this.autoPrimitive = config.isAutoPrimitive();
        this.prettyPrint = config.isPrettyPrint();
        this.namespaceSeparator = config.getNamespaceSeparator();
        this.namespaceDeclarations = config.isNamespaceDeclarations();
        this.namespaceMappings = config.getNamespaceMappings();
        this.streamFactory = streamFactory;
        super.setProperty("javax.xml.stream.isRepairingNamespaces", (Object)config.isRepairingNamespaces());
    }

    protected JsonStreamTarget decorate(JsonStreamTarget target) {
        if (this.virtualRoot != null) {
            target = new RemoveRootTarget(target, this.virtualRoot, this.namespaceSeparator);
        }
        if (this.autoArray) {
            target = new AutoArrayTarget(target);
        }
        if (this.autoPrimitive) {
            target = new AutoPrimitiveTarget(target, false);
        }
        return target;
    }

    public JsonXMLStreamWriter createXMLStreamWriter(OutputStream stream, String encoding) throws XMLStreamException {
        try {
            return this.createXMLStreamWriter(new OutputStreamWriter(stream, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLStreamException(e);
        }
    }

    protected Map<String, String> repairNamespacesMap() {
        if (Boolean.TRUE.equals(this.getProperty("javax.xml.stream.isRepairingNamespaces"))) {
            if (this.namespaceMappings == null || this.namespaceMappings.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, String> reverseNamespaceMappings = new HashMap<String, String>();
            for (Map.Entry<String, String> namespaceMapping : this.namespaceMappings.entrySet()) {
                reverseNamespaceMappings.put(namespaceMapping.getValue(), namespaceMapping.getKey());
            }
            return reverseNamespaceMappings;
        }
        return null;
    }

    public JsonXMLStreamWriter createXMLStreamWriter(Writer stream) throws XMLStreamException {
        try {
            return new JsonXMLStreamWriter(this.decorate(this.streamFactory.createJsonStreamTarget(stream, this.prettyPrint)), this.repairNamespacesMap(), this.multiplePI, this.namespaceSeparator, this.namespaceDeclarations);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public JsonXMLStreamWriter createXMLStreamWriter(OutputStream stream) throws XMLStreamException {
        try {
            return new JsonXMLStreamWriter(this.decorate(this.streamFactory.createJsonStreamTarget(stream, this.prettyPrint)), this.repairNamespacesMap(), this.multiplePI, this.namespaceSeparator, this.namespaceDeclarations);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public XMLEventWriter createXMLEventWriter(XMLStreamWriter writer) throws XMLStreamException {
        return new SimpleXMLEventWriter(writer);
    }

    public boolean isPropertySupported(String name) {
        return super.isPropertySupported(name) || Arrays.asList(PROP_AUTO_ARRAY, PROP_MULTIPLE_PI, PROP_VIRTUAL_ROOT, PROP_NAMESPACE_SEPARATOR, PROP_NAMESPACE_DECLARATIONS, PROP_NAMESPACE_MAPPINGS, PROP_PRETTY_PRINT).contains(name);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if (super.isPropertySupported(name)) {
            return super.getProperty(name);
        }
        if (PROP_AUTO_ARRAY.equals(name)) {
            return this.autoArray;
        }
        if (PROP_AUTO_PRIMITIVE.equals(name)) {
            return this.autoPrimitive;
        }
        if (PROP_MULTIPLE_PI.equals(name)) {
            return this.multiplePI;
        }
        if (PROP_VIRTUAL_ROOT.equals(name)) {
            return this.virtualRoot;
        }
        if (PROP_PRETTY_PRINT.equals(name)) {
            return this.prettyPrint;
        }
        if (PROP_NAMESPACE_SEPARATOR.equals(name)) {
            return Character.valueOf(this.namespaceSeparator);
        }
        if (PROP_NAMESPACE_DECLARATIONS.equals(name)) {
            return this.namespaceDeclarations;
        }
        if (PROP_NAMESPACE_MAPPINGS.equals(name)) {
            return this.namespaceMappings;
        }
        throw new IllegalArgumentException("Unsupported property: " + name);
    }

    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if (super.isPropertySupported(name)) {
            super.setProperty(name, value);
        } else if (PROP_AUTO_ARRAY.equals(name)) {
            this.autoArray = (Boolean)value;
        } else if (PROP_AUTO_PRIMITIVE.equals(name)) {
            this.autoPrimitive = (Boolean)value;
        } else if (PROP_MULTIPLE_PI.equals(name)) {
            this.multiplePI = (Boolean)value;
        } else if (PROP_VIRTUAL_ROOT.equals(name)) {
            this.virtualRoot = value instanceof String ? QName.valueOf((String)value) : (QName)value;
        } else if (PROP_PRETTY_PRINT.equals(name)) {
            this.prettyPrint = (Boolean)value;
        } else if (PROP_NAMESPACE_SEPARATOR.equals(name)) {
            this.namespaceSeparator = ((Character)value).charValue();
        } else if (PROP_NAMESPACE_DECLARATIONS.equals(name)) {
            this.namespaceDeclarations = (Boolean)value;
        } else if (PROP_NAMESPACE_MAPPINGS.equals(name)) {
            Map map;
            this.namespaceMappings = map = (Map)value;
        } else {
            throw new IllegalArgumentException("Unsupported property: " + name);
        }
    }
}

