/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.serverlog;

import com.mirth.connect.client.core.api.util.OperationUtil;
import com.mirth.connect.model.ExtensionPermission;
import com.mirth.connect.plugins.ServicePlugin;
import com.mirth.connect.plugins.serverlog.ArrayAppender;
import com.mirth.connect.plugins.serverlog.ServerLogController;
import com.mirth.connect.plugins.serverlog.ServerLogItem;
import com.mirth.connect.plugins.serverlog.ServerLogServletInterface;
import com.mirth.connect.server.controllers.ControllerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class ServerLogProvider
implements ServicePlugin {
    private static long logId = 1L;
    private String serverId;
    private ServerLogController logController;

    public String getPluginPointName() {
        return "Server Log";
    }

    private void initialize() {
        ArrayAppender arrayAppender = new ArrayAppender(this, (Layout<? extends Serializable>)PatternLayout.newBuilder().withPattern("[%d]  %-5p (%c:%L): %m%n").build());
        arrayAppender.start();
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        context.getConfiguration().addAppender((Appender)arrayAppender);
        context.getRootLogger().addAppender(context.getConfiguration().getAppender(arrayAppender.getName()));
        context.updateLoggers();
        this.serverId = ControllerFactory.getFactory().createConfigurationController().getServerId();
        this.logController = ServerLogController.getInstance();
    }

    public void init(Properties properties) {
        this.initialize();
    }

    public synchronized void newServerLogReceived(String level, Date date, String threadName, String category, String lineNumber, String message, String throwableInformation) {
        if (this.logController != null) {
            this.logController.addLogItem(new ServerLogItem(this.serverId, Long.valueOf(logId), level, date, threadName, category, lineNumber, message, throwableInformation));
            ++logId;
        }
    }

    public List<ServerLogItem> getServerLogs(int fetchSize, Long lastLogId) {
        if (this.logController != null) {
            return this.logController.getServerLogs(fetchSize, lastLogId);
        }
        return new ArrayList<ServerLogItem>();
    }

    public void start() {
    }

    public void update(Properties properties) {
    }

    public void stop() {
    }

    public Properties getDefaultProperties() {
        return new Properties();
    }

    public ExtensionPermission[] getExtensionPermissions() {
        ExtensionPermission viewPermission = new ExtensionPermission("Server Log", "View Server Log", "Displays the contents of the Server Log on the Dashboard.", OperationUtil.getOperationNamesForPermission((String)"View Server Log", ServerLogServletInterface.class, (String[])new String[0]), new String[0]);
        return new ExtensionPermission[]{viewPermission};
    }
}

