/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.DataWriter;
import org.dcm4che2.net.DataWriterAdapter;
import org.dcm4che2.net.PDVOutputStream;
import org.dcm4che2.net.pdu.AAbort;
import org.dcm4che2.net.pdu.AAssociateAC;
import org.dcm4che2.net.pdu.AAssociateRJ;
import org.dcm4che2.net.pdu.AAssociateRQ;
import org.dcm4che2.net.pdu.AAssociateRQAC;
import org.dcm4che2.net.pdu.CommonExtendedNegotiation;
import org.dcm4che2.net.pdu.ExtendedNegotiation;
import org.dcm4che2.net.pdu.PresentationContext;
import org.dcm4che2.net.pdu.RoleSelection;
import org.dcm4che2.net.pdu.UserIdentityAC;
import org.dcm4che2.net.pdu.UserIdentityRQ;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PDUEncoder
extends PDVOutputStream {
    static Logger log = LoggerFactory.getLogger(PDUEncoder.class);
    private static final int DEF_PDU_LEN = 16384;
    private final Association as;
    private final OutputStream out;
    private byte[] buf10 = new byte[]{0, 0, 0, 0, 0, 4, 0, 0, 0, 0};
    private byte[] buf = new byte[16390];
    private int maxpdulen;
    private int pos;
    private int pdvpcid;
    private int pdvcmd;
    private int pdvpos;
    private Thread th;
    private Object dimseLock = new Object();

    public PDUEncoder(Association as, OutputStream out) {
        this.as = as;
        this.out = out;
    }

    private void write(int pdutype, int result, int source, int reason) throws IOException {
        this.buf10[0] = (byte)pdutype;
        this.buf10[7] = (byte)result;
        this.buf10[8] = (byte)source;
        this.buf10[9] = (byte)reason;
        this.out.write(this.buf10, 0, 10);
        this.out.flush();
    }

    public synchronized void write(AAssociateRJ rj) throws IOException {
        log.info("{} << {}", (Object)this.as.toString(), (Object)rj.getMessage());
        this.write(3, rj.getResult(), rj.getSource(), rj.getReason());
    }

    public synchronized void writeAReleaseRQ() throws IOException {
        log.info("{} << A-RELEASE-RQ", (Object)this.as.toString());
        this.write(5, 0, 0, 0);
    }

    public synchronized void writeAReleaseRP() throws IOException {
        log.info("{} << A-RELEASE-RP", (Object)this.as.toString());
        this.write(6, 0, 0, 0);
    }

    public synchronized void write(AAbort aa) throws IOException {
        log.info("{} << {}", (Object)this.as, (Object)aa.getMessage());
        this.write(7, 0, aa.getSource(), aa.getReason());
    }

    public synchronized void writePDataTF() throws IOException {
        int pdulen = this.pos - 6;
        this.pos = 0;
        this.put(4);
        this.put(0);
        this.putInt(pdulen);
        if (log.isDebugEnabled()) {
            log.debug(this.as.toString() + " << P-DATA-TF[len=" + pdulen + "]");
        }
        this.writePDU(pdulen);
    }

    public synchronized void write(AAssociateRQ rq) throws IOException {
        log.info("{}: A-ASSOCIATE-RQ {} << {}", new Object[]{this.as, rq.getCalledAET(), rq.getCallingAET()});
        log.debug("{}", (Object)rq);
        this.write(rq, 1, 32);
    }

    public synchronized void write(AAssociateAC ac) throws IOException {
        log.info("{}: A-ASSOCIATE-AC {} << {}", new Object[]{this.as, ac.getCalledAET(), ac.getCallingAET()});
        log.debug("{}", (Object)ac);
        this.write(ac, 2, 33);
    }

    private void write(AAssociateRQAC rqac, int pdutype, int pcItemType) throws IOException {
        int pdulen = rqac.length();
        if (this.buf.length < 6 + pdulen) {
            this.buf = new byte[6 + pdulen];
        }
        this.pos = 0;
        this.put(pdutype);
        this.put(0);
        this.putInt(pdulen);
        this.putShort(rqac.getProtocolVersion());
        this.put(0);
        this.put(0);
        this.encodeAET(rqac.getCalledAET());
        this.encodeAET(rqac.getCallingAET());
        this.put(rqac.getReservedBytes(), 0, 32);
        this.encodeStringItem(16, rqac.getApplicationContext());
        this.encodePCs(pcItemType, rqac.getPresentationContexts());
        this.encodeUserInfo(rqac);
        this.writePDU(pdulen);
    }

    private void writePDU(int pdulen) throws IOException {
        this.out.write(this.buf, 0, 6 + pdulen);
        this.out.flush();
        this.pdvpos = 6;
        this.pos = 12;
    }

    private void put(int ch) {
        this.buf[this.pos++] = (byte)ch;
    }

    private void put(byte[] b, int off, int len) {
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
    }

    private void put(byte[] b) {
        this.put(b, 0, b.length);
    }

    private void putShort(int v) {
        this.buf[this.pos++] = (byte)(v >> 8);
        this.buf[this.pos++] = (byte)v;
    }

    private void putInt(int v) {
        this.buf[this.pos++] = (byte)(v >> 24);
        this.buf[this.pos++] = (byte)(v >> 16);
        this.buf[this.pos++] = (byte)(v >> 8);
        this.buf[this.pos++] = (byte)v;
    }

    private void putASCIIString(String s) {
        try {
            byte[] bytes = s.getBytes("US-ASCII");
            System.arraycopy(bytes, 0, this.buf, this.pos, bytes.length);
            this.pos += bytes.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("unreachable; US-ASCII is always available", e);
        }
    }

    private void encodeAET(String aet) {
        int endpos = this.pos + 16;
        this.putASCIIString(aet);
        while (this.pos < endpos) {
            this.put(32);
        }
    }

    private void encodeASCIIString(String s) {
        this.putShort(s.length());
        this.putASCIIString(s);
    }

    private void encodeItemHeader(int type, int len) {
        this.put(type);
        this.put(0);
        this.putShort(len);
    }

    private void encodeStringItem(int type, String s) {
        if (s == null) {
            return;
        }
        this.encodeItemHeader(type, s.length());
        this.putASCIIString(s);
    }

    private void encodePCs(int pcItemType, Collection<PresentationContext> pcs) {
        for (PresentationContext pc : pcs) {
            this.encodeItemHeader(pcItemType, pc.length());
            this.put(pc.getPCID());
            this.put(0);
            this.put(pc.getResult());
            this.put(0);
            this.encodeStringItem(48, pc.getAbstractSyntax());
            for (String tsuid : pc.getTransferSyntaxes()) {
                this.encodeStringItem(64, tsuid);
            }
        }
    }

    private void encodeUserInfo(AAssociateRQAC rqac) {
        this.encodeItemHeader(80, rqac.userInfoLength());
        this.encodeMaxPDULength(rqac.getMaxPDULength());
        this.encodeStringItem(82, rqac.getImplClassUID());
        if (rqac.isAsyncOps()) {
            this.encodeAsyncOpsWindow(rqac);
        }
        for (RoleSelection rs : rqac.getRoleSelections()) {
            this.encodeRoleSelection(rs);
        }
        this.encodeStringItem(85, rqac.getImplVersionName());
        for (ExtendedNegotiation en : rqac.getExtendedNegotiations()) {
            this.encodeExtendedNegotiation(en);
        }
        for (CommonExtendedNegotiation cen : rqac.getCommonExtendedNegotiations()) {
            this.encodeCommonExtendedNegotiation(cen);
        }
        if (rqac instanceof AAssociateRQ) {
            this.encodeUserIdentityRQ(((AAssociateRQ)rqac).getUserIdentity());
        } else {
            this.encodeUserIdentityAC(((AAssociateAC)rqac).getUserIdentity());
        }
    }

    private void encodeRoleSelection(RoleSelection selection) {
        this.encodeItemHeader(84, selection.length());
        this.encodeASCIIString(selection.getSOPClassUID());
        this.put(selection.isSCU() ? 1 : 0);
        this.put(selection.isSCP() ? 1 : 0);
    }

    private void encodeExtendedNegotiation(ExtendedNegotiation extNeg) {
        this.encodeItemHeader(86, extNeg.length());
        this.encodeASCIIString(extNeg.getSOPClassUID());
        this.put(extNeg.getInformation());
    }

    private void encodeCommonExtendedNegotiation(CommonExtendedNegotiation extNeg) {
        this.encodeItemHeader(87, extNeg.length());
        this.encodeASCIIString(extNeg.getSOPClassUID());
        this.encodeASCIIString(extNeg.getServiceClassUID());
        for (String cuid : extNeg.getRelatedGeneralSOPClassUIDs()) {
            this.encodeASCIIString(cuid);
        }
    }

    private void encodeAsyncOpsWindow(AAssociateRQAC rqac) {
        this.encodeItemHeader(83, 4);
        this.putShort(rqac.getMaxOpsInvoked());
        this.putShort(rqac.getMaxOpsPerformed());
    }

    private void encodeMaxPDULength(int maxPDULength) {
        this.encodeItemHeader(81, 4);
        this.putInt(maxPDULength);
    }

    private void encodeUserIdentityRQ(UserIdentityRQ userIdentity) {
        if (userIdentity == null) {
            return;
        }
        this.encodeItemHeader(88, userIdentity.length());
        this.put(userIdentity.getUserIdentityType());
        this.put(userIdentity.isPositiveResponseRequested() ? 1 : 0);
        this.encodeBytes(userIdentity.getPrimaryField());
        this.encodeBytes(userIdentity.getSecondaryField());
    }

    private void encodeUserIdentityAC(UserIdentityAC userIdentity) {
        if (userIdentity == null) {
            return;
        }
        this.encodeItemHeader(89, userIdentity.length());
        this.encodeBytes(userIdentity.getServerResponse());
    }

    private void encodeBytes(byte[] b) {
        this.putShort(b.length);
        this.put(b, 0, b.length);
    }

    private int free() {
        return this.maxpdulen + 6 - this.pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDIMSE(int pcid, DicomObject cmd, DataWriter dataWriter, String tsuid) throws IOException {
        if (log.isInfoEnabled()) {
            log.info(this.as.toString() + " << " + CommandUtils.toString(cmd, pcid, tsuid));
        }
        if (log.isDebugEnabled()) {
            log.debug("Command:\n" + cmd);
            if (dataWriter instanceof DataWriterAdapter) {
                log.debug("Dataset:\n" + ((DataWriterAdapter)dataWriter).getDataset());
            }
        }
        Object object = this.dimseLock;
        synchronized (object) {
            this.th = Thread.currentThread();
            this.maxpdulen = this.as.getMaxPDULengthSend();
            if (this.buf.length < this.maxpdulen + 6) {
                this.buf = new byte[this.maxpdulen + 6];
            }
            this.pdvpcid = pcid;
            this.pdvcmd = 1;
            DicomOutputStream cmdout = new DicomOutputStream((OutputStream)this);
            cmdout.writeCommand(cmd);
            cmdout.close();
            if (dataWriter != null) {
                if (!this.as.isPackPDV()) {
                    this.as.sendPDataTF();
                } else {
                    this.pdvpos = this.pos;
                    this.pos += 6;
                }
                this.pdvcmd = 0;
                dataWriter.writeTo(this, tsuid);
                this.close();
            }
            this.as.sendPDataTF();
            this.th = null;
        }
    }

    private void encodePDVHeader(int last) {
        int endpos = this.pos;
        int pdvlen = endpos - this.pdvpos - 4;
        this.pos = this.pdvpos;
        this.putInt(pdvlen);
        this.put(this.pdvpcid);
        this.put(this.pdvcmd | last);
        this.pos = endpos;
        if (log.isDebugEnabled()) {
            log.debug(this.as.toString() + " << PDV[len = " + pdvlen + ", pcid = " + this.pdvpcid + ", mch = " + (this.pdvcmd | last) + "]");
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        this.flushPDataTF();
        this.put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int write;
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        int pos = off;
        for (int remaining = len; remaining > 0; remaining -= write) {
            this.flushPDataTF();
            write = Math.min(remaining, this.free());
            this.put(b, pos, write);
            pos += write;
        }
    }

    private void flushPDataTF() throws IOException {
        if (this.free() > 0) {
            return;
        }
        this.encodePDVHeader(0);
        this.as.sendPDataTF();
    }

    @Override
    public void close() {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        this.encodePDVHeader(2);
    }

    @Override
    public void copyFrom(InputStream in, int len) throws IOException {
        int copy;
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        for (int remaining = len; remaining > 0; remaining -= copy) {
            this.flushPDataTF();
            copy = in.read(this.buf, this.pos, Math.min(remaining, this.free()));
            if (copy == -1) {
                throw new EOFException();
            }
            this.pos += copy;
        }
    }

    @Override
    public void copyFrom(InputStream in) throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        while (true) {
            this.flushPDataTF();
            int copy = in.read(this.buf, this.pos, this.free());
            if (copy == -1) {
                return;
            }
            this.pos += copy;
        }
    }
}

