/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net.pdu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.dcm4che2.data.UIDDictionary;

public class PresentationContext {
    public static final int ACCEPTANCE = 0;
    public static final int USER_REJECTION = 1;
    public static final int PROVIDER_REJECTION = 2;
    public static final int ABSTRACT_SYNTAX_NOT_SUPPORTED = 3;
    public static final int TRANSFER_SYNTAX_NOT_SUPPORTED = 4;
    private static final String UNDEFINED = "undefined";
    private static final String[] RESULT = new String[]{"acceptance", "user-rejection", "no-reason (provider rejection)", "abstract-syntax-not-supported (provider rejection)", "transfer-syntaxes-not-supported (provider rejection)"};
    private int pcid;
    private int result;
    private String abstractSyntax;
    private Set<String> transferSyntaxes = new LinkedHashSet<String>();

    public final int getPCID() {
        return this.pcid;
    }

    public final void setPCID(int pcid) {
        this.pcid = pcid;
    }

    public final int getResult() {
        return this.result;
    }

    public boolean isAccepted() {
        return this.result == 0;
    }

    public final void setResult(int result) {
        this.result = result;
    }

    public final String getAbstractSyntax() {
        return this.abstractSyntax;
    }

    public final void setAbstractSyntax(String abstractSyntax) {
        this.abstractSyntax = abstractSyntax;
    }

    public final Set<String> getTransferSyntaxes() {
        return Collections.unmodifiableSet(this.transferSyntaxes);
    }

    public String getTransferSyntax() {
        return this.transferSyntaxes.iterator().next();
    }

    public final boolean addTransferSyntax(String tsuid) {
        if (tsuid == null) {
            throw new NullPointerException();
        }
        return this.transferSyntaxes.add(tsuid);
    }

    public final boolean removeTransferSyntax(String tsuid) {
        return this.transferSyntaxes.remove(tsuid);
    }

    public int length() {
        int len = 4;
        if (this.abstractSyntax != null) {
            len += 4 + this.abstractSyntax.length();
        }
        for (String tsuid : this.transferSyntaxes) {
            len += 4 + tsuid.length();
        }
        return len;
    }

    public String getResultAsString() {
        try {
            return RESULT[this.result];
        }
        catch (IndexOutOfBoundsException e) {
            return UNDEFINED;
        }
    }

    private static StringBuffer promptUID(String uid, StringBuffer sb) {
        return sb.append(uid).append(" - ").append(UIDDictionary.getDictionary().nameOf(uid));
    }

    public StringBuffer toStringBuffer(StringBuffer sb) {
        sb.append("PresentationContext[id = ").append(this.pcid);
        if (this.abstractSyntax != null) {
            sb.append(", as = ");
            PresentationContext.promptUID(this.abstractSyntax, sb);
        } else {
            sb.append(", result = ").append(this.result).append(" - ").append(this.getResultAsString());
        }
        ArrayList<String> tsuids = new ArrayList<String>(this.transferSyntaxes);
        int m = tsuids.size();
        for (int j = 0; j < m; ++j) {
            sb.append("\n    ts = ");
            PresentationContext.promptUID(tsuids.get(j), sb);
        }
        sb.append("\n    ]");
        return sb;
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer()).toString();
    }
}

